/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.jaxrs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/x-www-form-urlencoded", "application/json"})
@Consumes(value={"application/x-www-form-urlencoded", "application/json"})
public class FastJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private Charset charset = IOUtils.UTF8;
    private Class<?>[] clazzes = null;
    private SerializerFeature[] features = new SerializerFeature[0];
    protected SerializeFilter[] filters = new SerializeFilter[0];
    protected String dateFormat;
    @Context
    UriInfo uriInfo;

    public FastJsonProvider() {
    }

    public FastJsonProvider(String charset) {
        this.charset = Charset.forName(charset);
    }

    public FastJsonProvider(Class<?>[] clazzes) {
        this.clazzes = clazzes;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public SerializerFeature[] getFeatures() {
        return this.features;
    }

    public void setFeatures(SerializerFeature ... features) {
        this.features = features;
    }

    public SerializeFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(SerializeFilter ... filters) {
        this.filters = filters;
    }

    protected boolean isValidType(Class<?> type, Annotation[] classAnnotations) {
        if (type == null) {
            return false;
        }
        if (this.clazzes != null) {
            for (Class<?> cls : this.clazzes) {
                if (cls != type) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json") || "x-www-form-urlencoded".equalsIgnoreCase(subtype) || subtype.endsWith("x-www-form-urlencoded");
        }
        return true;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        return this.isValidType(type, annotations);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        SerializerFeature[] serializerFeatures = this.features;
        if (this.uriInfo != null && this.uriInfo.getQueryParameters().containsKey((Object)"pretty")) {
            if (serializerFeatures == null) {
                serializerFeatures = new SerializerFeature[]{SerializerFeature.PrettyFormat};
            } else {
                List<SerializerFeature> featureList = Arrays.asList(serializerFeatures);
                featureList.add(SerializerFeature.PrettyFormat);
                serializerFeatures = featureList.toArray(serializerFeatures);
            }
        }
        String text = JSON.toJSONString(obj, SerializeConfig.globalInstance, this.filters, this.dateFormat, JSON.DEFAULT_GENERATE_FEATURE, serializerFeatures);
        byte[] bytes = text.getBytes(this.charset);
        entityStream.write(bytes);
        entityStream.flush();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        return this.isValidType(type, annotations);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = entityStream.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        return JSON.parseObject(bytes, 0, bytes.length, this.charset.newDecoder(), genericType, new Feature[0]);
    }
}

