/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import java.io.Writer;

public class JSONWriter {
    private final Writer out;
    private final com.alibaba.fastjson2.JSONWriter raw;

    public JSONWriter(Writer out) {
        this.out = out;
        this.raw = com.alibaba.fastjson2.JSONWriter.ofUTF8();
    }

    public void config(SerializerFeature feature, boolean state) {
        JSONWriter.Context ctx = this.raw.getContext();
        switch (feature) {
            case UseISO8601DateFormat: {
                if (!state) break;
                ctx.setDateFormat("iso8601");
                break;
            }
            case WriteMapNullValue: {
                ctx.config(JSONWriter.Feature.WriteNulls, state);
                break;
            }
            case WriteNullListAsEmpty: 
            case WriteNullStringAsEmpty: 
            case WriteNullNumberAsZero: 
            case WriteNullBooleanAsFalse: {
                ctx.config(JSONWriter.Feature.NullAsDefaultValue, state);
                break;
            }
            case BrowserCompatible: {
                ctx.config(JSONWriter.Feature.BrowserCompatible, state);
                break;
            }
            case WriteClassName: {
                ctx.config(JSONWriter.Feature.WriteClassName, state);
                break;
            }
            case WriteNonStringValueAsString: {
                ctx.config(JSONWriter.Feature.WriteNonStringValueAsString, state);
                break;
            }
            case WriteEnumUsingToString: {
                ctx.config(JSONWriter.Feature.WriteEnumUsingToString, state);
                break;
            }
            case NotWriteRootClassName: {
                ctx.config(JSONWriter.Feature.NotWriteRootClassName, state);
                break;
            }
            case IgnoreErrorGetter: {
                ctx.config(JSONWriter.Feature.IgnoreErrorGetter, state);
                break;
            }
            case WriteDateUseDateFormat: {
                if (!state) break;
                ctx.setDateFormat(JSON.DEFFAULT_DATE_FORMAT);
                break;
            }
            case BeanToArray: {
                if (!state) break;
                ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray});
                break;
            }
        }
    }

    public void writeObject(Object object) {
        this.raw.writeAny(object);
    }

    public void flush() throws IOException {
        this.raw.flushTo(this.out);
        this.out.flush();
    }

    public void close() {
        this.raw.close();
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

