/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IoUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] tryDecompress(InputStream raw) throws IOException {
        block5: {
            byte[] byArray;
            GZIPInputStream gis = null;
            ByteArrayOutputStream out = null;
            try {
                gis = new GZIPInputStream(raw);
                out = new ByteArrayOutputStream();
                IoUtils.copy(gis, out);
                byArray = out.toByteArray();
                IoUtils.closeQuietly(out);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IoUtils.closeQuietly(out);
                IoUtils.closeQuietly(gis);
            }
            IoUtils.closeQuietly(gis);
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] tryDecompress(byte[] raw) throws Exception {
        byte[] byArray;
        if (!IoUtils.isGzipStream(raw)) {
            return raw;
        }
        GZIPInputStream gis = null;
        ByteArrayOutputStream out = null;
        try {
            gis = new GZIPInputStream(new ByteArrayInputStream(raw));
            out = new ByteArrayOutputStream();
            IoUtils.copy(gis, out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(out);
            IoUtils.closeQuietly(gis);
            throw throwable;
        }
        IoUtils.closeQuietly(out);
        IoUtils.closeQuietly(gis);
        return byArray;
    }

    public static byte[] tryCompress(String str, String encoding) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(encoding));
            gzip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data.getBytes(encoding));
            os.flush();
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(os);
            throw throwable;
        }
        IoUtils.closeQuietly(os);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IoUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        while (null != (line = reader.readLine())) {
            if (!StringUtils.isNotEmpty(line)) continue;
            list.add(line.trim());
        }
        return list;
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        if (input == null) {
            return "";
        }
        return null == encoding ? IoUtils.toString(new InputStreamReader(input, "UTF-8")) : IoUtils.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IoUtils.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int totalBytes = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            totalBytes += bytesRead;
        }
        return totalBytes;
    }

    public static void delete(File fileOrDir) throws IOException {
        boolean isDeleteOk;
        if (fileOrDir == null) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            IoUtils.cleanDirectory(fileOrDir);
        } else if (fileOrDir.exists() && !(isDeleteOk = fileOrDir.delete())) {
            throw new IOException("delete fail");
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                IoUtils.delete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String source, String target) throws IOException {
        File sf = new File(source);
        if (!sf.exists()) {
            throw new IllegalArgumentException("source file does not exist.");
        }
        File tf = new File(target);
        if (!tf.getParentFile().mkdirs()) {
            throw new RuntimeException("failed to create parent directory.");
        }
        if (!tf.exists() && !tf.createNewFile()) {
            throw new RuntimeException("failed to create target file.");
        }
        FileChannel sc = null;
        FileChannel tc = null;
        try {
            tc = new FileOutputStream(tf).getChannel();
            sc = new FileInputStream(sf).getChannel();
            sc.transferTo(0L, sc.size(), tc);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(sc);
            IoUtils.closeQuietly(tc);
            throw throwable;
        }
        IoUtils.closeQuietly(sc);
        IoUtils.closeQuietly(tc);
    }

    public static boolean isGzipStream(byte[] bytes) {
        int minByteArraySize = 2;
        if (bytes == null || bytes.length < minByteArraySize) {
            return false;
        }
        return 35615 == ((bytes[1] << 8 | bytes[0]) & 0xFFFF);
    }

    public static void closeQuietly(HttpURLConnection connection) {
        if (connection != null) {
            try {
                IoUtils.closeQuietly(connection.getInputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(InputStream input) {
        IoUtils.closeQuietly((Closeable)input);
    }

    public static void closeQuietly(OutputStream output) {
        IoUtils.closeQuietly((Closeable)output);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

