/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx;

import com.alibaba.polardbx.HaConnection;
import com.alibaba.polardbx.HaManager;
import com.alibaba.polardbx.MysqlDriver;
import com.alibaba.polardbx.common.SslInfo;
import com.alibaba.polardbx.common.XClusterInfo;
import com.alibaba.polardbx.common.logging.Log;
import com.alibaba.polardbx.common.logging.LogFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Driver
implements java.sql.Driver {
    private static final Log LOGGER = LogFactory.getLog(Driver.class);
    public static final String URL_PREFIX = "jdbc:polardbx://";
    private static final String CLUSTER_ID_KEY = "clusterId";
    private static final String HA_CHECK_CONNECT_TIMEOUT_MILLIS_KEY = "haCheckConnectTimeoutMillis";
    private static final String HA_CHECK_SOCKET_TIMEOUT_MILLIS_KEY = "haCheckSocketTimeoutMillis";
    private static final String HA_CHECK_INTERVAL_MILLIS_KEY = "haCheckIntervalMillis";
    private static final String CHECK_LEADER_TRANSFERRING_INTERVAL_MILLIS_KEY = "checkLeaderTransferringIntervalMillis";
    private static final String LEADER_TRANSFER_WAIT_TIMEOUT_MILLIS_KEY = "leaderTransferringWaitTimeoutMillis";
    private static final String SMOOTH_SWITCHOVER_KEY = "smoothSwitchover";
    private static final String IGNORE_VIP_KEY = "ignoreVip";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String[] pairs;
        String addresses;
        if (!this.acceptsURL(url)) {
            return null;
        }
        int endPos = url.indexOf(47, URL_PREFIX.length());
        int paramStart = url.indexOf(63, endPos > 0 ? endPos : URL_PREFIX.length());
        String string = endPos > 0 ? url.substring(URL_PREFIX.length(), endPos) : (addresses = paramStart > 0 ? url.substring(URL_PREFIX.length(), paramStart) : url.substring(URL_PREFIX.length()));
        String extraRes = endPos > 0 ? (paramStart > 0 ? url.substring(endPos + 1, paramStart) : url.substring(endPos + 1)) : "";
        String paramStr = paramStart > 0 ? url.substring(paramStart + 1) : "";
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs = paramStr.split("&")) {
            if (pair.isEmpty()) continue;
            String[] kv = pair.split("=");
            if (2 == kv.length) {
                params.put(kv[0], kv[1]);
                continue;
            }
            if (1 == kv.length) {
                params.put(kv[0], "");
                continue;
            }
            throw new IllegalArgumentException("Invalid param: " + pair);
        }
        String user = params.containsKey("user") ? (String)params.get("user") : info.getProperty("user");
        String password = params.containsKey("password") ? (String)params.get("password") : info.getProperty("password");
        long clusterId = params.containsKey(CLUSTER_ID_KEY) ? Long.parseLong((String)params.get(CLUSTER_ID_KEY)) : Long.parseLong(info.getProperty(CLUSTER_ID_KEY, "-1"));
        int haCheckConnectTimeoutMillis = params.containsKey(HA_CHECK_CONNECT_TIMEOUT_MILLIS_KEY) ? Integer.parseInt((String)params.get(HA_CHECK_CONNECT_TIMEOUT_MILLIS_KEY)) : Integer.parseInt(info.getProperty(HA_CHECK_CONNECT_TIMEOUT_MILLIS_KEY, "3000"));
        int haCheckSocketTimeoutMillis = params.containsKey(HA_CHECK_SOCKET_TIMEOUT_MILLIS_KEY) ? Integer.parseInt((String)params.get(HA_CHECK_SOCKET_TIMEOUT_MILLIS_KEY)) : Integer.parseInt(info.getProperty(HA_CHECK_SOCKET_TIMEOUT_MILLIS_KEY, "3000"));
        int haCheckIntervalMillis = params.containsKey(HA_CHECK_INTERVAL_MILLIS_KEY) ? Integer.parseInt((String)params.get(HA_CHECK_INTERVAL_MILLIS_KEY)) : Integer.parseInt(info.getProperty(HA_CHECK_INTERVAL_MILLIS_KEY, "1000"));
        int checkLeaderTransferringIntervalMillis = params.containsKey(CHECK_LEADER_TRANSFERRING_INTERVAL_MILLIS_KEY) ? Integer.parseInt((String)params.get(CHECK_LEADER_TRANSFERRING_INTERVAL_MILLIS_KEY)) : Integer.parseInt(info.getProperty(CHECK_LEADER_TRANSFERRING_INTERVAL_MILLIS_KEY, "100"));
        int leaderTransferringWaitTimeoutMillis = params.containsKey(LEADER_TRANSFER_WAIT_TIMEOUT_MILLIS_KEY) ? Integer.parseInt((String)params.get(LEADER_TRANSFER_WAIT_TIMEOUT_MILLIS_KEY)) : Integer.parseInt(info.getProperty(LEADER_TRANSFER_WAIT_TIMEOUT_MILLIS_KEY, "5000"));
        boolean smoothSwitchover = params.containsKey(SMOOTH_SWITCHOVER_KEY) ? Boolean.parseBoolean((String)params.get(SMOOTH_SWITCHOVER_KEY)) : Boolean.parseBoolean(info.getProperty(SMOOTH_SWITCHOVER_KEY, "true"));
        boolean ignoreVip = params.containsKey(IGNORE_VIP_KEY) ? Boolean.parseBoolean((String)params.get(IGNORE_VIP_KEY)) : Boolean.parseBoolean(info.getProperty(IGNORE_VIP_KEY, "false"));
        XClusterInfo clusterInfo = new XClusterInfo(addresses, user, password, haCheckConnectTimeoutMillis, haCheckSocketTimeoutMillis, haCheckIntervalMillis, checkLeaderTransferringIntervalMillis, leaderTransferringWaitTimeoutMillis, clusterId, null);
        HashMap<String, String> sslSettings = new HashMap<String, String>();
        for (String key : params.keySet()) {
            if (!SslInfo.SSL_PROPERTY_NAMES.contains(key)) continue;
            sslSettings.put(key, (String)params.get(key));
        }
        for (String key : info.stringPropertyNames()) {
            if (!SslInfo.SSL_PROPERTY_NAMES.contains(key)) continue;
            sslSettings.put(key, info.getProperty(key));
        }
        params.remove(CLUSTER_ID_KEY);
        params.remove(HA_CHECK_CONNECT_TIMEOUT_MILLIS_KEY);
        params.remove(HA_CHECK_SOCKET_TIMEOUT_MILLIS_KEY);
        params.remove(HA_CHECK_INTERVAL_MILLIS_KEY);
        params.remove(CHECK_LEADER_TRANSFERRING_INTERVAL_MILLIS_KEY);
        params.remove(LEADER_TRANSFER_WAIT_TIMEOUT_MILLIS_KEY);
        params.remove(SMOOTH_SWITCHOVER_KEY);
        params.remove(IGNORE_VIP_KEY);
        HaManager manager = HaManager.getManager(clusterInfo, sslSettings, ignoreVip);
        long connectTimeout = params.containsKey("connectTimeout") ? (long)Integer.parseInt((String)params.get("connectTimeout")) : 5000L;
        long startMillis = System.currentTimeMillis();
        String leader = manager.getAvailableAddressWithWait(connectTimeout);
        long endMillis = System.currentTimeMillis();
        if (params.containsKey("connectTimeout")) {
            params.put("connectTimeout", Long.toString(startMillis + connectTimeout - endMillis));
        }
        String mysqlParamStr = params.entrySet().stream().map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining("&"));
        String mysqlUrl = "jdbc:mysql://" + leader + '/' + extraRes + (mysqlParamStr.isEmpty() ? "" : '?' + mysqlParamStr);
        LOGGER.debug("create new conn to " + mysqlUrl);
        return new HaConnection(manager, leader, MysqlDriver.DRIVER.connect(mysqlUrl, info), smoothSwitchover);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("no logger");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to register driver", e);
        }
    }
}

