/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.common.logging;

import com.alibaba.polardbx.common.logging.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdk14LoggingImpl
implements Log {
    private Logger log;
    private String loggerName;

    public Jdk14LoggingImpl(String loggerName) {
        this.loggerName = loggerName;
        this.log = Logger.getLogger(loggerName);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    @Override
    public void debug(String s) {
        this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
    }

    @Override
    public void debug(String s, Throwable e) {
        this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
    }

    @Override
    public void info(String msg) {
        this.log.logp(Level.INFO, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
    }

    @Override
    public void info(String s, Throwable e) {
        this.log.logp(Level.INFO, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
    }

    @Override
    public void warn(String s) {
        this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
    }

    @Override
    public void error(String s) {
        this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
    }
}

