/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.dynamic;

import com.alibaba.polardbx.common.XClusterNodeBasic;
import com.alibaba.polardbx.common.logging.Log;
import com.alibaba.polardbx.common.logging.LogFactory;
import com.alibaba.polardbx.shaded.com.google.gson.Gson;
import com.alibaba.polardbx.shaded.com.google.gson.GsonBuilder;
import com.alibaba.polardbx.shaded.com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicConfig {
    private static final Log LOGGER = LogFactory.getLog(DynamicConfig.class);
    public static final Gson GSON = new GsonBuilder().create();
    @SerializedName(value="XCluster")
    private List<XClusterNodeBasic> XCluster;
    @SerializedName(value="PolarDB-X")
    private List<String> PolarDBX;
    private static Map<String, DynamicConfig> configMap = new ConcurrentHashMap<String, DynamicConfig>();

    private DynamicConfig() {
    }

    private static boolean recover(String jsonFile) {
        File bak;
        File file = new File(jsonFile);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("jsonFile must be a file");
        }
        if (!file.exists() && !(bak = new File(jsonFile + ".bak")).isDirectory() && bak.exists()) {
            return bak.renameTo(file);
        }
        return false;
    }

    private static synchronized DynamicConfig reload(String jsonFile) {
        DynamicConfig dynamicConfig;
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        try {
            DynamicConfig config2 = GSON.fromJson((Reader)reader, DynamicConfig.class);
            if (null == config2) {
                throw new IllegalArgumentException("dynamic config must be not null");
            }
            dynamicConfig = config2;
        }
        catch (Throwable config2) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    config2.addSuppressed(throwable);
                }
                throw config2;
            }
            catch (Exception e0) {
                if (!(e0 instanceof FileNotFoundException)) {
                    LOGGER.error("error when load original dynamic file", e0);
                    boolean config2 = new File(jsonFile).delete();
                }
                if (DynamicConfig.recover(jsonFile)) {
                    DynamicConfig dynamicConfig2;
                    BufferedReader reader2 = new BufferedReader(new FileReader(jsonFile));
                    try {
                        DynamicConfig config3 = GSON.fromJson((Reader)reader2, DynamicConfig.class);
                        if (null == config3) {
                            throw new IllegalArgumentException("dynamic config must be not null");
                        }
                        dynamicConfig2 = config3;
                    }
                    catch (Throwable config3) {
                        try {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable) {
                                config3.addSuppressed(throwable);
                            }
                            throw config3;
                        }
                        catch (Exception e1) {
                            LOGGER.error("error when recover and read dynamic file", e1);
                            boolean ignored = new File(jsonFile).delete();
                            return new DynamicConfig();
                        }
                    }
                    reader2.close();
                    return dynamicConfig2;
                }
                return new DynamicConfig();
            }
        }
        reader.close();
        return dynamicConfig;
    }

    public static DynamicConfig load(String jsonFile) {
        return configMap.computeIfAbsent(jsonFile, k -> DynamicConfig.reload(jsonFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String jsonFile) throws IOException {
        DynamicConfig config = configMap.get(jsonFile);
        if (config != null) {
            DynamicConfig dynamicConfig = config;
            synchronized (dynamicConfig) {
                File file = new File(jsonFile);
                if (!file.isDirectory() && file.exists()) {
                    boolean bl;
                    File bak = new File(jsonFile + ".bak");
                    if (!bak.isDirectory() && bak.exists()) {
                        bl = bak.delete();
                    }
                    bl = file.renameTo(bak);
                }
                try (FileWriter writer = new FileWriter(jsonFile);){
                    GSON.toJson((Object)config, (Appendable)writer);
                }
            }
        }
    }

    public List<XClusterNodeBasic> getXCluster() {
        return this.XCluster;
    }

    public List<String> getPolarDBX() {
        return this.PolarDBX;
    }

    public void setXCluster(List<XClusterNodeBasic> XCluster) {
        this.XCluster = XCluster;
    }

    public void setPolarDBX(List<String> polarDBX) {
        this.PolarDBX = polarDBX;
    }
}

