/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class JetCacheExecutor {
    protected static ScheduledExecutorService defaultExecutor;
    protected static ScheduledExecutorService heavyIOExecutor;
    private static int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService defaultExecutor() {
        if (defaultExecutor != null) {
            return defaultExecutor;
        }
        Class<JetCacheExecutor> clazz = JetCacheExecutor.class;
        synchronized (JetCacheExecutor.class) {
            if (defaultExecutor == null) {
                defaultExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r, "JetCacheDefaultExecutor");
                    t.setDaemon(true);
                    return t;
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService heavyIOExecutor() {
        if (heavyIOExecutor != null) {
            return heavyIOExecutor;
        }
        Class<JetCacheExecutor> clazz = JetCacheExecutor.class;
        synchronized (JetCacheExecutor.class) {
            if (heavyIOExecutor == null) {
                heavyIOExecutor = Executors.newScheduledThreadPool(10, r -> {
                    Thread t = new Thread(r, "JetCacheHeavyIOExecutor" + threadCount++);
                    t.setDaemon(true);
                    return t;
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return heavyIOExecutor;
        }
    }

    public static void setDefaultExecutor(ScheduledExecutorService executor) {
        defaultExecutor = executor;
    }

    public static void setHeavyIOExecutor(ScheduledExecutorService heavyIOExecutor) {
        JetCacheExecutor.heavyIOExecutor = heavyIOExecutor;
    }
}

