/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.impl;

import com.alipay.sofa.boot.util.StringUtils;
import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class ComponentHealthChecker
implements HealthChecker {
    @Value(value="${com.alipay.sofa.healthcheck.component.check.retry.count:20}")
    private int retryCount;
    @Value(value="${com.alipay.sofa.healthcheck.component.check.retry.interval:1000}")
    private int retryInterval;
    @Value(value="${com.alipay.sofa.healthcheck.component.check.strict.enabled:true}")
    private boolean strictCheck;
    private SofaRuntimeContext sofaRuntimeContext;

    public ComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @Override
    public Health isHealthy() {
        boolean allPassed = true;
        Health.Builder builder = new Health.Builder();
        for (ComponentInfo componentInfo : this.sofaRuntimeContext.getComponentManager().getComponents()) {
            HealthResult healthy = componentInfo.isHealthy();
            String healthReport = healthy.getHealthReport();
            if (StringUtils.hasText((String)healthReport)) {
                builder.withDetail(healthy.getHealthName(), (Object)healthy.getHealthReport());
            } else {
                builder.withDetail(healthy.getHealthName(), (Object)"passed");
            }
            if (healthy.isHealthy()) continue;
            allPassed = false;
        }
        if (allPassed) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).build();
    }

    @Override
    public String getComponentName() {
        return "SOFABoot-Components";
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public long getRetryTimeInterval() {
        return this.retryInterval;
    }

    @Override
    public boolean isStrictCheck() {
        return this.strictCheck;
    }
}

