/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.impl;

import com.alipay.sofa.boot.constant.SofaBootConstants;
import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.deployment.DeploymentDescriptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModuleHealthChecker
implements ApplicationContextAware,
HealthChecker {
    @Value(value="${com.alipay.sofa.healthcheck.module.check.retry.count:0}")
    private int retryCount;
    @Value(value="${com.alipay.sofa.healthcheck.module.check.retry.interval:1000}")
    private long retryInterval;
    @Value(value="${com.alipay.sofa.healthcheck.module.check.strict.enabled:true}")
    private boolean strictCheck;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Health isHealthy() {
        Health.Builder builder = new Health.Builder();
        ApplicationRuntimeModel application = (ApplicationRuntimeModel)this.applicationContext.getBean(SofaBootConstants.APPLICATION, ApplicationRuntimeModel.class);
        for (DeploymentDescriptor deploymentDescriptor : application.getInstalled()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"passed");
        }
        for (DeploymentDescriptor deploymentDescriptor : application.getAllInactiveDeployments()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"inactive");
        }
        for (DeploymentDescriptor deploymentDescriptor : application.getFailed()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"failed");
        }
        if (application.getFailed().size() == 0) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).build();
    }

    @Override
    public String getComponentName() {
        return "SOFABoot-Modules";
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public long getRetryTimeInterval() {
        return this.retryInterval;
    }

    @Override
    public boolean isStrictCheck() {
        return this.strictCheck;
    }
}

