/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.impl;

import com.alipay.sofa.boot.health.RuntimeHealthChecker;
import com.alipay.sofa.healthcheck.ReadinessCheckListener;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class SofaRuntimeHealthChecker
implements RuntimeHealthChecker {
    @Autowired
    private List<HealthIndicator> healthIndicators;
    @Autowired
    private ReadinessCheckListener readinessCheckListener;

    public SofaRuntimeHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        sofaRuntimeContext.getSofaRuntimeManager().registerRuntimeHealthChecker((RuntimeHealthChecker)this);
    }

    public boolean isReadinessHealth() {
        return this.readinessCheckListener.aggregateReadinessHealth().getStatus().equals((Object)Status.UP);
    }

    public boolean isLivenessHealth() {
        for (HealthIndicator healthIndicator : this.healthIndicators) {
            if (!healthIndicator.health().getStatus().equals((Object)Status.DOWN)) continue;
            return false;
        }
        return true;
    }
}

