/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.core;

import com.alipay.sofa.jraft.ReplicatorGroup;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.InvokeContext;
import com.alipay.sofa.jraft.rpc.RaftClientService;
import com.alipay.sofa.jraft.rpc.RpcClient;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosure;
import com.alipay.sofa.jraft.rpc.impl.AbstractClientService;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Utils;
import com.alipay.sofa.jraft.util.concurrent.DefaultFixedThreadsExecutorGroupFactory;
import com.alipay.sofa.jraft.util.concurrent.FixedThreadsExecutorGroup;
import com.google.protobuf.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public class DefaultRaftClientService
extends AbstractClientService
implements RaftClientService {
    private static final FixedThreadsExecutorGroup APPEND_ENTRIES_EXECUTORS = DefaultFixedThreadsExecutorGroupFactory.INSTANCE.newExecutorGroup(Utils.APPEND_ENTRIES_THREADS_SEND, "Append-Entries-Thread-Send", Utils.MAX_APPEND_ENTRIES_TASKS_PER_THREAD, true);
    private final ConcurrentMap<Endpoint, Executor> appendEntriesExecutorMap = new ConcurrentHashMap<Endpoint, Executor>();
    private NodeOptions nodeOptions;
    private final ReplicatorGroup rgGroup;

    @Override
    protected void configRpcClient(RpcClient rpcClient) {
        rpcClient.registerConnectEventListener(this.rgGroup);
    }

    public DefaultRaftClientService(ReplicatorGroup rgGroup) {
        this.rgGroup = rgGroup;
    }

    @Override
    public synchronized boolean init(RpcOptions rpcOptions) {
        boolean ret = super.init(rpcOptions);
        if (ret) {
            this.nodeOptions = (NodeOptions)rpcOptions;
        }
        return ret;
    }

    @Override
    public Future<Message> preVote(Endpoint endpoint, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, this.nodeOptions.getElectionTimeoutMs());
    }

    @Override
    public Future<Message> requestVote(Endpoint endpoint, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, this.nodeOptions.getElectionTimeoutMs());
    }

    @Override
    public Future<Message> appendEntries(Endpoint endpoint, RpcRequests.AppendEntriesRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.AppendEntriesResponse> done) {
        Executor executor = this.appendEntriesExecutorMap.computeIfAbsent(endpoint, k -> APPEND_ENTRIES_EXECUTORS.next());
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs, executor);
    }

    @Override
    public Future<Message> getFile(Endpoint endpoint, RpcRequests.GetFileRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.GetFileResponse> done) {
        InvokeContext ctx = new InvokeContext();
        ctx.put("invoke.crc.switch", true);
        return this.invokeWithDone(endpoint, (Message)request, ctx, done, timeoutMs);
    }

    @Override
    public Future<Message> installSnapshot(Endpoint endpoint, RpcRequests.InstallSnapshotRequest request, RpcResponseClosure<RpcRequests.InstallSnapshotResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, this.rpcOptions.getRpcInstallSnapshotTimeout());
    }

    @Override
    public Future<Message> timeoutNow(Endpoint endpoint, RpcRequests.TimeoutNowRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.TimeoutNowResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs);
    }

    @Override
    public Future<Message> readIndex(Endpoint endpoint, RpcRequests.ReadIndexRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.ReadIndexResponse> done) {
        return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs);
    }
}

