/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.common;

import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class RpcThreadPoolMonitor {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger("RPC-BOLT-THREADPOOL");
    private ThreadPoolExecutor threadPoolExecutor;
    private AtomicInteger startTimes = new AtomicInteger(0);

    public RpcThreadPoolMonitor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (this.threadPoolExecutor == null) throw new RuntimeException("the rpc threadpool is null");
        if (this.startTimes.intValue() != 0) throw new RuntimeException("rpc started event has been consumeed");
        if (this.startTimes.incrementAndGet() != 1) throw new RuntimeException("rpc started event has been consumeed");
        StringBuilder sb = new StringBuilder();
        sb.append("coreSize:" + this.threadPoolExecutor.getCorePoolSize() + ",");
        sb.append("maxPoolSize:" + this.threadPoolExecutor.getMaximumPoolSize() + ",");
        sb.append("keepAliveTime:" + this.threadPoolExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS) + "\n");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(sb.toString());
        }
        Thread monitor = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        if (LOGGER.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            int blockQueueSize = RpcThreadPoolMonitor.this.threadPoolExecutor.getQueue().size();
                            int activeSize = RpcThreadPoolMonitor.this.threadPoolExecutor.getActiveCount();
                            int poolSize = RpcThreadPoolMonitor.this.threadPoolExecutor.getPoolSize();
                            sb.append("blockQueue:" + blockQueueSize + ", ");
                            sb.append("active:" + activeSize + ", ");
                            sb.append("idle:" + (poolSize - activeSize) + ", ");
                            sb.append("poolSize:" + poolSize);
                            LOGGER.info(sb.toString());
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("Thread pool monitor error", throwable);
                    }
                    try {
                        1.sleep(30000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Error happen the thread pool watch sleep ");
                        continue;
                    }
                    break;
                }
            }
        };
        monitor.setDaemon(true);
        monitor.setName("RPC-RES-MONITOR");
        monitor.start();
    }
}

