/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.config.RegistryConfigureProcessor;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import java.util.HashMap;
import java.util.Map;

public class ConsulConfigurator
implements RegistryConfigureProcessor {
    String parseAddress(String config) {
        String address = null;
        if (StringUtils.isNotEmpty((CharSequence)config) && config.startsWith("consul")) {
            String consulProtocol = "consul://";
            String value = config.substring("consul://".length());
            if (!value.contains("?")) {
                address = value;
            } else {
                int index = value.lastIndexOf(63);
                address = value.substring(0, index);
            }
        }
        return address;
    }

    public Map<String, String> parseParam(String address) {
        String host = this.parseAddress(address);
        String paramString = address.substring(address.indexOf(host) + host.length());
        if (StringUtils.isNotEmpty((CharSequence)paramString) && paramString.startsWith("?")) {
            paramString = paramString.substring(1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (paramString.contains("&")) {
            String[] paramSplit;
            for (String param : paramSplit = paramString.split("&")) {
                Map<String, String> tempMap = this.parseKeyValue(param);
                map.putAll(tempMap);
            }
        } else {
            Map<String, String> tempMap = this.parseKeyValue(paramString);
            map.putAll(tempMap);
        }
        return map;
    }

    private Map<String, String> parseKeyValue(String kv) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)kv)) {
            String[] kvSplit = kv.split("=");
            String key = kvSplit[0];
            String value = kvSplit[1];
            map.put(key, value);
        }
        return map;
    }

    @Override
    public RegistryConfig buildFromAddress(String address) {
        String consulAddress = this.parseAddress(address);
        Map<String, String> map = this.parseParam(address);
        return new RegistryConfig().setAddress(consulAddress).setProtocol("consul").setParameters(map);
    }
}

