/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.DOMHelper;
import com.alipay.sofa.common.xmap.Path;
import com.alipay.sofa.common.xmap.XAnnotatedObject;
import com.alipay.sofa.common.xmap.XGetter;
import com.alipay.sofa.common.xmap.XMap;
import com.alipay.sofa.common.xmap.XSetter;
import com.alipay.sofa.common.xmap.XValueFactory;
import com.alipay.sofa.common.xmap.annotation.XNode;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedMember {
    public final XMap xmap;
    public final XSetter setter;
    public final XGetter getter;
    public Path path;
    public boolean trim;
    public boolean cdata;
    public Class type;
    public XAnnotatedObject xao;
    public XValueFactory valueFactory;

    protected XAnnotatedMember(XMap xmap, XSetter setter, XGetter getter) {
        this.xmap = xmap;
        this.setter = setter;
        this.getter = getter;
    }

    public XAnnotatedMember(XMap xmap, XSetter setter, XGetter getter, XNode anno) {
        this.xmap = xmap;
        this.setter = setter;
        this.getter = getter;
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.cdata = anno.cdata();
        this.type = setter.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        this.xao = xmap.register(this.type);
    }

    protected void setValue(Object instance, Object value) throws Exception {
        this.setter.setValue(instance, value);
    }

    public void process(Context ctx, Element element) throws Exception {
        Object value = this.getValue(ctx, element);
        if (value != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    public void process(Context ctx, Map<String, Object> map, String keyPrefix) throws Exception {
        Object value = this.getValue(ctx, map, keyPrefix);
        if (value != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    public void decode(Object instance, Node base, Document document, List<String> filters) throws Exception {
        if (!this.isFilter(filters)) {
            return;
        }
        Node node = base;
        int len = this.path.segments.length;
        for (int i = 0; i < len; ++i) {
            Node n = DOMHelper.getElementNode(node, this.path.segments[i]);
            if (n == null) {
                Element element = document.createElement(this.path.segments[i]);
                node = node.appendChild(element);
                continue;
            }
            node = n;
        }
        Object object = this.getter.getValue(instance);
        if (object != null && Element.class.isAssignableFrom(object.getClass())) {
            return;
        }
        if (this.xao != null) {
            this.xao.decode(object, node, document, filters);
        } else {
            String value;
            String string = value = object == null ? "" : object.toString();
            if (this.path.attribute != null && this.path.attribute.length() > 0) {
                Attr attr = document.createAttribute(this.path.attribute);
                attr.setNodeValue(value);
                ((Element)node).setAttributeNode(attr);
            } else if (this.cdata) {
                CDATASection cdataSection = document.createCDATASection(value);
                node.appendChild(cdataSection);
            } else {
                node.setTextContent(value);
            }
        }
    }

    protected Object getValue(Context ctx, Element base) throws Exception {
        if (this.xao != null) {
            Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
            return el == null ? null : this.xao.newInstance(ctx, el);
        }
        if (this.type == Element.class) {
            return base;
        }
        String val = DOMHelper.getNodeValue(base, this.path);
        if (val != null) {
            if (this.trim) {
                val = val.trim();
            }
            return this.valueFactory.getValue(ctx, val);
        }
        return null;
    }

    protected Object getValue(Context ctx, Map<String, Object> map, String keyPrefix) throws Exception {
        String key = keyPrefix == null ? this.path.path : keyPrefix + this.path.path;
        Object val = map.get(key);
        Object result = null;
        if (val == null) {
            result = null;
        } else if (val instanceof String) {
            String str = (String)val;
            if (str != null) {
                if (this.trim) {
                    str = str.trim();
                }
                result = this.valueFactory.getValue(ctx, str);
            }
        } else {
            result = val;
        }
        return result;
    }

    protected boolean isFilter(List<String> filters) {
        boolean filter = false;
        filter = filters == null || filters.size() == 0 ? true : filters.contains(this.path.path);
        return filter;
    }
}

