/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.component;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.ext.component.ExtensionInternal;
import com.alipay.sofa.runtime.ext.component.ExtensionPointComponent;
import com.alipay.sofa.runtime.ext.component.ExtensionPointInternal;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.ComponentStatus;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import com.alipay.sofa.service.api.component.Extensible;
import com.alipay.sofa.service.api.component.Extension;
import com.alipay.sofa.service.api.component.ExtensionPoint;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class ExtensionComponent
extends AbstractComponent {
    public static final String LINK_SYMBOL = "$";
    public static final ComponentType EXTENSION_COMPONENT_TYPE = new ComponentType("extension");
    private Extension extension;

    public ExtensionComponent(Extension extension, SofaRuntimeContext sofaRuntimeContext) {
        this.extension = extension;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.componentName = ComponentNameFactory.createComponentName(EXTENSION_COMPONENT_TYPE, extension.getTargetComponentName().getName() + LINK_SYMBOL + ObjectUtils.getIdentityHexString((Object)extension));
    }

    @Override
    public ComponentType getType() {
        return EXTENSION_COMPONENT_TYPE;
    }

    @Override
    public Map<String, Property> getProperties() {
        return null;
    }

    @Override
    public boolean resolve() {
        ComponentName extensionPointComponentName;
        if (this.componentStatus != ComponentStatus.REGISTERED) {
            return false;
        }
        ComponentManager componentManager = this.sofaRuntimeContext.getComponentManager();
        ComponentInfo extensionPointComponentInfo = componentManager.getComponentInfo(extensionPointComponentName = this.extension.getTargetComponentName());
        if (extensionPointComponentInfo != null && extensionPointComponentInfo.isActivated()) {
            this.componentStatus = ComponentStatus.RESOLVED;
            return true;
        }
        return false;
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        ComponentName extensionPointComponentName;
        if (this.componentStatus != ComponentStatus.RESOLVED) {
            return;
        }
        ComponentManager componentManager = this.sofaRuntimeContext.getComponentManager();
        ComponentInfo extensionPointComponentInfo = componentManager.getComponentInfo(extensionPointComponentName = this.extension.getTargetComponentName());
        if (extensionPointComponentInfo == null || !extensionPointComponentInfo.isActivated()) {
            return;
        }
        this.loadContributions(((ExtensionPointComponent)extensionPointComponentInfo).getExtensionPoint(), this.extension);
        Object target = extensionPointComponentInfo.getImplementation().getTarget();
        if (target instanceof Extensible) {
            try {
                ((Extensible)target).registerExtension(this.extension);
            }
            catch (Exception e) {
                throw new ServiceRuntimeException(e);
            }
        } else {
            Method method = ReflectionUtils.findMethod(target.getClass(), (String)"registerExtension", (Class[])new Class[]{Extension.class});
            ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{this.extension});
        }
        this.componentStatus = ComponentStatus.ACTIVATED;
    }

    @Override
    public HealthResult isHealthy() {
        HealthResult healthResult = new HealthResult(this.componentName.getRawName());
        healthResult.setHealthy(true);
        return healthResult;
    }

    public Extension getExtension() {
        return this.extension;
    }

    private void loadContributions(ExtensionPoint extensionPoint, Extension extension) {
        if (extensionPoint != null && extensionPoint.hasContribution()) {
            try {
                Object[] contribs = ((ExtensionPointInternal)extensionPoint).loadContributions((ExtensionInternal)extension);
                ((ExtensionInternal)extension).setContributions(contribs);
            }
            catch (Exception e) {
                SofaLogger.error(e, "Failed to create contribution objects", new Object[0]);
            }
        }
    }
}

