/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springcloud.encodes;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.Map;

public class OpenFeignDigestJsonEncoder
extends AbstractDigestSpanEncoder {
    public String encode(SofaTracerSpan span) throws IOException {
        JsonStringBuilder result = new JsonStringBuilder();
        result.appendBegin("time", (Object)Timestamp.format((long)span.getEndTime()));
        this.appendSlot(result, span);
        return result.toString();
    }

    private void appendSlot(JsonStringBuilder buffer, SofaTracerSpan sofaTracerSpan) {
        Number requestSize;
        SofaTracerSpanContext context = sofaTracerSpan.getSofaTracerSpanContext();
        Map tagStrMap = sofaTracerSpan.getTagsWithStr();
        Map tagNumMap = sofaTracerSpan.getTagsWithNumber();
        buffer.append("local.app", tagStrMap.get("local.app"));
        buffer.append("traceId", (Object)context.getTraceId());
        buffer.append("spanId", (Object)context.getSpanId());
        buffer.append("request.url", tagStrMap.get("request.url"));
        buffer.append("method", tagStrMap.get("method"));
        buffer.append("result.code", tagStrMap.get("result.code"));
        if (StringUtils.isNotBlank((String)((String)tagStrMap.get(Tags.ERROR.getKey())))) {
            buffer.append(Tags.ERROR.getKey(), tagStrMap.get(Tags.ERROR.getKey()));
        }
        buffer.append("req.size.bytes", (Object)((requestSize = (Number)tagNumMap.get("req.size.bytes")) == null ? 0L : requestSize.longValue()));
        Number responseSize = (Number)tagNumMap.get("resp.size.bytes");
        buffer.append("resp.size.bytes", (Object)(responseSize == null ? 0L : responseSize.longValue()));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        buffer.append("time.cost.milliseconds", (Object)duration);
        buffer.append("current.thread.name", tagStrMap.get("current.thread.name"));
        buffer.append("remote.host", tagStrMap.get("remote.host"));
        buffer.append("remote.port", tagStrMap.get("remote.port"));
        buffer.append("component.client.impl", tagStrMap.get("component.client.impl"));
        this.appendBaggage(buffer, context);
    }

    private void appendBaggage(JsonStringBuilder jsonStringBuilder, SofaTracerSpanContext sofaTracerSpanContext) {
        jsonStringBuilder.appendEnd("baggage", (Object)this.baggageSerialized(sofaTracerSpanContext));
    }
}

