/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springcloud.repoters;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class OpenFeignStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    private static JsonStringBuilder buffer = new JsonStringBuilder();

    public OpenFeignStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        statKey.addKey("local.app", (String)tagsWithStr.get("local.app"));
        statKey.addKey("request.url", (String)tagsWithStr.get("request.url"));
        statKey.addKey("method", (String)tagsWithStr.get("method"));
        String resultCode = (String)tagsWithStr.get("result.code");
        boolean success = resultCode != null && resultCode.length() > 0 && this.isHttpOrMvcSuccess(resultCode);
        statKey.setResult(success ? "true" : "false");
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        statKey.setEnd(TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }

    public void print(StatKey statKey, long[] values) {
        if (this.isClosePrint.get()) {
            return;
        }
        if (!(statKey instanceof StatMapKey)) {
            return;
        }
        StatMapKey statMapKey = (StatMapKey)statKey;
        try {
            buffer.reset();
            buffer.appendBegin();
            buffer.append("time", (Object)Timestamp.currentTime());
            buffer.append("stat.key", (Object)this.statKeySplit(statMapKey));
            buffer.append("count", (Object)values[0]);
            buffer.append("total.cost.milliseconds", (Object)values[1]);
            buffer.append("success", (Object)statMapKey.getResult());
            buffer.appendEnd("load.test", (Object)statMapKey.getEnd());
            if (this.appender instanceof LoadTestAwareAppender) {
                ((LoadTestAwareAppender)this.appender).append(buffer.toString(), statMapKey.isLoadTest());
            } else {
                this.appender.append(buffer.toString());
            }
            this.appender.flush();
        }
        catch (Throwable t) {
            SelfLog.error((String)("Stat log <" + this.statTracerName + "> error!"), (Throwable)t);
        }
    }

    private String statKeySplit(StatMapKey statKey) {
        JsonStringBuilder bufferKey = new JsonStringBuilder();
        Map keyMap = statKey.getKeyMap();
        bufferKey.appendBegin();
        for (Map.Entry entry : keyMap.entrySet()) {
            bufferKey.append((String)entry.getKey(), entry.getValue());
        }
        bufferKey.appendEnd(false);
        return bufferKey.toString();
    }
}

