/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.samplers;

import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.samplers.SamplerProperties;
import com.alipay.common.tracer.core.samplers.SamplingStatus;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class SofaTracerPercentageBasedSampler
implements Sampler {
    public static final String TYPE = "PercentageBasedSampler";
    private final AtomicInteger counter = new AtomicInteger(0);
    private final BitSet sampleDecisions;
    private final SamplerProperties configuration;

    public SofaTracerPercentageBasedSampler(SamplerProperties configuration) {
        int outOf100 = (int)configuration.getPercentage();
        this.sampleDecisions = SofaTracerPercentageBasedSampler.randomBitSet(100, outOf100, new Random());
        this.configuration = configuration;
    }

    @Override
    public SamplingStatus sample(SofaTracerSpan sofaTracerSpan) {
        int j;
        int i;
        SamplingStatus samplingStatus = new SamplingStatus();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put("sampler.type", TYPE);
        tags.put("sampler.param", Float.valueOf(this.configuration.getPercentage()));
        tags = Collections.unmodifiableMap(tags);
        samplingStatus.setTags(tags);
        if (this.configuration.getPercentage() == 0.0f) {
            samplingStatus.setSampled(false);
            return samplingStatus;
        }
        if (this.configuration.getPercentage() == 100.0f) {
            samplingStatus.setSampled(true);
            return samplingStatus;
        }
        while (!this.counter.compareAndSet(i = this.counter.get(), j = (i + 1) % 100)) {
        }
        boolean result = this.sampleDecisions.get(i);
        samplingStatus.setSampled(result);
        return samplingStatus;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void close() {
    }

    public static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

