/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.EnvironmentVariableCredentialsProvider;
import com.aliyun.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.credentials.provider.ProfileCredentialsProvider;
import com.aliyun.credentials.provider.SystemPropertiesCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DefaultCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private List<AlibabaCloudCredentialsProvider> defaultProviders = new ArrayList<AlibabaCloudCredentialsProvider>();
    private static final List<AlibabaCloudCredentialsProvider> USER_CONFIGURATION_PROVIDERS = new Vector<AlibabaCloudCredentialsProvider>();

    public DefaultCredentialsProvider() {
        this.defaultProviders.add(new SystemPropertiesCredentialsProvider());
        this.defaultProviders.add(new EnvironmentVariableCredentialsProvider());
        if (AuthUtils.environmentEnableOIDC()) {
            this.defaultProviders.add(new OIDCRoleArnCredentialProvider(AuthUtils.getEnvironmentRoleArn(), AuthUtils.getEnvironmentOIDCProviderArn(), AuthUtils.getEnvironmentOIDCTokenFilePath()));
        }
        this.defaultProviders.add(new ProfileCredentialsProvider());
        String roleName = AuthUtils.getEnvironmentECSMetaData();
        if (roleName != null) {
            this.defaultProviders.add(new EcsRamRoleCredentialProvider(roleName));
        }
    }

    @Override
    public CredentialModel getCredentials() {
        CredentialModel credential;
        if (USER_CONFIGURATION_PROVIDERS.size() > 0) {
            for (AlibabaCloudCredentialsProvider provider : USER_CONFIGURATION_PROVIDERS) {
                credential = provider.getCredentials();
                if (null == credential) continue;
                return credential;
            }
        }
        for (AlibabaCloudCredentialsProvider provider : this.defaultProviders) {
            credential = provider.getCredentials();
            if (null == credential) continue;
            return credential;
        }
        throw new CredentialException("not found credentials");
    }

    public static boolean addCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.add(provider);
    }

    public static boolean removeCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.remove(provider);
    }

    public static boolean containsCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.contains(provider);
    }

    public static void clearCredentialsProvider() {
        USER_CONFIGURATION_PROVIDERS.clear();
    }
}

