/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients;

import com.aliyun.dts.subscribe.clients.common.Checkpoint;
import com.aliyun.dts.subscribe.clients.common.Util;
import com.aliyun.dts.subscribe.clients.metastore.MetaStore;
import com.aliyun.dts.subscribe.clients.metrics.DTSMetrics;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.TopicPartition;

public class ConsumerContext {
    private Properties properties;
    private String brokerUrl;
    private String topic;
    private String sid;
    private String user;
    private String password;
    private String initialCheckpoint;
    private boolean isForceUseCheckpoint;
    private ConsumerSubscribeMode subscribeMode;
    private Collection<TopicPartition> topicPartitions;
    private MetaStore<Checkpoint> userRegisteredStore;
    private long checkpointCommitInterval = 5000L;
    private DTSMetrics dtsMetrics;
    private AtomicBoolean exited = new AtomicBoolean(false);

    public ConsumerContext(String brokerUrl, String topic, String sid, String userName, String password, String initialCheckpoint, ConsumerSubscribeMode subscribeMode) {
        this.properties = new Properties();
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        this.sid = sid;
        this.user = userName;
        this.password = password;
        this.initialCheckpoint = initialCheckpoint;
        this.subscribeMode = subscribeMode;
        this.dtsMetrics = new DTSMetrics();
    }

    public boolean isExited() {
        return this.exited.get();
    }

    public synchronized void exit() {
        this.dtsMetrics.close();
        this.exited.set(true);
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Checkpoint getInitialCheckpoint() {
        return Util.parseCheckpoint(this.initialCheckpoint);
    }

    public void setInitialCheckpoint(String initialCheckpoint) {
        this.initialCheckpoint = initialCheckpoint;
    }

    public boolean isForceUseCheckpoint() {
        return this.isForceUseCheckpoint;
    }

    public void setForceUseCheckpoint(boolean isForceUseCheckpoint) {
        this.isForceUseCheckpoint = isForceUseCheckpoint;
    }

    public ConsumerSubscribeMode getSubscribeMode() {
        return this.subscribeMode;
    }

    public void setSubscribeMode(ConsumerSubscribeMode subscribeMode) {
        this.subscribeMode = subscribeMode;
    }

    public Collection<TopicPartition> getTopicPartitions() {
        return this.topicPartitions;
    }

    public void setTopicPartitions(Collection<TopicPartition> topicPartitions) {
        this.topicPartitions = topicPartitions;
    }

    public boolean hasValidTopicPartitions() {
        return this.topicPartitions != null && this.topicPartitions.size() > 0;
    }

    public MetaStore<Checkpoint> getUserRegisteredStore() {
        return this.userRegisteredStore;
    }

    public void setUserRegisteredStore(MetaStore<Checkpoint> userRegisteredStore) {
        this.userRegisteredStore = userRegisteredStore;
    }

    public Properties getKafkaProperties() {
        this.properties.setProperty("user", this.user);
        this.properties.setProperty("password", this.password);
        this.properties.setProperty("sid", this.sid);
        this.properties.setProperty("group", this.sid);
        this.properties.setProperty("kafkaTopic", this.topic);
        this.properties.setProperty("broker", this.brokerUrl);
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getGroupID() {
        return this.sid;
    }

    public long getCheckpointCommitInterval() {
        return this.checkpointCommitInterval;
    }

    public void setCheckpointCommitInterval(long checkpointCommitInterval) {
        this.checkpointCommitInterval = checkpointCommitInterval;
    }

    public DTSMetrics getDtsMetrics() {
        return this.dtsMetrics;
    }

    public static enum ConsumerSubscribeMode {
        ASSIGN,
        SUBSCRIBE,
        UNKNOWN;

    }
}

