/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryWithNamePrefix
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;

    public ThreadFactoryWithNamePrefix(String poolPrefix) {
        this(poolPrefix, false);
    }

    public ThreadFactoryWithNamePrefix(String poolPrefix, boolean daemon) {
        this.daemon = daemon;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = poolPrefix + POOL_NUMBER.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.daemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

