/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record.value;

import com.aliyun.dts.subscribe.clients.record.value.UnixTimestamp;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import com.aliyun.dts.subscribe.clients.record.value.ValueType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import sun.util.calendar.ZoneInfoFile;

public class DateTime
implements Value<String> {
    private static Set<String> timeZoneNames = new HashSet<String>();
    private static Set<String> commonEraNames = new HashSet<String>(17);
    private static final String BC = "BC";
    private static final String AD = "AD";
    public static final int SEG_NEGATIVE = 1;
    public static final int SEG_YEAR = 2;
    public static final int SEG_MONTH = 4;
    public static final int SEG_DAY = 8;
    public static final int SEG_HOUR = 16;
    public static final int SEG_MINITE = 32;
    public static final int SEG_SECOND = 64;
    public static final int SEG_NAONS = 128;
    public static final int SEG_TIMEZONE = 256;
    public static final int SEG_COMMON_ERA = 512;
    public static final int SEG_TIME = 112;
    public static final int SEG_TIME_NAONS = 240;
    public static final int SEG_DATE = 14;
    public static final int SEG_DATETIME = 126;
    public static final int SEG_DATETIME_NAONS = 254;
    public static final int SEG_DATETIME_NAONS_TZ = 510;
    public static final int SEG_DATETIME_NAONS_TZ_ERA = 1022;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int naons;
    private String datetime;
    private String timeZone;
    private String commonEra;
    private int segments;

    public DateTime() {
    }

    public DateTime(String jdbcDatetime, int segments) {
        this.segments = segments;
        this.parseJdbcDatetime(jdbcDatetime);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATETIME;
    }

    @Override
    public String getData() {
        return this.toString();
    }

    public boolean isNegative() {
        return 0 != (this.segments & 1);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        if (year < 0) {
            this.setSegments(1);
        }
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        if (day < 0) {
            this.setSegments(1);
        }
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour < 0) {
            this.setSegments(1);
        }
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute < 0) {
            this.setSegments(1);
        }
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        if (second < 0) {
            this.setSegments(1);
        }
        this.second = second;
    }

    public int getNaons() {
        return this.naons;
    }

    public void setNaons(int naons) {
        if (naons < 0) {
            this.setSegments(1);
        }
        this.naons = naons;
    }

    public String getCommonEra() {
        return this.commonEra;
    }

    public void setCommonEra(String commonEra) {
        if (null != commonEra) {
            this.setSegments(512);
            this.commonEra = commonEra;
        }
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public int getSegments() {
        return this.segments;
    }

    public void setSegments(int segments) {
        this.segments |= segments;
    }

    public void clearSegments(int segments) {
        this.segments &= ~segments;
    }

    @Override
    public String toString() {
        return this.toJdbcString(this.segments);
    }

    public boolean isSet(int segPart) {
        return this.isSet(this.segments, segPart);
    }

    public boolean isSet(int segments, int segPart) {
        return 0 != (segments & segPart);
    }

    public UnixTimestamp toUnixTimestampValue() throws ParseException {
        long timestamp = this.toUnixTimestamp();
        String timestampString = String.valueOf(timestamp);
        String timestampSec = timestampString.substring(0, 10);
        String timestampMicro = "0";
        if (timestampString.length() > 10) {
            timestampMicro = timestampString.substring(10, timestampString.length());
        }
        return new UnixTimestamp(Long.parseLong(timestampSec), Integer.parseInt(timestampMicro));
    }

    public long toUnixTimestamp() throws ParseException {
        String parseTimeZone = this.getTimeZone();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (null == parseTimeZone || parseTimeZone.trim().isEmpty()) {
            Date date = sdf.parse(this.toJdbcString(254));
            return date.getTime();
        }
        if (parseTimeZone.startsWith("GMT") && parseTimeZone.substring(3).length() == 5) {
            parseTimeZone = "GMT+0" + parseTimeZone.substring(4);
        }
        if (parseTimeZone.length() == 5) {
            parseTimeZone = "+0" + parseTimeZone.substring(1);
        }
        ZoneId zoneId = ZoneId.of(parseTimeZone);
        TimeZone timeZone = TimeZone.getTimeZone(zoneId);
        sdf.setTimeZone(timeZone);
        Date date = sdf.parse(this.toJdbcString(254));
        return date.getTime() - (long)timeZone.getRawOffset();
    }

    public String toJdbcString(int segments) {
        StringBuffer datatimeBuf = new StringBuffer(32);
        if (this.isSet(segments, 2)) {
            int yearV = this.year > 0 ? this.year : -this.year;
            String yearZeros = "0000";
            String yearString = Integer.toString(yearV);
            if (yearV < 1000) {
                yearString = yearZeros.substring(0, 4 - yearString.length()) + yearString;
            }
            datatimeBuf.append(yearString);
        }
        if (this.isSet(segments, 4)) {
            int monthV;
            datatimeBuf.append("-");
            int n = monthV = this.month > 0 ? this.month : -this.month;
            if (monthV < 10) {
                datatimeBuf.append("0").append(monthV);
            } else {
                datatimeBuf.append(monthV);
            }
        }
        if (this.isSet(segments, 8)) {
            int dayV;
            if (datatimeBuf.length() > 0) {
                datatimeBuf.append("-");
            }
            int n = dayV = this.day > 0 ? this.day : -this.day;
            if (dayV < 10) {
                datatimeBuf.append("0").append(dayV);
            } else {
                datatimeBuf.append(dayV);
            }
        }
        if (this.isSet(segments, 16)) {
            int hourV;
            if (datatimeBuf.length() > 0) {
                datatimeBuf.append(" ");
            }
            int n = hourV = this.hour > 0 ? this.hour : -this.hour;
            if (hourV < 10) {
                datatimeBuf.append("0").append(hourV);
            } else {
                datatimeBuf.append(hourV);
            }
        }
        if (this.isSet(segments, 32)) {
            int minuteV;
            datatimeBuf.append(":");
            int n = minuteV = this.minute > 0 ? this.minute : -this.minute;
            if (minuteV < 10) {
                datatimeBuf.append("0").append(minuteV);
            } else {
                datatimeBuf.append(minuteV);
            }
        }
        if (this.isSet(segments, 64)) {
            int secondV;
            datatimeBuf.append(":");
            int n = secondV = this.second > 0 ? this.second : -this.second;
            if (secondV < 10) {
                datatimeBuf.append("0").append(secondV);
            } else {
                datatimeBuf.append(secondV);
            }
        }
        if (this.isSet(segments, 128)) {
            int truncIndex;
            String zeros = "000000000";
            int naonsV = this.naons > 0 ? this.naons : -this.naons;
            String naonsString = Integer.toString(naonsV);
            naonsString = zeros.substring(0, 9 - naonsString.length()) + naonsString;
            char[] nanosChar = new char[naonsString.length()];
            naonsString.getChars(0, naonsString.length(), nanosChar, 0);
            for (truncIndex = 8; nanosChar[truncIndex] == '0' && truncIndex > 0; --truncIndex) {
            }
            naonsString = new String(nanosChar, 0, truncIndex + 1);
            datatimeBuf.append(".").append(naonsString);
        }
        if (this.isSet(segments, 256) && this.timeZone != null) {
            datatimeBuf.append(" ").append(this.timeZone);
        }
        if (this.isSet(segments, 512) && null != this.commonEra) {
            datatimeBuf.append(" ").append(this.commonEra);
        }
        if (this.isSet(segments, 1)) {
            return "-" + datatimeBuf.toString();
        }
        return datatimeBuf.toString();
    }

    protected final int upMicroToNaons(int time, int n) {
        for (int i = 0; i < n; ++i) {
            time *= 10;
        }
        return time;
    }

    protected boolean isEffectiveTimeZone(String timeZone) {
        if (null == timeZone || timeZone.length() <= 0) {
            return false;
        }
        if (StringUtils.startsWith((CharSequence)timeZone, (CharSequence)"GMT") || StringUtils.startsWith((CharSequence)timeZone, (CharSequence)"UTC")) {
            return true;
        }
        char c = timeZone.charAt(0);
        if ('-' == c || '+' == c) {
            for (int i = 1; i < timeZone.length(); ++i) {
                if ('0' <= timeZone.charAt(i) && '9' >= timeZone.charAt(i) || ':' == timeZone.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return timeZoneNames.contains(timeZone.toLowerCase());
    }

    protected void parseJdbcDatetime(String datetime) {
        String commonEra;
        if (null == datetime || datetime.trim().isEmpty()) {
            throw new IllegalArgumentException("datetime is null or empty.");
        }
        if (this.isSet(512) && datetime.length() > 2 && commonEraNames.contains(commonEra = datetime.substring(datetime.length() - 2))) {
            this.setCommonEra(commonEra);
            datetime = datetime.substring(0, datetime.length() - 2).trim();
        }
        if (this.isSet(256)) {
            String timeZone;
            int index = -1;
            for (int i = datetime.length() - 1; i >= 0; --i) {
                char lc;
                char c = datetime.charAt(i);
                if (' ' != c && '+' != c && '-' != c || i > 1 && ((lc = datetime.charAt(i - 1)) >= 'a' && lc <= 'z' || lc >= 'A' && lc <= 'Z')) continue;
                index = i;
                break;
            }
            if (index >= 0 && this.isEffectiveTimeZone((timeZone = datetime.substring(index)).trim())) {
                this.setTimeZone(timeZone.trim());
                datetime = datetime.substring(0, datetime.length() - timeZone.length()).trim();
            }
        }
        int[] ret = new int[7];
        int j = 0;
        int m = 0;
        int n = 0;
        byte[] bytes = datetime.getBytes();
        boolean microMode = false;
        for (int i = 0; i < bytes.length && j < bytes.length; ++i) {
            if (48 <= bytes[i] && 57 >= bytes[i]) {
                m *= 10;
                m += bytes[i] - 48;
                ++n;
                continue;
            }
            if (false == n) continue;
            ret[j] = m;
            if (microMode) {
                ret[j] = this.upMicroToNaons(m, 9 - n);
            }
            m = 0;
            n = 0;
            ++j;
            microMode = 46 == bytes[i];
        }
        if (n != 0) {
            ret[j] = m;
            if (microMode) {
                ret[j] = this.upMicroToNaons(m, 9 - n);
            }
        }
        int index = 0;
        if (this.isSet(2)) {
            this.setYear(ret[index++]);
        }
        if (this.isSet(4)) {
            this.setMonth(ret[index++]);
        }
        if (this.isSet(8)) {
            this.setDay(ret[index++]);
        }
        if (this.isSet(16)) {
            this.setHour(ret[index++]);
        }
        if (this.isSet(32)) {
            this.setMinute(ret[index++]);
        }
        if (this.isSet(64)) {
            this.setSecond(ret[index++]);
        }
        if (this.isSet(128)) {
            this.setNaons(ret[index++]);
        }
        if (45 == bytes[0]) {
            this.setSegments(1);
        }
    }

    public static boolean isZeroDate(String value) {
        return "0000-00-00".equalsIgnoreCase(value) || "0000-00-00 00:00:00".equalsIgnoreCase(value) || "0000-00-00 00:00:00.0".equalsIgnoreCase(value) || "0000-00-00 00:00:00.00".equalsIgnoreCase(value) || "0000-00-00 00:00:00.000".equalsIgnoreCase(value) || "0000-00-00 00:00:00.0000".equalsIgnoreCase(value) || "0000-00-00 00:00:00.00000".equalsIgnoreCase(value) || "0000-00-00 00:00:00.000000".equalsIgnoreCase(value);
    }

    @Override
    public long size() {
        return StringUtils.length((CharSequence)this.datetime) + StringUtils.length((CharSequence)this.timeZone) + 32;
    }

    static {
        for (Map.Entry<String, String> kv : ZoneInfoFile.getAliasMap().entrySet()) {
            timeZoneNames.add(kv.getKey().toLowerCase());
            timeZoneNames.add(kv.getValue().toLowerCase());
        }
        commonEraNames.add(AD);
        commonEraNames.add("ad");
        commonEraNames.add("bc");
        commonEraNames.add(BC);
        commonEraNames.add(" AD");
        commonEraNames.add(" ad");
        commonEraNames.add(" bc");
        commonEraNames.add(" BC");
    }
}

