/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record.value;

import com.aliyun.dts.subscribe.clients.common.BytesUtil;
import com.aliyun.dts.subscribe.clients.common.JDKCharsetMapper;
import com.aliyun.dts.subscribe.clients.common.function.SwallowException;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import com.aliyun.dts.subscribe.clients.record.value.ValueType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;

public class StringValue
implements Value<ByteBuffer> {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private ByteBuffer data;
    private String charset;

    public StringValue(ByteBuffer data, String charset) {
        this.data = data;
        this.charset = charset;
    }

    public StringValue(String data) {
        this(ByteBuffer.wrap(SwallowException.callAndThrowRuntimeException(() -> data.getBytes(DEFAULT_CHARSET))), DEFAULT_CHARSET);
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public ValueType getType() {
        return ValueType.STRING;
    }

    @Override
    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public String toString() {
        if (StringUtils.isEmpty((CharSequence)this.charset)) {
            return BytesUtil.byteBufferToHexString(this.data);
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)this.charset)) {
                return new String(this.data.array(), this.charset);
            }
            return new String(this.data.array());
        }
        catch (UnsupportedEncodingException e1) {
            try {
                return new String(this.data.array(), JDKCharsetMapper.getJDKECharset(this.charset));
            }
            catch (UnsupportedEncodingException e2) {
                return this.charset + "_'" + BytesUtil.byteBufferToHexString(this.data) + "'";
            }
        }
    }

    public String toString(String targetCharset) {
        return "to impl";
    }

    @Override
    public long size() {
        if (null != this.data) {
            return this.data.capacity();
        }
        return 0L;
    }
}

