/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class TableName
implements Comparable<TableName> {
    private static final Set<TableName> tableCache = new CopyOnWriteArraySet<TableName>();
    public static final char NAMESPACE_DELIM = ':';
    public static final String VALID_NAMESPACE_REGEX = "(?:[a-zA-Z_0-9]+)";
    public static final String VALID_TABLE_QUALIFIER_REGEX = "(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)";
    public static final String VALID_USER_TABLE_REGEX = "(?:(?:(?:(?:[a-zA-Z_0-9]+)\\:)?)(?:(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)))";
    public static final TableName META_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "meta");
    public static final TableName NAMESPACE_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "namespace");
    public static final String OLD_META_STR = ".META.";
    public static final String OLD_ROOT_STR = "-ROOT-";
    public static final TableName OLD_ROOT_TABLE_NAME = TableName.getADummyTableName("-ROOT-");
    public static final TableName OLD_META_TABLE_NAME = TableName.getADummyTableName(".META.");
    private final byte[] name;
    private final String nameAsString;
    private final byte[] namespace;
    private final String namespaceAsString;
    private final byte[] qualifier;
    private final String qualifierAsString;
    private final boolean systemTable;
    private final int hashCode;

    public static byte[] isLegalFullyQualifiedTableName(byte[] tableName) {
        if (tableName == null || tableName.length <= 0) {
            throw new IllegalArgumentException("Name is null or empty");
        }
        int namespaceDelimIndex = com.google.common.primitives.Bytes.lastIndexOf((byte[])tableName, (byte)58);
        if (namespaceDelimIndex < 0) {
            TableName.isLegalTableQualifierName(tableName);
        } else {
            TableName.isLegalNamespaceName(tableName, 0, namespaceDelimIndex);
            TableName.isLegalTableQualifierName(tableName, namespaceDelimIndex + 1, tableName.length);
        }
        return tableName;
    }

    public static byte[] isLegalTableQualifierName(byte[] qualifierName) {
        TableName.isLegalTableQualifierName(qualifierName, 0, qualifierName.length, false);
        return qualifierName;
    }

    public static byte[] isLegalTableQualifierName(byte[] qualifierName, boolean isSnapshot) {
        TableName.isLegalTableQualifierName(qualifierName, 0, qualifierName.length, isSnapshot);
        return qualifierName;
    }

    public static void isLegalTableQualifierName(byte[] qualifierName, int start, int end) {
        TableName.isLegalTableQualifierName(qualifierName, start, end, false);
    }

    public static void isLegalTableQualifierName(byte[] qualifierName, int start, int end, boolean isSnapshot) {
        if (end - start < 1) {
            throw new IllegalArgumentException(isSnapshot ? "Snapshot" : "Table qualifier must not be empty");
        }
        if (qualifierName[start] == 46 || qualifierName[start] == 45) {
            throw new IllegalArgumentException("Illegal first character <" + qualifierName[start] + "> at 0. " + (isSnapshot ? "Snapshot" : "User-space table") + " qualifiers can only start with 'alphanumeric characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(qualifierName, start, end));
        }
        for (int i = start; i < end; ++i) {
            if (Character.isLetterOrDigit(qualifierName[i]) || qualifierName[i] == 95 || qualifierName[i] == 45 || qualifierName[i] == 46) continue;
            throw new IllegalArgumentException("Illegal character code:" + qualifierName[i] + ", <" + (char)qualifierName[i] + "> at " + i + ". " + (isSnapshot ? "Snapshot" : "User-space table") + " qualifiers can only contain 'alphanumeric characters': i.e. [a-zA-Z_0-9-.]: " + Bytes.toString(qualifierName, start, end));
        }
    }

    public static void isLegalNamespaceName(byte[] namespaceName) {
        TableName.isLegalNamespaceName(namespaceName, 0, namespaceName.length);
    }

    public static void isLegalNamespaceName(byte[] namespaceName, int start, int end) {
        if (end - start < 1) {
            throw new IllegalArgumentException("Namespace name must not be empty");
        }
        for (int i = start; i < end; ++i) {
            if (Character.isLetterOrDigit(namespaceName[i]) || namespaceName[i] == 95) continue;
            throw new IllegalArgumentException("Illegal character <" + namespaceName[i] + "> at " + i + ". Namespaces can only contain 'alphanumeric characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(namespaceName, start, end));
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.nameAsString;
    }

    public byte[] getNamespace() {
        return this.namespace;
    }

    public String getNamespaceAsString() {
        return this.namespaceAsString;
    }

    public String getNameWithNamespaceInclAsString() {
        if (this.getNamespaceAsString().equals(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR)) {
            return NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + ':' + this.getNameAsString();
        }
        return this.getNameAsString();
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public String getQualifierAsString() {
        return this.qualifierAsString;
    }

    public byte[] toBytes() {
        return this.name;
    }

    public boolean isSystemTable() {
        return this.systemTable;
    }

    public String toString() {
        return this.nameAsString;
    }

    private TableName(ByteBuffer namespace, ByteBuffer qualifier) throws IllegalArgumentException {
        this.qualifier = new byte[qualifier.remaining()];
        qualifier.duplicate().get(this.qualifier);
        this.qualifierAsString = Bytes.toString(this.qualifier);
        if (this.qualifierAsString.equals(OLD_ROOT_STR)) {
            throw new IllegalArgumentException("-ROOT- has been deprecated.");
        }
        if (this.qualifierAsString.equals(OLD_META_STR)) {
            throw new IllegalArgumentException(".META. no longer exists. The table has been renamed to " + META_TABLE_NAME);
        }
        if (Bytes.equals(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME, namespace)) {
            this.namespace = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME;
            this.namespaceAsString = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
            this.systemTable = false;
            this.nameAsString = this.qualifierAsString;
            this.name = this.qualifier;
        } else {
            if (Bytes.equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME, namespace)) {
                this.namespace = NamespaceDescriptor.SYSTEM_NAMESPACE_NAME;
                this.namespaceAsString = NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR;
                this.systemTable = true;
            } else {
                this.namespace = new byte[namespace.remaining()];
                namespace.duplicate().get(this.namespace);
                this.namespaceAsString = Bytes.toString(this.namespace);
                this.systemTable = false;
            }
            this.nameAsString = this.namespaceAsString + ':' + this.qualifierAsString;
            this.name = Bytes.toBytes(this.nameAsString);
        }
        this.hashCode = this.nameAsString.hashCode();
        TableName.isLegalNamespaceName(this.namespace);
        TableName.isLegalTableQualifierName(this.qualifier);
    }

    private TableName(String qualifier) {
        this.qualifier = Bytes.toBytes(qualifier);
        this.qualifierAsString = qualifier;
        this.namespace = NamespaceDescriptor.SYSTEM_NAMESPACE_NAME;
        this.namespaceAsString = NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR;
        this.systemTable = true;
        this.nameAsString = this.namespaceAsString + ':' + this.qualifierAsString;
        this.name = this.qualifier;
        this.hashCode = this.nameAsString.hashCode();
    }

    private static TableName createTableNameIfNecessary(ByteBuffer bns, ByteBuffer qns) {
        for (TableName tn : tableCache) {
            if (!Bytes.equals(tn.getQualifier(), qns) || !Bytes.equals(tn.getNamespace(), bns)) continue;
            return tn;
        }
        TableName newTable = new TableName(bns, qns);
        if (tableCache.add(newTable)) {
            return newTable;
        }
        for (TableName tn : tableCache) {
            if (!Bytes.equals(tn.getQualifier(), qns) || !Bytes.equals(tn.getNamespace(), bns)) continue;
            return tn;
        }
        throw new IllegalStateException(newTable + " was supposed to be in the cache");
    }

    private static TableName getADummyTableName(String qualifier) {
        return new TableName(qualifier);
    }

    public static TableName valueOf(String namespaceAsString, String qualifierAsString) {
        if (namespaceAsString == null || namespaceAsString.length() < 1) {
            namespaceAsString = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
        }
        for (TableName tn : tableCache) {
            if (!qualifierAsString.equals(tn.getQualifierAsString()) || !namespaceAsString.equals(tn.getNameAsString())) continue;
            return tn;
        }
        return TableName.createTableNameIfNecessary(ByteBuffer.wrap(Bytes.toBytes(namespaceAsString)), ByteBuffer.wrap(Bytes.toBytes(qualifierAsString)));
    }

    public static TableName valueOf(byte[] fullName) throws IllegalArgumentException {
        for (TableName tn : tableCache) {
            if (!Arrays.equals(tn.getName(), fullName)) continue;
            return tn;
        }
        int namespaceDelimIndex = com.google.common.primitives.Bytes.lastIndexOf((byte[])fullName, (byte)58);
        if (namespaceDelimIndex < 0) {
            return TableName.createTableNameIfNecessary(ByteBuffer.wrap(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME), ByteBuffer.wrap(fullName));
        }
        return TableName.createTableNameIfNecessary(ByteBuffer.wrap(fullName, 0, namespaceDelimIndex), ByteBuffer.wrap(fullName, namespaceDelimIndex + 1, fullName.length - (namespaceDelimIndex + 1)));
    }

    public static TableName valueOf(String name) {
        for (TableName tn : tableCache) {
            if (!name.equals(tn.getNameAsString())) continue;
            return tn;
        }
        int namespaceDelimIndex = name.indexOf(58);
        byte[] nameB = Bytes.toBytes(name);
        if (namespaceDelimIndex < 0) {
            return TableName.createTableNameIfNecessary(ByteBuffer.wrap(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME), ByteBuffer.wrap(nameB));
        }
        return TableName.createTableNameIfNecessary(ByteBuffer.wrap(nameB, 0, namespaceDelimIndex), ByteBuffer.wrap(nameB, namespaceDelimIndex + 1, nameB.length - (namespaceDelimIndex + 1)));
    }

    public static TableName valueOf(byte[] namespace, byte[] qualifier) {
        if (namespace == null || namespace.length < 1) {
            namespace = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME;
        }
        for (TableName tn : tableCache) {
            if (!Arrays.equals(tn.getQualifier(), qualifier) || !Arrays.equals(tn.getNamespace(), namespace)) continue;
            return tn;
        }
        return TableName.createTableNameIfNecessary(ByteBuffer.wrap(namespace), ByteBuffer.wrap(qualifier));
    }

    public static TableName valueOf(ByteBuffer namespace, ByteBuffer qualifier) {
        if (namespace == null || namespace.remaining() < 1) {
            return TableName.createTableNameIfNecessary(ByteBuffer.wrap(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME), qualifier);
        }
        return TableName.createTableNameIfNecessary(namespace, qualifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName tableName = (TableName)o;
        return o.hashCode() == this.hashCode && this.nameAsString.equals(tableName.nameAsString);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(TableName tableName) {
        if (this == tableName) {
            return 0;
        }
        if (this.hashCode < tableName.hashCode()) {
            return -1;
        }
        if (this.hashCode > tableName.hashCode()) {
            return 1;
        }
        return this.nameAsString.compareTo(tableName.getNameAsString());
    }

    @InterfaceAudience.Private
    @Deprecated
    public KeyValue.KVComparator getRowComparator() {
        if (META_TABLE_NAME.equals(this)) {
            return KeyValue.META_COMPARATOR;
        }
        return KeyValue.COMPARATOR;
    }
}

