/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.util;

import com.aliyun.hitsdb.client.util.FileWatcher;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WatchManager {
    private ConcurrentMap<File, FileMonitor> watchers = new ConcurrentHashMap<File, FileMonitor>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private int intervalSeconds = 2;

    public void start() {
        if (this.intervalSeconds > 0) {
            this.executorService.scheduleWithFixedDelay(new WatchRunnable(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        this.executorService.shutdown();
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public void watchFile(File file, FileWatcher watcher) {
        long lastModified = file.lastModified();
        this.watchers.put(file, new FileMonitor(lastModified, watcher));
    }

    private final class FileMonitor {
        private final FileWatcher fileWatcher;
        private volatile long lastModifiedMillis;

        public FileMonitor(long lastModifiedMillis, FileWatcher fileWatcher) {
            this.fileWatcher = fileWatcher;
            this.lastModifiedMillis = lastModifiedMillis;
        }

        private void setLastModifiedMillis(long lastModifiedMillis) {
            this.lastModifiedMillis = lastModifiedMillis;
        }

        public String toString() {
            return "FileMonitor [fileWatcher=" + this.fileWatcher + ", lastModifiedMillis=" + this.lastModifiedMillis + "]";
        }
    }

    private final class WatchRunnable
    implements Runnable {
        private WatchRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : WatchManager.this.watchers.entrySet()) {
                long lastModified;
                File file = (File)entry.getKey();
                FileMonitor fileMonitor = (FileMonitor)entry.getValue();
                if (!this.fileModified(fileMonitor, lastModified = file.lastModified())) continue;
                fileMonitor.lastModifiedMillis = lastModified;
                fileMonitor.fileWatcher.fileModified(file);
            }
        }

        private boolean fileModified(FileMonitor fileMonitor, long lastModifiedMillis) {
            return lastModifiedMillis != fileMonitor.lastModifiedMillis;
        }
    }
}

