/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.model.SubscriptionMeta;
import com.aliyun.mns.model.TopicMessage;
import java.util.List;
import java.util.Vector;

public class CloudPullTopic {
    private CloudTopic rawTopic;
    private Vector<String> queueNameList;
    private Vector<CloudQueue> queueList;
    private Vector<String> tagList;
    private String QUEUE_SUB_NAME_PREFIX;

    private void subscribe(Vector<String> queueNameList) {
        for (int i = 0; i < queueNameList.size(); ++i) {
            String queueName = queueNameList.get(i);
            String queueEndpoint = this.rawTopic.generateQueueEndpoint(queueName);
            String subName = this.QUEUE_SUB_NAME_PREFIX + queueName;
            SubscriptionMeta subMeta = new SubscriptionMeta();
            subMeta.setSubscriptionName(subName);
            subMeta.setNotifyContentFormat(SubscriptionMeta.NotifyContentFormat.SIMPLIFIED);
            subMeta.setNotifyStrategy(SubscriptionMeta.NotifyStrategy.EXPONENTIAL_DECAY_RETRY);
            subMeta.setEndpoint(queueEndpoint);
            this.rawTopic.subscribe(subMeta);
        }
    }

    private void subscribe(Vector<String> queueNameList, Vector<String> tagList) {
        for (int i = 0; i < queueNameList.size(); ++i) {
            String queueName = queueNameList.get(i);
            String queueEndpoint = this.rawTopic.generateQueueEndpoint(queueName);
            String subName = this.QUEUE_SUB_NAME_PREFIX + queueName;
            SubscriptionMeta subMeta = new SubscriptionMeta();
            subMeta.setSubscriptionName(subName);
            subMeta.setNotifyContentFormat(SubscriptionMeta.NotifyContentFormat.SIMPLIFIED);
            subMeta.setNotifyStrategy(SubscriptionMeta.NotifyStrategy.EXPONENTIAL_DECAY_RETRY);
            subMeta.setEndpoint(queueEndpoint);
            String tmpTag = tagList.get(i);
            if (tmpTag != null && tmpTag != "") {
                subMeta.setFilterTag(tmpTag);
            }
            this.rawTopic.subscribe(subMeta);
        }
    }

    public CloudPullTopic(CloudTopic rawTopic, Vector<String> queueNameList, Vector<CloudQueue> queueList) {
        this.rawTopic = rawTopic;
        this.queueNameList = queueNameList;
        this.queueList = queueList;
        this.QUEUE_SUB_NAME_PREFIX = "sub-for-queue-";
        this.subscribe(this.queueNameList);
    }

    public CloudPullTopic(CloudTopic rawTopic, Vector<String> queueNameList, Vector<CloudQueue> queueList, Vector<String> tagList) {
        this.rawTopic = rawTopic;
        this.queueNameList = queueNameList;
        this.queueList = queueList;
        this.tagList = tagList;
        this.QUEUE_SUB_NAME_PREFIX = "sub-for-queue-";
        this.subscribe(this.queueNameList, this.tagList);
    }

    public TopicMessage publishMessage(TopicMessage msg) {
        return this.rawTopic.publishMessage(msg);
    }

    public CloudTopic getRawTopic() {
        return this.rawTopic;
    }

    public void delete() {
        this.delete(true);
    }

    public void delete(boolean needDeleteQueues) {
        this.rawTopic.delete();
        if (needDeleteQueues) {
            for (int i = 0; i < this.queueList.size(); ++i) {
                CloudQueue queue = this.queueList.get(i);
                queue.delete();
            }
        }
    }

    public List<String> getQueueNameList() {
        return this.queueNameList;
    }

    public String getQueueSubNamePrefix() {
        return this.QUEUE_SUB_NAME_PREFIX;
    }

    public void setQueueSubNamePrefix(String queueSubNamePrefix) {
        this.QUEUE_SUB_NAME_PREFIX = queueSubNamePrefix;
    }
}

