/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.BooleanWritable;
import com.aliyun.odps.io.BytesWritable;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.DoubleWritable;
import com.aliyun.odps.io.IntWritable;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Tuple;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TupleReaderWriter {
    private static final byte UNKNOWN = 0;
    private static final byte NULL = 1;
    private static final byte NULLWRITABLE = 2;
    private static final byte BOOLEANWRITABLE = 3;
    private static final byte BYTESWRITABLE = 4;
    private static final byte INTWRITABLE = 5;
    private static final byte LONGWRITABLE = 6;
    private static final byte DATETIMEWRITABLE = 7;
    private static final byte DOUBLEWRITABLE = 8;
    private static final byte TEXT = 9;
    private static final byte TUPLE = 100;
    private static Log LOG = LogFactory.getLog(TupleReaderWriter.class);

    private static byte findType(Writable o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof LongWritable) {
            return 6;
        }
        if (o instanceof IntWritable) {
            return 5;
        }
        if (o instanceof Text) {
            return 9;
        }
        if (o instanceof DoubleWritable) {
            return 8;
        }
        if (o instanceof BooleanWritable) {
            return 3;
        }
        if (o instanceof DatetimeWritable) {
            return 7;
        }
        if (o instanceof BytesWritable) {
            return 4;
        }
        if (o instanceof NullWritable) {
            return 2;
        }
        if (o instanceof Tuple) {
            return 100;
        }
        return 0;
    }

    public static int compare(Writable o1, Writable o2) {
        byte dt1 = TupleReaderWriter.findType(o1);
        byte dt2 = TupleReaderWriter.findType(o2);
        return TupleReaderWriter.compare(o1, o2, dt1, dt2);
    }

    public static int compare(Writable o1, Writable o2, byte dt1, byte dt2) {
        if (dt1 == dt2) {
            switch (dt1) {
                case 1: 
                case 2: {
                    return 0;
                }
                case 3: {
                    return ((BooleanWritable)o1).compareTo((BooleanWritable)o2);
                }
                case 4: {
                    return ((BytesWritable)o1).compareTo((BytesWritable)o2);
                }
                case 5: {
                    return ((IntWritable)o1).compareTo((IntWritable)o2);
                }
                case 6: {
                    return ((LongWritable)o1).compareTo((LongWritable)o2);
                }
                case 7: {
                    return ((DatetimeWritable)o1).compareTo((DatetimeWritable)o2);
                }
                case 8: {
                    return ((DoubleWritable)o1).compareTo((DoubleWritable)o2);
                }
                case 9: {
                    return ((Text)o1).compareTo((Text)o2);
                }
                case 100: {
                    return ((Tuple)o1).compareTo((Tuple)o2);
                }
                case 0: {
                    if (o1 instanceof WritableComparable && o2 instanceof WritableComparable) {
                        return ((WritableComparable)o1).compareTo((WritableComparable)o2);
                    }
                    throw new RuntimeException("ODPS-0730001: Class " + o1.getClass().getName() + " is not comparable");
                }
            }
            throw new RuntimeException("Not support type " + dt1 + " in compare");
        }
        if (dt1 < dt2) {
            return -1;
        }
        return 1;
    }

    public static void readTuple(DataInput in, Tuple t) throws IOException {
        byte b = in.readByte();
        if (b != 100) {
            String msg = "Unexpected data while reading tuple from binary file.";
            throw new IOException(msg);
        }
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            byte type = in.readByte();
            t.append(TupleReaderWriter.readDatum(in, type));
        }
    }

    private static Writable readDatum(DataInput in, byte type) throws IOException {
        switch (type) {
            case 100: {
                int sz = in.readInt();
                if (sz < 0) {
                    throw new IOException("Invalid size " + sz + " for a tuple");
                }
                Tuple tp = new Tuple(sz);
                for (int i = 0; i < sz; ++i) {
                    byte b = in.readByte();
                    tp.set(i, TupleReaderWriter.readDatum(in, b));
                }
                return tp;
            }
            case 1: {
                return null;
            }
            case 5: {
                IntWritable iw = new IntWritable();
                iw.readFields(in);
                return iw;
            }
            case 6: {
                LongWritable lw = new LongWritable();
                lw.readFields(in);
                return lw;
            }
            case 7: {
                DatetimeWritable dtw = new DatetimeWritable();
                dtw.readFields(in);
                return dtw;
            }
            case 8: {
                DoubleWritable dw = new DoubleWritable();
                dw.readFields(in);
                return dw;
            }
            case 3: {
                BooleanWritable bw = new BooleanWritable();
                bw.readFields(in);
                return bw;
            }
            case 4: {
                BytesWritable bsw = new BytesWritable();
                bsw.readFields(in);
                return bsw;
            }
            case 9: {
                Text t = new Text();
                t.readFields(in);
                return t;
            }
            case 2: {
                NullWritable nw = NullWritable.get();
                nw.readFields(in);
                return nw;
            }
            case 0: {
                String clsName = in.readUTF();
                try {
                    Class<?> cls = Class.forName(clsName);
                    Writable w = (Writable)ReflectionUtils.newInstance(cls, null);
                    w.readFields(in);
                    return w;
                }
                catch (RuntimeException re) {
                    LOG.info((Object)re.getMessage());
                    throw new IOException(re);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IOException(cnfe);
                }
            }
        }
        throw new RuntimeException("Unexpected data type " + type + " found in stream.");
    }

    public static void writeTuple(DataOutput out, Tuple t) throws IOException {
        out.writeByte(100);
        int sz = t.size();
        out.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            TupleReaderWriter.writeDatum(out, t.get(i));
        }
    }

    private static void writeDatum(DataOutput out, Writable val) throws IOException {
        byte type = TupleReaderWriter.findType(val);
        switch (type) {
            case 100: {
                Tuple t = (Tuple)val;
                out.writeByte(100);
                int sz = t.size();
                out.writeInt(sz);
                for (int i = 0; i < sz; ++i) {
                    TupleReaderWriter.writeDatum(out, t.get(i));
                }
                break;
            }
            case 1: {
                out.writeByte(1);
                break;
            }
            case 5: {
                out.writeByte(5);
                ((IntWritable)val).write(out);
                break;
            }
            case 6: {
                out.writeByte(6);
                ((LongWritable)val).write(out);
                break;
            }
            case 7: {
                out.writeByte(7);
                ((DatetimeWritable)val).write(out);
                break;
            }
            case 8: {
                out.writeByte(8);
                ((DoubleWritable)val).write(out);
                break;
            }
            case 3: {
                out.writeByte(3);
                ((BooleanWritable)val).write(out);
                break;
            }
            case 4: {
                out.writeByte(4);
                ((BytesWritable)val).write(out);
                break;
            }
            case 9: {
                out.writeByte(9);
                ((Text)val).write(out);
                break;
            }
            case 2: {
                out.writeByte(2);
                ((NullWritable)val).write(out);
                break;
            }
            case 0: {
                out.writeByte(0);
                out.writeUTF(val.getClass().getName());
                val.write(out);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected data type " + type + " found in stream.");
            }
        }
    }

    public static class TupleRawComparator
    extends WritableComparator {
        public TupleRawComparator() {
            super(Tuple.class, true);
        }
    }
}

