/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Function;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Functions
implements Iterable<Function> {
    private RestClient client;
    private Odps odps;

    Functions(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Function get(String functionName) throws OdpsException {
        return this.get(this.getDefaultProjectName(), functionName);
    }

    public Function get(String projectName, String functionName) {
        Function.FunctionModel model = new Function.FunctionModel();
        model.name = functionName;
        return new Function(model, projectName, this.odps);
    }

    public boolean exists(String functionName) throws OdpsException {
        return this.exists(this.odps.getDefaultProject(), functionName);
    }

    public boolean exists(String projectName, String functionName) throws OdpsException {
        Function function = this.get(projectName, functionName);
        try {
            function.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void update(Function func) throws OdpsException {
        this.update(this.getDefaultProjectName(), func);
    }

    public void update(String projectName, Function func) throws OdpsException {
        String ret;
        String resource = ResourceBuilder.buildFunctionResource(projectName, func.getName());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        try {
            ret = JAXBUtils.marshal(func.model, Function.FunctionModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException((Exception)((Object)e));
        }
        this.client.stringRequest(resource, "PUT", null, header, ret);
    }

    public void create(Function func) throws OdpsException {
        this.create(this.getDefaultProjectName(), func);
    }

    public void create(String projectName, Function func) throws OdpsException {
        String ret;
        String resource = ResourceBuilder.buildFunctionsResource(projectName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        try {
            ret = JAXBUtils.marshal(func.model, Function.FunctionModel.class);
        }
        catch (JAXBException e) {
            throw new OdpsException((Exception)((Object)e));
        }
        this.client.stringRequest(resource, "POST", null, header, ret);
    }

    public void delete(String name) throws OdpsException {
        this.delete(this.getDefaultProjectName(), name);
    }

    public void delete(String projectName, String name) throws OdpsException {
        String resource = ResourceBuilder.buildFunctionResource(projectName, name);
        this.client.request(resource, "DELETE", null, null, null);
    }

    @Override
    public Iterator<Function> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<Function> iterator(final String projectName) {
        return new ListIterator<Function>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Function> list() {
                ArrayList<Function> functions = new ArrayList<Function>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                String resource = ResourceBuilder.buildFunctionsResource(projectName);
                try {
                    ListFunctionsResponse resp = Functions.this.client.request(ListFunctionsResponse.class, resource, "GET", this.params);
                    for (Function.FunctionModel model : resp.functions) {
                        Function t = new Function(model, projectName, Functions.this.odps);
                        functions.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return functions;
            }
        };
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @XmlRootElement(name="Functions")
    private static class ListFunctionsResponse {
        @XmlElement(name="Function")
        private List<Function.FunctionModel> functions = new ArrayList<Function.FunctionModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListFunctionsResponse() {
        }
    }
}

