/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Instances;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Shard;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.data.DefaultRecordReader;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.JsonNode;

public class Table
extends LazyLoad {
    private TableModel model;
    private TableSchema tableSchema;
    private String project;
    private RestClient client;
    private boolean isExtendInfoLoaded;
    private boolean isShardInfoLoaded;
    private Odps odps;

    Table(TableModel model, String project, Odps odps) {
        this.model = model;
        this.project = project;
        this.odps = odps;
        this.client = odps.getRestClient();
        this.isExtendInfoLoaded = false;
        this.isShardInfoLoaded = false;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildTableResource(this.project, this.model.name);
        this.model = this.client.request(TableModel.class, resource, "GET");
        this.tableSchema = this.loadSchemaFromJson(((TableModel)this.model).schema.content);
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public String getTableLabel() {
        if (this.model.tableLabel == null) {
            this.lazyLoad();
        }
        return this.model.tableLabel;
    }

    public String getTableID() {
        if (this.model.ID == null) {
            this.lazyLoad();
        }
        return this.model.ID;
    }

    public String getMaxLabel() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.getTableLabel());
        for (Column column : this.tableSchema.getColumns()) {
            labels.add(column.getCategoryLabel());
        }
        return Table.calculateMaxLabel(labels);
    }

    static String calculateMaxLabel(List<String> labels) {
        int maxLevel = 0;
        int category = 45;
        for (String label : labels) {
            char num;
            if (StringUtils.isNullOrEmpty((String)label) || !Character.isDigit(num = label.charAt(label.length() - 1)) || num - 48 < maxLevel) continue;
            if (num - 48 > maxLevel) {
                maxLevel = num - 48;
                category = 45;
            }
            if (label.length() == 1) {
                category = 76;
                continue;
            }
            for (int i = label.length() - 2; i >= 0; --i) {
                int c = label.charAt(i);
                if (!Character.isLetter((char)c)) continue;
                c = Character.toUpperCase((char)c);
                if (category == 45) {
                    category = c;
                    continue;
                }
                if (category == c) continue;
                category = 76;
            }
        }
        if (category == 45 && maxLevel == 0) {
            return "";
        }
        if (category == 45) {
            category = 76;
        }
        return (char)category + "" + maxLevel;
    }

    public Date getLastMetaModifiedTime() {
        if (this.model.lastMetaModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastMetaModifiedTime;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isVirtualView() {
        this.lazyLoad();
        return this.model.isVirtualView;
    }

    public String getViewText() {
        if (this.model.viewText == null) {
            this.lazyLoad();
        }
        return this.model.viewText;
    }

    public Date getLastDataModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public long getSize() {
        this.lazyLoad();
        return this.model.size;
    }

    public long getLife() {
        this.lazyLoad();
        return this.model.life;
    }

    public TableSchema getSchema() {
        if (this.tableSchema == null) {
            this.lazyLoad();
        }
        return this.tableSchema;
    }

    public String getJsonSchema() {
        if (this.model.schema == null || ((TableModel)this.model).schema.content == null) {
            this.lazyLoad();
        }
        return ((TableModel)this.model).schema.content;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.model.isArchived;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.model.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.model.fileNum;
    }

    public Shard getShard() {
        if (this.model.shard == null) {
            this.lazyLoad();
        }
        return this.model.shard;
    }

    public RecordReader read(int limit) throws OdpsException {
        return this.read(null, null, limit);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit) throws OdpsException {
        if (limit < 0) {
            throw new OdpsException("limit number should >= 0.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", null);
        if (partition != null && partition.keys().size() > 0) {
            params.put("partition", partition.toString());
        }
        if (columns != null && columns.size() != 0) {
            String column = "";
            for (String temp : columns) {
                column = column + temp;
                column = column + ",";
            }
            column = column.substring(0, column.lastIndexOf(","));
            params.put("cols", column);
        }
        if (limit != -1) {
            params.put("linenum", String.valueOf(limit));
        }
        String resource = ResourceBuilder.buildTableResource(this.project, this.getName());
        Response resp = this.client.request(resource, "GET", params, null, null);
        return new DefaultRecordReader(new ByteArrayInputStream(resp.getBody()), this.getSchema());
    }

    private TableSchema loadSchemaFromJson(String json) {
        TableSchema s = new TableSchema();
        try {
            JsonNode columnsNode;
            JsonNode tree = JacksonParser.parse(json);
            JsonNode node = tree.get("comment");
            if (node != null && !node.isNull() && node.isTextual()) {
                this.model.comment = node.asText();
            }
            if ((node = tree.get("owner")) != null && !node.isNull() && node.isTextual()) {
                this.model.owner = node.asText();
            }
            if ((node = tree.get("createTime")) != null && !node.isNull()) {
                this.model.createdTime = new Date(node.asLong() * 1000L);
            }
            if ((node = tree.get("lastModifiedTime")) != null && !node.isNull()) {
                this.model.lastModifiedTime = new Date(node.asLong() * 1000L);
            }
            if ((node = tree.get("lastDDLTime")) != null && !node.isNull()) {
                this.model.lastMetaModifiedTime = new Date(node.asLong() * 1000L);
            }
            if ((node = tree.get("isVirtualView")) != null && !node.isNull() && node.isBoolean()) {
                this.model.isVirtualView = node.asBoolean();
            }
            if ((node = tree.get("lifecycle")) != null && !node.isNull()) {
                this.model.life = node.asLong();
            }
            if ((node = tree.get("viewText")) != null && !node.isNull() && node.isTextual()) {
                this.model.viewText = node.asText();
            }
            if ((node = tree.get("size")) != null && !node.isNull()) {
                this.model.size = node.asLong();
            }
            if ((node = tree.get("IsArchived")) != null && !node.isNull() && node.isBoolean()) {
                this.model.isArchived = node.asBoolean();
            }
            if ((node = tree.get("PhysicalSize")) != null && !node.isNull()) {
                this.model.physicalSize = node.asLong();
            }
            if ((node = tree.get("FileNum")) != null && !node.isNull()) {
                this.model.fileNum = node.asLong();
            }
            if ((node = tree.get("shardExist")) != null && !node.isNull()) {
                boolean shardExist = node.asBoolean();
                node = tree.get("shardInfo");
                this.model.shard = shardExist && node != null && !node.isNull() ? Shard.parseShard(node) : null;
            }
            if ((node = tree.get("tableLabel")) != null && !node.isNull()) {
                this.model.tableLabel = node.asText();
                if (this.model.tableLabel.equals("0")) {
                    this.model.tableLabel = "";
                }
            }
            if ((columnsNode = tree.get("columns")) != null && !columnsNode.isNull() && columnsNode.isArray()) {
                for (JsonNode n : columnsNode) {
                    s.addColumn(this.parseColumn(n));
                }
            }
            if ((columnsNode = tree.get("partitionKeys")) != null && !columnsNode.isNull() && columnsNode.isArray()) {
                for (JsonNode n : columnsNode) {
                    s.addPartitionColumn(this.parseColumn(n));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return s;
    }

    public void createPartition(PartitionSpec spec) throws OdpsException {
        this.createPartition(spec, false);
    }

    public void createPartition(PartitionSpec spec, boolean ifNotExists) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getProject()).append(".").append(this.getName());
        sb.append(" ADD");
        if (ifNotExists) {
            sb.append(" IF NOT EXISTS");
        }
        sb.append(" PARTITION (");
        String[] keys = spec.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(spec.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        sb.append(");");
        String taskName = "SQLAddPartitionTask";
        this.runSQL(taskName, sb.toString());
    }

    public void deletePartition(PartitionSpec spec) throws OdpsException {
        this.deletePartition(spec, false);
    }

    public void deletePartition(PartitionSpec spec, boolean ifExists) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getProject()).append(".").append(this.getName());
        sb.append(" DROP");
        if (ifExists) {
            sb.append(" IF EXISTS");
        }
        sb.append(" PARTITION(");
        String[] keys = spec.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(spec.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        sb.append(");");
        String taskName = "SQLDropPartitionTask";
        this.runSQL(taskName, sb.toString());
    }

    public void createShards(long shardCount) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getProject()).append(".").append(this.getName());
        sb.append(String.format(" INTO %d SHARDS;", shardCount));
        String taskName = "SQLCreateShardsTask";
        this.runSQL(taskName, sb.toString());
    }

    public Iterator<Partition> getPartitionIterator() {
        return this.getPartitionIterator(null);
    }

    public Iterator<Partition> getPartitionIterator(final PartitionSpec spec) {
        return new ListIterator<Partition>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Partition> list() {
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                this.params.put("partitions", null);
                this.params.put("expectmarker", "true");
                if (spec != null && !spec.isEmpty()) {
                    this.params.put("partition", spec.toString());
                }
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                String resource = ResourceBuilder.buildTableResource(Table.this.project, Table.this.getName());
                try {
                    ListPartitionsResponse resp = Table.this.client.request(ListPartitionsResponse.class, resource, "GET", this.params);
                    for (Partition.PartitionModel model : resp.partitions) {
                        Partition t = new Partition(model, Table.this.project, Table.this.getName(), Table.this.client);
                        partitions.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return partitions;
            }
        };
    }

    public List<Partition> getPartitions() {
        ArrayList<Partition> parts = new ArrayList<Partition>();
        Iterator<Partition> it = this.getPartitionIterator();
        while (it.hasNext()) {
            parts.add(it.next());
        }
        return parts;
    }

    public Partition getPartition(PartitionSpec spec) {
        return new Partition(spec, this.project, this.getName(), this.client);
    }

    public boolean hasPartition(PartitionSpec spec) throws OdpsException {
        try {
            Partition part = this.getPartition(spec);
            part.reload();
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    public void truncate() throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("TRUNCATE TABLE ").append(this.getProject()).append(".").append(this.getName()).append(";");
        String taskName = "SQLTruncateTask";
        this.runSQL(taskName, sb.toString());
    }

    public boolean isPartitioned() throws OdpsException {
        if (this.isVirtualView()) {
            return false;
        }
        return this.getSchema().getPartitionColumns().size() > 0;
    }

    private void runSQL(String taskName, String query) throws OdpsException {
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(query);
        Instances instances = this.odps.instances();
        Instance instance = instances.create(task);
        instance.waitForSuccess();
    }

    private Column parseColumn(JsonNode node) {
        String name = node.get("name").asText();
        String typeString = node.get("type").asText().toUpperCase();
        ArrayList<OdpsType> genericTypeList = null;
        if (typeString.contains("<")) {
            String[] result = typeString.split("<", 2);
            typeString = result[0];
            String genericTypeListString = result[1];
            genericTypeListString = genericTypeListString.replace(">", "");
            genericTypeList = new ArrayList<OdpsType>();
            for (String st : genericTypeListString.split(",")) {
                genericTypeList.add(OdpsType.valueOf((String)st));
            }
        }
        OdpsType type = OdpsType.valueOf((String)typeString);
        String comment = node.get("comment").asText();
        String label = null;
        if (node.has("label") && !node.get("label").asText().isEmpty()) {
            label = node.get("label").asText();
        }
        return new Column(name, type, comment, label, genericTypeList);
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            TableModel response;
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("extended", null);
            String resource = ResourceBuilder.buildTableResource(this.project, this.model.name);
            try {
                response = this.client.request(TableModel.class, resource, "GET", params);
            }
            catch (OdpsException e) {
                throw new ReloadException(e.getMessage(), e);
            }
            this.loadSchemaFromJson(((TableModel)response).schema.content);
            this.isExtendInfoLoaded = true;
        }
    }

    @XmlRootElement(name="Partitions")
    private static class ListPartitionsResponse {
        @XmlElement(name="Partition")
        private List<Partition.PartitionModel> partitions = new LinkedList<Partition.PartitionModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListPartitionsResponse() {
        }
    }

    @XmlRootElement(name="Table")
    static class TableModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="TableId")
        String ID;
        @XmlAttribute(name="format")
        private String format;
        @XmlElement(name="Schema")
        private Schema schema;
        @XmlElement(name="Comment")
        String comment;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="TableLabel")
        String tableLabel;
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date createdTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date lastModifiedTime;
        Date lastMetaModifiedTime;
        boolean isVirtualView;
        long life = -1L;
        String viewText;
        long size;
        boolean isArchived;
        long physicalSize;
        long fileNum;
        Shard shard;

        TableModel() {
        }

        @XmlRootElement(name="Schema")
        static class Schema {
            @XmlValue
            String content;

            Schema() {
            }
        }
    }
}

