/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="SQL")
public class SQLTask
extends Task {
    private String query;
    private static final String AnonymousSQLTaskName = "AnonymousSQLTask";

    public String getQuery() {
        return this.query;
    }

    @XmlElement(name="Query")
    public void setQuery(String query) {
        this.query = query;
    }

    public static List<Record> getResult(Instance instance, String taskName) throws OdpsException {
        Map<String, String> results = instance.getTaskResults();
        String selectResult = results.get(taskName);
        if (selectResult != null) {
            CsvReader reader = new CsvReader((Reader)new StringReader(selectResult));
            ArrayList<Record> records = new ArrayList<Record>();
            int lineCount = 0;
            Column[] columns = new Column[]{};
            try {
                while (reader.readRecord()) {
                    String[] newline = reader.getValues();
                    if (lineCount == 0) {
                        columns = new Column[newline.length];
                        for (int i = 0; i < newline.length; ++i) {
                            columns[i] = new Column(newline[i], OdpsType.STRING);
                        }
                    } else {
                        ArrayRecord record = new ArrayRecord(columns);
                        for (int i = 0; i < newline.length; ++i) {
                            record.set(i, (Object)newline[i]);
                        }
                        records.add((Record)record);
                    }
                    ++lineCount;
                }
            }
            catch (IOException e) {
                throw new OdpsException("Error when parse sql results.");
            }
            return records;
        }
        return null;
    }

    public static List<Record> getResult(Instance instance) throws OdpsException {
        return SQLTask.getResult(instance, AnonymousSQLTaskName);
    }

    @Override
    public String getCommandText() {
        return this.query;
    }

    public static Instance run(Odps odps, String sql) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, null, null, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, int priority) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, priority, "sql");
    }

    private static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, Integer priority, String type) throws OdpsException {
        String json;
        SQLTask task = new SQLTask();
        task.setQuery(sql);
        task.setName(taskName);
        task.setProperty("type", type);
        if (hints != null) {
            try {
                json = JacksonParser.getObjectMapper().writeValueAsString(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = JacksonParser.getObjectMapper().writeValueAsString(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (priority != null) {
            return odps.instances().create(project, task, priority);
        }
        return odps.instances().create(project, task);
    }

    static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, String type) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, null, type);
    }
}

