/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

class TunnelServerRouter {
    private RestClient odpsServiceClient;

    public TunnelServerRouter(RestClient odpsServiceClient) {
        this.odpsServiceClient = odpsServiceClient;
    }

    public URI getTunnelServer(String projectName, String protocol) throws TunnelException {
        if (protocol == null || !protocol.equals("http") && !protocol.equals("https")) {
            throw new TunnelException("Invalid protocol: " + protocol);
        }
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(projectName).append("/tunnel");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", null);
        Response resp = null;
        try {
            resp = this.odpsServiceClient.request(resource.toString(), "GET", params, null, null);
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        String serviceAddr = null;
        if (!resp.isOK()) {
            throw new TunnelException("Can't get tunnel server address: " + resp.getStatus());
        }
        serviceAddr = new String(resp.getBody());
        URI server = null;
        try {
            server = new URI(protocol + "://" + serviceAddr);
        }
        catch (URISyntaxException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return server;
    }
}

