/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.VolumeFSTunnel$AjcClosure1;
import com.aliyun.odps.tunnel.VolumeFSTunnel$AjcClosure3;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.VolumeInputStream;
import com.aliyun.odps.tunnel.io.VolumeOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class VolumeFSTunnel {
    private Configuration conf;
    private static final String STREAM_CONTENT_TYPE = "application/octet-stream";
    private static final String REPLICATION = "replication";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public VolumeFSTunnel(Odps odps) {
        this.conf = new Configuration(odps);
    }

    public InputStream openInputStream(String project, String path, Long start, Long end, CompressOption compressOption) throws TunnelException {
        VolumeFSTunnel.checkVolume(path);
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Range", this.getRangeValue(start, end));
        headers.put("x-odps-volume-fs-path", path);
        if (compressOption != null) {
            if (CompressOption.CompressAlgorithm.ODPS_ZLIB.equals((Object)compressOption.algorithm)) {
                headers.put("Accept-Encoding", Encoding.deflate.name());
            } else {
                throw new TunnelException("Not Support compress option:" + compressOption.algorithm.name());
            }
        }
        VolumeInputStream in = null;
        Connection conn = null;
        try {
            String resource = ResourceBuilder.buildVolumeResource(project, this.getVolumeFromPath(path));
            Connection connection = conn = this.getRestClient(project).connect(resource, Request.Method.GET.name(), params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new VolumeFSTunnel$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                TunnelException exception = new TunnelException(conn.getInputStream());
                exception.setRequestId(resp.getHeader("x-odps-request-id"));
                throw exception;
            }
            boolean compress = false;
            String content_encoding = resp.getHeader("Content-Encoding");
            if (content_encoding != null) {
                if (!content_encoding.equals(Encoding.deflate.name())) {
                    throw new TunnelException("Not Support compress option:" + content_encoding);
                }
                compress = true;
            }
            CompressOption option = compress ? new CompressOption() : null;
            in = new VolumeInputStream(conn, option);
        }
        catch (IOException e) {
            this.closeQuietly(conn);
            this.unifyException(e);
        }
        catch (OdpsException e) {
            this.closeQuietly(conn);
            this.unifyException(e);
        }
        return in;
    }

    public OutputStream openOutputStream(String project, String path, Integer replication, CompressOption compressOption) throws TunnelException {
        VolumeFSTunnel.checkVolume(path);
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (replication != null && replication > 0) {
            params.put(REPLICATION, replication.toString());
        }
        headers.put("Content-Type", STREAM_CONTENT_TYPE);
        headers.put("Transfer-Encoding", "chunked");
        headers.put("x-odps-volume-fs-path", path);
        boolean compress = false;
        if (compressOption != null) {
            compress = true;
        }
        if (compress) {
            if (CompressOption.CompressAlgorithm.ODPS_ZLIB.equals((Object)compressOption.algorithm)) {
                headers.put("Accept-Encoding", Encoding.deflate.name());
            } else {
                throw new TunnelException("Not Support compress option:" + compressOption.algorithm.name());
            }
        }
        VolumeOutputStream out = null;
        Connection conn = null;
        try {
            String resource = ResourceBuilder.buildVolumeResource(project, this.getVolumeFromPath(path));
            conn = this.getRestClient(project).connect(resource, Request.Method.POST.name(), params, headers);
            CompressOption option = compress ? compressOption : null;
            out = new VolumeOutputStream(conn, option);
        }
        catch (IOException e) {
            this.closeQuietly(conn);
            this.unifyException(e);
        }
        catch (OdpsException e) {
            this.closeQuietly(conn);
            this.unifyException(e);
        }
        return out;
    }

    public void commit(String project, String path, String sessionId) throws TunnelException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-odps-volume-fs-path", path);
        headers.put("x-odps-volume-sessionid", sessionId);
        String resource = null;
        try {
            resource = ResourceBuilder.buildVolumeResource(project, this.getVolumeFromPath(path));
        }
        catch (IOException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        Connection conn = null;
        try {
            Connection connection = conn = this.getRestClient(project).connect(resource, Request.Method.PUT.name(), null, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new VolumeFSTunnel$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                TunnelException exception = new TunnelException(conn.getInputStream());
                exception.setRequestId(resp.getHeader("x-odps-request-id"));
                throw exception;
            }
        }
        catch (IOException e) {
            this.unifyException(e);
        }
        catch (OdpsException e) {
            this.unifyException(e);
        }
    }

    public static String getUploadSessionId(VolumeOutputStream outputStream) throws TunnelException {
        Response resp;
        if (outputStream == null) {
            throw new TunnelException("outputStream is null.");
        }
        if (!outputStream.isClosed()) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                if (e.getCause() instanceof TunnelException) {
                    throw (TunnelException)e.getCause();
                }
                throw new TunnelException(e.getMessage(), e);
            }
        }
        if ((resp = outputStream.getResp()) == null) {
            return null;
        }
        return resp.getHeader("x-odps-volume-sessionid");
    }

    private void unifyException(OdpsException e) throws TunnelException {
        if (e instanceof TunnelException) {
            throw (TunnelException)e;
        }
        TunnelException te = new TunnelException();
        OdpsException oe = e;
        te.setRequestId(oe.getRequestId());
        te.setErrorCode(oe.getErrorCode());
        te.setErrorMsg(oe.getMessage());
        te.setStackTrace(oe.getStackTrace());
        throw te;
    }

    private void unifyException(IOException e) throws TunnelException {
        throw new TunnelException(e.getMessage(), e);
    }

    private void closeQuietly(Connection conn) {
        if (conn != null) {
            try {
                conn.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getRangeValue(Long start, Long end) {
        return "bytes=" + (start == null ? "" : start) + "-" + (end == null ? "" : end);
    }

    private String getVolumeFromPath(String path) throws IOException {
        if (path == null || path.indexOf("/") == -1) {
            throw new IOException("No volume found!");
        }
        return path.split("/")[1];
    }

    private RestClient getRestClient(String project) {
        RestClient restClient = null;
        try {
            restClient = this.conf.newRestClient(project);
        }
        catch (TunnelException e) {
            throw new RuntimeException(e.getErrorMsg(), e);
        }
        return restClient;
    }

    public void setEndpoint(String endpoint) {
        try {
            this.conf.setEndpoint(new URI(endpoint));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void checkVolume(String path) throws TunnelException {
        if (!Volume.checkPathHasVolume(path)) {
            TunnelException te = new TunnelException();
            te.setErrorCode("VolumeMissing");
            te.setErrorMsg("missing volume in path: " + path + "!");
            throw te;
        }
    }

    static {
        VolumeFSTunnel.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(VolumeFSTunnel volumeFSTunnel, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody2(VolumeFSTunnel volumeFSTunnel, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VolumeFSTunnel.java", VolumeFSTunnel.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 94);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 202);
    }

    private static enum Encoding {
        deflate;

    }
}

