/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Function;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Functions
implements Iterable<Function> {
    private RestClient client;
    private Odps odps;

    Functions(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Function get(String functionName) throws OdpsException {
        return this.get(this.getDefaultProjectName(), functionName);
    }

    public Function get(String projectName, String functionName) {
        Function.FunctionModel model = new Function.FunctionModel();
        model.name = functionName;
        return new Function(model, projectName, this.odps);
    }

    public boolean exists(String functionName) throws OdpsException {
        return this.exists(this.odps.getDefaultProject(), functionName);
    }

    public boolean exists(String projectName, String functionName) throws OdpsException {
        Function function = this.get(projectName, functionName);
        try {
            function.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void update(Function func) throws OdpsException {
        this.update(this.getDefaultProjectName(), func);
    }

    public void update(String projectName, Function func) throws OdpsException {
        String ret;
        String resource = ResourceBuilder.buildFunctionResource(projectName, func.getName());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        try {
            ret = SimpleXmlUtils.marshal(func.model);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        this.client.stringRequest(resource, "PUT", null, header, ret);
    }

    public void create(Function func) throws OdpsException {
        this.create(this.getDefaultProjectName(), func);
    }

    public void create(String projectName, Function func) throws OdpsException {
        String ret;
        String resource = ResourceBuilder.buildFunctionsResource(projectName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        try {
            ret = SimpleXmlUtils.marshal(func.model);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        this.client.stringRequest(resource, "POST", null, header, ret);
    }

    public void delete(String name) throws OdpsException {
        this.delete(this.getDefaultProjectName(), name);
    }

    public void delete(String projectName, String name) throws OdpsException {
        String resource = ResourceBuilder.buildFunctionResource(projectName, name);
        this.client.request(resource, "DELETE", null, null, null);
    }

    @Override
    public Iterator<Function> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterable<Function> iterable() {
        return new Iterable<Function>(){

            @Override
            public Iterator<Function> iterator() {
                return new FunctionListIterator(Functions.this.getDefaultProjectName());
            }
        };
    }

    public Iterable<Function> iterable(final String projectName) {
        return new Iterable<Function>(){

            @Override
            public Iterator<Function> iterator() {
                return new FunctionListIterator(projectName);
            }
        };
    }

    public Iterator<Function> iterator(String projectName) {
        return new FunctionListIterator(projectName);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private class FunctionListIterator
    extends ListIterator<Function> {
        Map<String, String> params = new HashMap<String, String>();
        String projectName;

        public FunctionListIterator(String projectName) {
            this.projectName = projectName;
        }

        @Override
        protected List<Function> list() {
            ArrayList<Function> functions = new ArrayList<Function>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && StringUtils.isNullOrEmpty((String)lastMarker)) {
                return null;
            }
            String resource = ResourceBuilder.buildFunctionsResource(this.projectName);
            try {
                ListFunctionsResponse resp = Functions.this.client.request(ListFunctionsResponse.class, resource, "GET", this.params);
                for (Function.FunctionModel model : resp.functions) {
                    Function t = new Function(model, this.projectName, Functions.this.odps);
                    functions.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return functions;
        }
    }

    @Root(name="Functions", strict=false)
    static class ListFunctionsResponse {
        @ElementList(entry="Function", inline=true, required=false)
        List<Function.FunctionModel> functions = new ArrayList<Function.FunctionModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        Integer maxItems;

        ListFunctionsResponse() {
        }
    }
}

