/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.ResourceInputStream;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.VolumeResource;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public class Resources
implements Iterable<Resource> {
    private final RestClient client;
    private Odps odps;
    private int chunkSize;

    Resources(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
        this.chunkSize = 0x4000000;
    }

    private <T> T checkIsNull(T t, String parameterName) {
        if (t == null) {
            throw new NullPointerException(String.format("%s cannot be null.", parameterName));
        }
        return t;
    }

    public void create(FileResource r, InputStream in) throws OdpsException {
        this.create(this.getDefaultProjectName(), r, in);
    }

    public void create(String projectName, FileResource r, InputStream in) throws OdpsException {
        try {
            this.createFile(projectName, r, in, false);
        }
        catch (IOException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public void create(TableResource r) throws OdpsException {
        this.create(this.getDefaultProjectName(), r);
    }

    public void create(String projectName, TableResource r) throws OdpsException {
        this.createTable(projectName, r, false);
    }

    public void create(VolumeResource r) throws OdpsException {
        this.create(this.getDefaultProjectName(), r);
    }

    public void create(String projectName, VolumeResource r) throws OdpsException {
        this.addVolumeResource(projectName, r, false);
    }

    public void update(VolumeResource r) throws OdpsException {
        this.update(this.getDefaultProjectName(), r);
    }

    public void update(String projectName, VolumeResource r) throws OdpsException {
        this.addVolumeResource(projectName, r, true);
    }

    private void addVolumeResource(String projectName, VolumeResource r, boolean isUpdate) throws OdpsException {
        String resource;
        String method;
        this.checkIsNull(r, "VolumeResource");
        RestClient client = this.odps.getRestClient();
        if (isUpdate) {
            method = "PUT";
            resource = ResourceBuilder.buildResourceResource(projectName, r.getName());
        } else {
            method = "POST";
            resource = ResourceBuilder.buildResourcesResource(projectName);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-odps-resource-type", r.model.type.toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        headers.put("x-odps-copy-file-source", r.getVolumePath());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        client.request(resource, method, null, headers, null);
    }

    public void update(TableResource r) throws OdpsException {
        this.update(this.getDefaultProjectName(), r);
    }

    public void update(String projectName, TableResource r) throws OdpsException {
        this.createTable(projectName, r, true);
    }

    public void update(FileResource r, InputStream in) throws OdpsException {
        this.update(this.getDefaultProjectName(), r, in);
    }

    public void update(String projectName, FileResource r, InputStream in) throws OdpsException {
        try {
            this.createFile(projectName, r, in, true);
        }
        catch (IOException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public InputStream getResourceAsStream(String projectName, String name) throws OdpsException {
        return new ResourceInputStream(this.client, projectName, name);
    }

    public InputStream getResourceAsStream(String name) throws OdpsException {
        return this.getResourceAsStream(this.getDefaultProjectName(), name);
    }

    private void createTable(String project, TableResource r, Boolean overwrite) throws OdpsException {
        String resource;
        String method;
        this.checkIsNull(r, "TableResource");
        this.checkIsNull(overwrite, "Parameter \"overwrite\"");
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("Table Resource Name should not empty.");
        }
        if (overwrite.booleanValue()) {
            method = "PUT";
            resource = ResourceBuilder.buildResourceResource(project, r.getName());
        } else {
            method = "POST";
            resource = ResourceBuilder.buildResourcesResource(project);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain");
        headers.put("x-odps-resource-type", r.getType().toString().toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        headers.put("x-odps-copy-table-source", r.getSourceTableName());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        this.client.request(resource, method, null, headers, null);
    }

    private void createFile(String project, Resource res, InputStream in, Boolean overwrite) throws OdpsException, IOException {
        int readSize;
        InputStream inputStream = this.checkIsNull(in, "InputStream");
        Boolean isUpdate = this.checkIsNull(overwrite, "Parameter \"overwrite\"");
        FileResource r = (FileResource)this.checkIsNull(res, "Resource");
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("Resource Name should not empty.");
        }
        MessageDigest digest = DigestUtils.getMd5Digest();
        byte[] tmpContent = new byte[this.chunkSize];
        long totalBytes = 0L;
        int cnt = 0;
        ArrayList<String> tmpFiles = new ArrayList<String>();
        while ((readSize = inputStream.read(tmpContent)) != -1) {
            digest.update(tmpContent, 0, readSize);
            ByteArrayInputStream input = new ByteArrayInputStream(tmpContent, 0, readSize);
            FileResource tmp = new FileResource();
            String tmpName = String.format("%s.part.tmp.%06d", r.getName(), cnt);
            tmp.setIsTempResource(true);
            tmp.setName(tmpName);
            tmpFiles.add(tmpName);
            this.createTempPartFile(project, tmp, input);
            ++cnt;
            totalBytes += (long)readSize;
            ((InputStream)input).close();
        }
        byte[] md5Bytes = digest.digest();
        String commitContent = this.toHexString(md5Bytes) + "|" + String.join((CharSequence)",", tmpFiles);
        ByteArrayInputStream is = new ByteArrayInputStream(commitContent.getBytes(StandardCharsets.UTF_8));
        FileResource f = new FileResource();
        f.setName(r.getName());
        f.setComment(r.getComment());
        f.setIsTempResource(r.getIsTempResource());
        f.model.type = r.getType().toString();
        this.mergeTempPartFiles(this.odps.getDefaultProject(), f, is, isUpdate, totalBytes);
        ((InputStream)is).close();
    }

    public Resource get(String name) {
        String[] tmpPair = name.split("/resources/");
        if (tmpPair.length > 1) {
            String project = tmpPair[0];
            String resourceName = tmpPair[1];
            return this.get(project, resourceName);
        }
        return this.get(this.getDefaultProjectName(), name);
    }

    public Resource get(String projectName, String name) {
        Resource.ResourceModel rm = new Resource.ResourceModel();
        rm.name = name;
        return Resource.getResource(rm, projectName, this.odps);
    }

    public boolean exists(String resourceName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), resourceName);
    }

    public boolean exists(String projectName, String resourceName) throws OdpsException {
        try {
            Resource t = this.get(projectName, resourceName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (ReloadException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                return false;
            }
            throw e;
        }
    }

    public void delete(String name) throws OdpsException {
        this.delete(this.getDefaultProjectName(), name);
    }

    public void delete(String projectName, String name) throws OdpsException {
        String resource = ResourceBuilder.buildResourceResource(projectName, name);
        this.client.request(resource, "DELETE", null, null, null);
    }

    public FileResource createTempResource(String fileName) throws OdpsException {
        return this.createTempResource(this.getDefaultProjectName(), fileName);
    }

    public FileResource createTempResource(String projectName, String fileName) throws OdpsException {
        return this.createTempResource(projectName, fileName, Resource.Type.FILE);
    }

    public FileResource createTempResource(String projectName, String fileName, Resource.Type type) throws OdpsException {
        FileInputStream input;
        this.checkIsNull(fileName, "FileName");
        this.checkIsNull(type, "Resource.Type");
        File tempFile = null;
        tempFile = new File(fileName);
        if (!tempFile.exists()) {
            throw new OdpsException("File or Directory '" + fileName + "' does not exist.");
        }
        if (tempFile.isDirectory()) {
            throw new OdpsException("Temp resource should be file, not directory:" + fileName);
        }
        Resource resourceTmp = Resource.createResource(type);
        if (!(resourceTmp instanceof FileResource)) {
            throw new OdpsException("Invalid temp resource type :" + String.valueOf((Object)type) + ".");
        }
        FileResource resource = (FileResource)resourceTmp;
        resource.setIsTempResource(true);
        String resourceName = UUID.randomUUID().toString() + "_" + tempFile.getName();
        resource.setName(resourceName);
        try {
            input = new FileInputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            throw new OdpsException("File or Directory '" + fileName + "' does not exist.");
        }
        this.create(projectName, resource, input);
        IOUtils.closeSilently(input);
        return (FileResource)this.get(projectName, resourceName);
    }

    private String toHexString(byte[] bytes) {
        String md5 = new BigInteger(1, bytes).toString(16);
        return new String(new char[32 - md5.length()]).replace("\u0000", "0") + md5;
    }

    private void createTempPartFile(String project, Resource res, InputStream in) throws OdpsException, IOException {
        FileResource r = (FileResource)res;
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("Temp Part Resource Name should not empty.");
        }
        if (!r.getIsTempResource()) {
            throw new OdpsException("Part Resource must be Temp Resource.");
        }
        if (r.getType().equals((Object)Resource.Type.VOLUMEFILE) || r.getType().equals((Object)Resource.Type.VOLUMEARCHIVE) || r.getType().equals((Object)Resource.Type.TABLE) || r.getType().equals((Object)Resource.Type.UNKOWN)) {
            throw new OdpsException("Temp Part Resource's type is invalid!");
        }
        String resource = ResourceBuilder.buildResourcesResource(project);
        String method = "POST";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Content-Disposition", "attachment;filename=" + r.getName());
        headers.put("x-odps-resource-type", r.getType().toString().toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        headers.put("x-odps-resource-istemp", String.valueOf(r.getIsTempResource()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rIsPart", "true");
        this.client.request(resource, method, params, headers, in, IOUtils.getInputStreamLength(in));
    }

    private void mergeTempPartFiles(String project, Resource res, InputStream in, boolean overwrite, long totalBytes) throws OdpsException, IOException {
        String resource;
        String method;
        InputStream inputStream = Objects.requireNonNull(in);
        FileResource r = (FileResource)res;
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("File Resource Name should not empty.");
        }
        if (overwrite) {
            method = "PUT";
            resource = ResourceBuilder.buildResourceResource(project, r.getName());
        } else {
            method = "POST";
            resource = ResourceBuilder.buildResourcesResource(project);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Content-Disposition", "attachment;filename=" + r.getName());
        headers.put("x-odps-resource-type", r.getType().toString().toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        if (r.getIsTempResource()) {
            headers.put("x-odps-resource-istemp", String.valueOf(r.getIsTempResource()));
        }
        headers.put("x-odps-resource-merge-total-bytes", String.valueOf(totalBytes));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rOpMerge", "true");
        this.odps.getRestClient().request(resource, method, params, headers, inputStream, IOUtils.getInputStreamLength(inputStream));
    }

    public Iterator<Resource> iterator(String projectName) {
        return new ResourceListIterator(projectName, null);
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterable<Resource> iterable(String projectName) {
        return () -> new ResourceListIterator(projectName, null);
    }

    public Iterable<Resource> iterable() {
        return this.iterable(this.getDefaultProjectName());
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    protected void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    private class ResourceListIterator
    extends ListIterator<Resource> {
        Map<String, String> params = new HashMap<String, String>();
        String name;
        String project;

        ResourceListIterator(String projectName, String resourceName) {
            this.project = projectName;
            this.name = resourceName;
        }

        @Override
        protected List<Resource> list() {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.name != null) {
                this.params.put("name", this.name);
            }
            String resource = ResourceBuilder.buildResourcesResource(this.project);
            try {
                ListResourcesResponse resp = Resources.this.client.request(ListResourcesResponse.class, resource, "GET", this.params);
                for (Resource.ResourceModel model : resp.resources) {
                    Resource t = Resource.getResource(model, this.project, Resources.this.odps);
                    resources.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return resources;
        }
    }

    @Root(name="Resources", strict=false)
    private static class ListResourcesResponse {
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;
        @ElementList(entry="Resource", inline=true, required=false)
        private List<Resource.ResourceModel> resources = new ArrayList<Resource.ResourceModel>();

        private ListResourcesResponse() {
        }
    }
}

