/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Odps;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class TunnelEndpointLocalCache {
    private long cacheSize = 10000L;
    private int durationSeconds = 900;
    private Cache<String, String> tunnelCache = null;

    public TunnelEndpointLocalCache(long size, int duration) {
        this.cacheSize = size;
        this.durationSeconds = duration;
        this.tunnelCache = CacheBuilder.newBuilder().expireAfterAccess((long)this.durationSeconds, TimeUnit.SECONDS).maximumSize(this.cacheSize).build();
    }

    public String getTunnelEndpointFromLocalCache(final Odps odps) throws ExecutionException {
        String key = odps.getEndpoint() + odps.getDefaultProject();
        return (String)this.tunnelCache.get((Object)key, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String routerEndpoint = odps.projects().get(odps.getDefaultProject()).getTunnelEndpoint();
                return routerEndpoint;
            }
        });
    }

    public void putTunnelEndpointIntoLocalCache(Odps odps, String tunnelEndpoint) {
        String key = odps.getEndpoint() + odps.getDefaultProject();
        this.tunnelCache.put((Object)key, (Object)tunnelEndpoint);
    }

    public Cache<String, String> getTunnelCache() {
        return this.tunnelCache;
    }
}

