/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.transport;

import com.aliyun.odps.rest.RestClient;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private URI uri;
    private Method method = Method.GET;
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private InputStream body;
    private long bodyLength;
    private RestClient restClient;

    public Request() {
        this(new RestClient(null));
    }

    public Request(RestClient client) {
        this.restClient = client;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Missing URI.");
        }
        this.uri = uri.normalize();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Map<String, String> getParameters() {
        return this.params;
    }

    public void setParameter(String name, String value) {
        this.params.put(name, value);
    }

    public void setParameters(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setContentLength(long len) {
        this.headers.put("Content-Length", String.valueOf(len));
    }

    public InputStream getBody() {
        return this.body;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public long getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(long bodyLength) {
        this.bodyLength = bodyLength;
    }

    @Deprecated
    public void setConnectTimeout(int timeout) {
        this.getRestClient().setConnectTimeout(timeout);
    }

    @Deprecated
    public int getConnectTimeout() {
        return this.getRestClient().getConnectTimeout();
    }

    @Deprecated
    public void setReadTimeout(int timeout) {
        this.getRestClient().setReadTimeout(timeout);
    }

    @Deprecated
    public int getReadTimeout() {
        return this.getRestClient().getReadTimeout();
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD;

    }
}

