/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.DefaultType;
import com.aliyun.odps.simpleframework.xml.Namespace;
import com.aliyun.odps.simpleframework.xml.NamespaceList;
import com.aliyun.odps.simpleframework.xml.Order;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.core.Commit;
import com.aliyun.odps.simpleframework.xml.core.Complete;
import com.aliyun.odps.simpleframework.xml.core.ConstructorScanner;
import com.aliyun.odps.simpleframework.xml.core.Decorator;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.Function;
import com.aliyun.odps.simpleframework.xml.core.MethodDetail;
import com.aliyun.odps.simpleframework.xml.core.NamespaceDecorator;
import com.aliyun.odps.simpleframework.xml.core.ParameterMap;
import com.aliyun.odps.simpleframework.xml.core.Persist;
import com.aliyun.odps.simpleframework.xml.core.Replace;
import com.aliyun.odps.simpleframework.xml.core.Resolve;
import com.aliyun.odps.simpleframework.xml.core.Signature;
import com.aliyun.odps.simpleframework.xml.core.Support;
import com.aliyun.odps.simpleframework.xml.core.Validate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

class ClassScanner {
    private NamespaceDecorator decorator;
    private ConstructorScanner scanner;
    private Function commit;
    private Function validate;
    private Function persist;
    private Function complete;
    private Function replace;
    private Function resolve;
    private Support support;
    private Root root;
    private Order order;

    public ClassScanner(Detail detail, Support support) throws Exception {
        this.scanner = new ConstructorScanner(detail, support);
        this.decorator = new NamespaceDecorator();
        this.support = support;
        this.scan(detail);
    }

    public Signature getSignature() {
        return this.scanner.getSignature();
    }

    public List<Signature> getSignatures() {
        return this.scanner.getSignatures();
    }

    public ParameterMap getParameters() {
        return this.scanner.getParameters();
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public Order getOrder() {
        return this.order;
    }

    public Root getRoot() {
        return this.root;
    }

    public Function getCommit() {
        return this.commit;
    }

    public Function getValidate() {
        return this.validate;
    }

    public Function getPersist() {
        return this.persist;
    }

    public Function getComplete() {
        return this.complete;
    }

    public Function getReplace() {
        return this.replace;
    }

    public Function getResolve() {
        return this.resolve;
    }

    private void scan(Detail detail) throws Exception {
        DefaultType access = detail.getOverride();
        Class type = detail.getType();
        while (type != null) {
            Detail value = this.support.getDetail(type, access);
            this.namespace(value);
            this.method(value);
            this.definition(value);
            type = value.getSuper();
        }
        this.commit(detail);
    }

    private void definition(Detail detail) throws Exception {
        if (this.root == null) {
            this.root = detail.getRoot();
        }
        if (this.order == null) {
            this.order = detail.getOrder();
        }
    }

    private void namespace(Detail detail) throws Exception {
        NamespaceList scope = detail.getNamespaceList();
        Namespace namespace = detail.getNamespace();
        if (namespace != null) {
            this.decorator.add(namespace);
        }
        if (scope != null) {
            Namespace[] list;
            for (Namespace name : list = scope.value()) {
                this.decorator.add(name);
            }
        }
    }

    private void commit(Detail detail) {
        Namespace namespace = detail.getNamespace();
        if (namespace != null) {
            this.decorator.set(namespace);
        }
    }

    private void method(Detail detail) throws Exception {
        List<MethodDetail> list = detail.getMethods();
        for (MethodDetail entry : list) {
            this.method(entry);
        }
    }

    private void method(MethodDetail detail) {
        Annotation[] list = detail.getAnnotations();
        Method method = detail.getMethod();
        for (Annotation label : list) {
            if (label instanceof Commit) {
                this.commit(method);
            }
            if (label instanceof Validate) {
                this.validate(method);
            }
            if (label instanceof Persist) {
                this.persist(method);
            }
            if (label instanceof Complete) {
                this.complete(method);
            }
            if (label instanceof Replace) {
                this.replace(method);
            }
            if (!(label instanceof Resolve)) continue;
            this.resolve(method);
        }
    }

    private void replace(Method method) {
        if (this.replace == null) {
            this.replace = this.getFunction(method);
        }
    }

    private void resolve(Method method) {
        if (this.resolve == null) {
            this.resolve = this.getFunction(method);
        }
    }

    private void commit(Method method) {
        if (this.commit == null) {
            this.commit = this.getFunction(method);
        }
    }

    private void validate(Method method) {
        if (this.validate == null) {
            this.validate = this.getFunction(method);
        }
    }

    private void persist(Method method) {
        if (this.persist == null) {
            this.persist = this.getFunction(method);
        }
    }

    private void complete(Method method) {
        if (this.complete == null) {
            this.complete = this.getFunction(method);
        }
    }

    private Function getFunction(Method method) {
        boolean contextual = this.isContextual(method);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return new Function(method, contextual);
    }

    private boolean isContextual(Method method) {
        Class<?>[] list = method.getParameterTypes();
        if (list.length == 1) {
            return Map.class.equals(list[0]);
        }
        return false;
    }
}

