/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.datasource;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.udf.local.LocalRunError;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.datasource.InputSource;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class TableInputSource
extends InputSource {
    private List<Object[]> dataList;
    private int totalCount;
    private int index = 0;

    public TableInputSource(TableInfo tableInfo) {
        if (tableInfo == null) {
            throw new LocalRunError("Invalid input table info");
        }
        if (StringUtils.isBlank((String)tableInfo.getProjectName())) {
            throw new LocalRunError("Project can't be null");
        }
        if (StringUtils.isBlank((String)tableInfo.getTableName())) {
            throw new LocalRunError("Input table can't be null");
        }
        try {
            this.dataList = WareHouse.getInstance().readData(tableInfo.getProjectName(), tableInfo.getTableName(), tableInfo.getPartitionSpec(), tableInfo.getCols(), WareHouse.getInstance().getInputColumnSeperator());
            for (Object[] datas : this.dataList) {
                if (datas == null) continue;
                for (int i = 0; i < datas.length; ++i) {
                    if (!(datas[i] instanceof Date)) continue;
                    datas[i] = new Long(((Date)datas[i]).getTime());
                }
            }
        }
        catch (OdpsException e) {
            throw new LocalRunError(e.getMessage());
        }
        catch (IOException e) {
            throw new LocalRunError(e.getMessage());
        }
        this.totalCount = this.dataList == null || this.dataList.size() == 0 ? 0 : this.dataList.size();
    }

    public TableInputSource(String project, String table, String[] partitions, String[] columns) throws LocalRunException {
        this(TableInfo.builder().projectName(project).tableName(table).partSpec(PartitionUtils.convert((String[])partitions)).cols(columns).build());
    }

    @Override
    public Object[] getNextRow() throws IOException {
        if (this.totalCount == 0 || this.index >= this.totalCount) {
            return null;
        }
        return this.dataList.get(this.index++);
    }
}

