/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.runner;

import com.aliyun.odps.Odps;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.security.SecurityClient;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.UDF;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.runner.BaseRunner;
import com.aliyun.odps.udf.local.util.ClassUtils;
import com.aliyun.odps.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public class UDFRunner
extends BaseRunner {
    private UDF udf;
    private TableInfo tableInfo;
    private Method evalMethod;

    public UDFRunner(Odps odps, UDF udf) throws UDFException {
        super(odps);
        if (udf == null) {
            throw new IllegalArgumentException("Missing arguments:udf");
        }
        this.udf = udf;
        try {
            SecurityClient.open();
            udf.setup((ExecutionContext)this.context);
        }
        catch (Exception ex) {
            throw new UDFException((Throwable)ex);
        }
        finally {
            SecurityClient.close();
        }
    }

    public UDFRunner(Odps odps, String className) throws LocalRunException {
        this(odps, className, null);
    }

    public UDFRunner(Odps odps, String className, TableInfo tableInfo) throws LocalRunException {
        super(odps);
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException("Missing arguments:className");
        }
        this.tableInfo = tableInfo;
        try {
            this.udf = (UDF)ClassUtils.newInstance(UDFRunner.class.getClassLoader(), className);
            SecurityClient.open();
            this.udf.setup((ExecutionContext)this.context);
        }
        catch (LocalRunException e) {
            throw e;
        }
        catch (UDFException e) {
            throw new LocalRunException(e);
        }
        finally {
            SecurityClient.close();
        }
    }

    @Override
    public BaseRunner internalFeed(Object[] input) throws LocalRunException {
        try {
            SecurityClient.open();
            if (this.evalMethod == null) {
                this.evalMethod = this.findMethod(this.udf.getClass(), input);
            }
            input = ClassUtils.adaptVarargMethodDataIfNecessary(this.evalMethod, input);
            Object result = this.evalMethod.invoke((Object)this.udf, input);
            this.buffer.add(new Object[]{result});
        }
        catch (InvocationTargetException e) {
            throw new LocalRunException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LocalRunException(e);
        }
        catch (IllegalAccessException e) {
            throw new LocalRunException(e);
        }
        finally {
            SecurityClient.close();
        }
        return this;
    }

    @Override
    public List<Object[]> internalYield() throws LocalRunException {
        try {
            SecurityClient.open();
            this.udf.close();
        }
        catch (UDFException e) {
            throw new LocalRunException(e);
        }
        finally {
            SecurityClient.close();
        }
        this.udf = null;
        return this.buffer;
    }

    private Method findMethod(Class<?> clz, Object[] args) throws LocalRunException {
        Class[] parameterTypes;
        if (args == null || args.length == 0) {
            throw new LocalRunException("Input data can't be null");
        }
        if (this.tableInfo != null) {
            parameterTypes = WareHouse.getInstance().getColumnTypes(this.tableInfo.getProjectName(), this.tableInfo.getTableName(), this.tableInfo.getCols());
        } else {
            parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
        }
        Method method = ClassUtils.findMethod(clz, "evaluate", parameterTypes);
        if (Modifier.toString(method.getModifiers()).contains("static")) {
            throw new LocalRunException("'evaluate' method can't be static");
        }
        return method;
    }
}

