/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultTolerance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultToleranceImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;

public class MQFaultStrategy {
    private static final Logger log = ClientLogger.getLog();
    private final LatencyFaultTolerance<String> latencyFaultTolerance = new LatencyFaultToleranceImpl();
    private boolean sendLatencyFaultEnable = false;
    private long[] latencyMax = new long[]{50L, 100L, 550L, 1000L, 2000L, 3000L, 15000L};
    private long[] notAvailableDuration = new long[]{0L, 0L, 30000L, 60000L, 120000L, 180000L, 600000L};

    public long[] getNotAvailableDuration() {
        return this.notAvailableDuration;
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.notAvailableDuration = notAvailableDuration;
    }

    public long[] getLatencyMax() {
        return this.latencyMax;
    }

    public void setLatencyMax(long[] latencyMax) {
        this.latencyMax = latencyMax;
    }

    public boolean isSendLatencyFaultEnable() {
        return this.sendLatencyFaultEnable;
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.sendLatencyFaultEnable = sendLatencyFaultEnable;
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, String lastBrokerName) {
        if (this.sendLatencyFaultEnable) {
            try {
                MessageQueue mq;
                int index = tpInfo.getSendWhichQueue().getAndIncrement();
                for (int i = 0; i < tpInfo.getMessageQueueList().size(); ++i) {
                    int pos;
                    if ((pos = Math.abs(index++) % tpInfo.getMessageQueueList().size()) < 0) {
                        pos = 0;
                    }
                    if (!this.latencyFaultTolerance.isAvailable((mq = tpInfo.getMessageQueueList().get(pos)).getBrokerName()) || null != lastBrokerName && !mq.getBrokerName().equals(lastBrokerName)) continue;
                    return mq;
                }
                String notBestBroker = this.latencyFaultTolerance.pickOneAtLeast();
                int writeQueueNums = tpInfo.getQueueIdByBroker(notBestBroker);
                if (writeQueueNums > 0) {
                    mq = tpInfo.selectOneMessageQueue();
                    if (notBestBroker != null) {
                        mq.setBrokerName(notBestBroker);
                        mq.setQueueId(tpInfo.getSendWhichQueue().getAndIncrement() % writeQueueNums);
                    }
                    return mq;
                }
                this.latencyFaultTolerance.remove(notBestBroker);
            }
            catch (Exception e) {
                log.error("Error occurred when selecting message queue", (Throwable)e);
            }
            return tpInfo.selectOneMessageQueue();
        }
        return tpInfo.selectOneMessageQueue(lastBrokerName);
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation) {
        if (this.sendLatencyFaultEnable) {
            long duration = this.computeNotAvailableDuration(isolation ? 30000L : currentLatency);
            this.latencyFaultTolerance.updateFaultItem(brokerName, currentLatency, duration);
        }
    }

    private long computeNotAvailableDuration(long currentLatency) {
        for (int i = this.latencyMax.length - 1; i >= 0; --i) {
            if (currentLatency < this.latencyMax[i]) continue;
            return this.notAvailableDuration[i];
        }
        return 0L;
    }
}

