/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumeStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ProcessQueueInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ConsumeType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConsumerRunningInfo
extends RemotingSerializable {
    public static final String PROP_NAMESERVER_ADDR = "PROP_NAMESERVER_ADDR";
    public static final String PROP_THREADPOOL_CORE_SIZE = "PROP_THREADPOOL_CORE_SIZE";
    public static final String PROP_CONSUME_ORDERLY = "PROP_CONSUMEORDERLY";
    public static final String PROP_CONSUME_TYPE = "PROP_CONSUME_TYPE";
    public static final String PROP_CLIENT_VERSION = "PROP_CLIENT_VERSION";
    public static final String PROP_CONSUMER_START_TIMESTAMP = "PROP_CONSUMER_START_TIMESTAMP";
    private Properties properties = new Properties();
    private TreeSet<SubscriptionData> subscriptionSet = new TreeSet();
    private TreeMap<MessageQueue, ProcessQueueInfo> mqTable = new TreeMap();
    private TreeMap<String, ConsumeStatus> statusTable = new TreeMap();
    private String jstack;

    public static boolean analyzeSubscription(TreeMap<String, ConsumerRunningInfo> criTable) {
        ConsumerRunningInfo prev = criTable.firstEntry().getValue();
        boolean push = false;
        String property = prev.getProperties().getProperty(PROP_CONSUME_TYPE);
        if (property == null) {
            property = ((ConsumeType)((Object)prev.getProperties().get(PROP_CONSUME_TYPE))).name();
        }
        push = ConsumeType.valueOf(property) == ConsumeType.CONSUME_PASSIVELY;
        boolean startForAWhile = false;
        String property2 = prev.getProperties().getProperty(PROP_CONSUMER_START_TIMESTAMP);
        if (property2 == null) {
            property2 = String.valueOf(prev.getProperties().get(PROP_CONSUMER_START_TIMESTAMP));
        }
        boolean bl = startForAWhile = System.currentTimeMillis() - Long.parseLong(property2) > 120000L;
        if (push && startForAWhile) {
            for (Map.Entry<String, ConsumerRunningInfo> next : criTable.entrySet()) {
                ConsumerRunningInfo current = next.getValue();
                boolean equals = current.getSubscriptionSet().equals(prev.getSubscriptionSet());
                if (!equals) {
                    return false;
                }
                prev = next.getValue();
            }
            if (prev != null && prev.getSubscriptionSet().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public static boolean analyzeRebalance(TreeMap<String, ConsumerRunningInfo> criTable) {
        return true;
    }

    public static String analyzeProcessQueue(String clientId, ConsumerRunningInfo info) {
        StringBuilder sb = new StringBuilder();
        boolean push = false;
        String property = info.getProperties().getProperty(PROP_CONSUME_TYPE);
        if (property == null) {
            property = ((ConsumeType)((Object)info.getProperties().get(PROP_CONSUME_TYPE))).name();
        }
        push = ConsumeType.valueOf(property) == ConsumeType.CONSUME_PASSIVELY;
        boolean orderMsg = false;
        String property2 = info.getProperties().getProperty(PROP_CONSUME_ORDERLY);
        orderMsg = Boolean.parseBoolean(property2);
        if (push) {
            for (Map.Entry<MessageQueue, ProcessQueueInfo> next : info.getMqTable().entrySet()) {
                MessageQueue mq = next.getKey();
                ProcessQueueInfo pq = next.getValue();
                if (orderMsg) {
                    if (!pq.isLocked()) {
                        sb.append(String.format("%s %s can't lock for a while, %dms%n", clientId, mq, System.currentTimeMillis() - pq.getLastLockTimestamp()));
                        continue;
                    }
                    if (!pq.isDroped() || pq.getTryUnlockTimes() <= 0L) continue;
                    sb.append(String.format("%s %s unlock %d times, still failed%n", clientId, mq, pq.getTryUnlockTimes()));
                    continue;
                }
                long diff = System.currentTimeMillis() - pq.getLastConsumeTimestamp();
                if (diff <= 60000L || pq.getCachedMsgCount() <= 0) continue;
                sb.append(String.format("%s %s can't consume for a while, maybe blocked, %dms%n", clientId, mq, diff));
            }
        }
        return sb.toString();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public TreeSet<SubscriptionData> getSubscriptionSet() {
        return this.subscriptionSet;
    }

    public void setSubscriptionSet(TreeSet<SubscriptionData> subscriptionSet) {
        this.subscriptionSet = subscriptionSet;
    }

    public TreeMap<MessageQueue, ProcessQueueInfo> getMqTable() {
        return this.mqTable;
    }

    public void setMqTable(TreeMap<MessageQueue, ProcessQueueInfo> mqTable) {
        this.mqTable = mqTable;
    }

    public TreeMap<String, ConsumeStatus> getStatusTable() {
        return this.statusTable;
    }

    public void setStatusTable(TreeMap<String, ConsumeStatus> statusTable) {
        this.statusTable = statusTable;
    }

    /*
     * WARNING - void declaration
     */
    public String formatString() {
        String item;
        StringBuilder sb = new StringBuilder();
        sb.append("#Consumer Properties#\n");
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            item = String.format("%-40s: %s%n", entry.getKey().toString(), entry.getValue().toString());
            sb.append(item);
        }
        sb.append("\n\n#Consumer Subscription#\n");
        Iterator<Object> it = this.subscriptionSet.iterator();
        boolean bl = false;
        while (it.hasNext()) {
            void var3_5;
            SubscriptionData next = (SubscriptionData)it.next();
            String item2 = String.format("%03d Topic: %-40s ClassFilter: %-8s SubExpression: %s%n", (int)(++var3_5), next.getTopic(), next.isClassFilterMode(), next.getSubString());
            sb.append(item2);
        }
        sb.append("\n\n#Consumer Offset#\n");
        sb.append(String.format("%-32s  %-32s  %-4s  %-20s%n", "#Topic", "#Broker Name", "#QID", "#Consumer Offset"));
        for (Map.Entry entry : this.mqTable.entrySet()) {
            item = String.format("%-32s  %-32s  %-4d  %-20d%n", ((MessageQueue)entry.getKey()).getTopic(), ((MessageQueue)entry.getKey()).getBrokerName(), ((MessageQueue)entry.getKey()).getQueueId(), ((ProcessQueueInfo)entry.getValue()).getCommitOffset());
            sb.append(item);
        }
        sb.append("\n\n#Consumer MQ Detail#\n");
        sb.append(String.format("%-32s  %-32s  %-4s  %-20s%n", "#Topic", "#Broker Name", "#QID", "#ProcessQueueInfo"));
        for (Map.Entry entry : this.mqTable.entrySet()) {
            item = String.format("%-32s  %-32s  %-4d  %s%n", ((MessageQueue)entry.getKey()).getTopic(), ((MessageQueue)entry.getKey()).getBrokerName(), ((MessageQueue)entry.getKey()).getQueueId(), ((ProcessQueueInfo)entry.getValue()).toString());
            sb.append(item);
        }
        sb.append("\n\n#Consumer RT&TPS#\n");
        sb.append(String.format("%-32s  %14s %14s %14s %14s %18s %25s%n", "#Topic", "#Pull RT", "#Pull TPS", "#Consume RT", "#ConsumeOK TPS", "#ConsumeFailed TPS", "#ConsumeFailedMsgsInHour"));
        for (Map.Entry entry : this.statusTable.entrySet()) {
            item = String.format("%-32s  %14.2f %14.2f %14.2f %14.2f %18.2f %25d%n", entry.getKey(), ((ConsumeStatus)entry.getValue()).getPullRT(), ((ConsumeStatus)entry.getValue()).getPullTPS(), ((ConsumeStatus)entry.getValue()).getConsumeRT(), ((ConsumeStatus)entry.getValue()).getConsumeOKTPS(), ((ConsumeStatus)entry.getValue()).getConsumeFailedTPS(), ((ConsumeStatus)entry.getValue()).getConsumeFailedMsgs());
            sb.append(item);
        }
        if (this.jstack != null) {
            sb.append("\n\n#Consumer jstack#\n");
            sb.append(this.jstack);
        }
        return sb.toString();
    }

    public String getJstack() {
        return this.jstack;
    }

    public void setJstack(String jstack) {
        this.jstack = jstack;
    }
}

