/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsBrief {
    public static final int META_RANGE_INDEX = 0;
    public static final int META_SLOT_NUM_INDEX = 1;
    private long[][] topPercentileMeta;
    private AtomicInteger[] counts;
    private AtomicLong totalCount;
    private long max;
    private long min;
    private long total;

    public StatisticsBrief(long[][] topPercentileMeta) {
        if (!StatisticsBrief.isLegalMeta(topPercentileMeta)) {
            throw new IllegalArgumentException("illegal topPercentileMeta");
        }
        this.topPercentileMeta = topPercentileMeta;
        this.counts = new AtomicInteger[StatisticsBrief.slotNum(topPercentileMeta)];
        this.totalCount = new AtomicLong(0L);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == null) {
                this.counts[i] = new AtomicInteger(0);
                continue;
            }
            this.counts[i].set(0);
        }
        this.totalCount.set(0L);
        StatisticsBrief statisticsBrief = this;
        synchronized (statisticsBrief) {
            this.max = 0L;
            this.min = Long.MAX_VALUE;
            this.total = 0L;
        }
    }

    private static boolean isLegalMeta(long[][] meta) {
        if (ArrayUtils.isEmpty((Object[])meta)) {
            return false;
        }
        for (long[] line : meta) {
            if (!ArrayUtils.isEmpty(line) && line.length == 2) continue;
            return false;
        }
        return true;
    }

    private static int slotNum(long[][] meta) {
        int ret = 1;
        for (long[] line : meta) {
            ret = (int)((long)ret + line[1]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(long value) {
        int index = this.getSlotIndex(value);
        this.counts[index].incrementAndGet();
        this.totalCount.incrementAndGet();
        StatisticsBrief statisticsBrief = this;
        synchronized (statisticsBrief) {
            this.max = Math.max(this.max, value);
            this.min = Math.min(this.min, value);
            this.total += value;
        }
    }

    public long tp999() {
        return this.getTPValue(0.999f);
    }

    public long getTPValue(float ratio) {
        long count;
        long excludes;
        if (ratio <= 0.0f || ratio >= 1.0f) {
            ratio = 0.99f;
        }
        if ((excludes = (long)((float)(count = this.totalCount.get()) - (float)count * ratio)) == 0L) {
            return this.getMax();
        }
        int tmp = 0;
        for (int i = this.counts.length - 1; i > 0; --i) {
            if ((long)(tmp += this.counts[i].get()) <= excludes) continue;
            return Math.min(this.getSlotTPValue(i), this.getMax());
        }
        return 0L;
    }

    private long getSlotTPValue(int index) {
        int slotNumLeft = index;
        for (int i = 0; i < this.topPercentileMeta.length; ++i) {
            int slotNum = (int)this.topPercentileMeta[i][1];
            if (slotNumLeft < slotNum) {
                long metaRangeMax = this.topPercentileMeta[i][0];
                long metaRangeMin = 0L;
                if (i > 0) {
                    metaRangeMin = this.topPercentileMeta[i - 1][0];
                }
                return metaRangeMin + (metaRangeMax - metaRangeMin) / (long)slotNum * (long)(slotNumLeft + 1);
            }
            slotNumLeft -= slotNum;
        }
        return Integer.MAX_VALUE;
    }

    private int getSlotIndex(long num) {
        int index = 0;
        for (int i = 0; i < this.topPercentileMeta.length; ++i) {
            long rangeMin;
            long rangeMax = this.topPercentileMeta[i][0];
            int slotNum = (int)this.topPercentileMeta[i][1];
            long l = rangeMin = i > 0 ? this.topPercentileMeta[i - 1][0] : 0L;
            if (rangeMin <= num && num < rangeMax) {
                index = (int)((long)index + (num - rangeMin) / ((rangeMax - rangeMin) / (long)slotNum));
                break;
            }
            index += slotNum;
        }
        return index;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.totalCount.get() > 0L ? this.min : 0L;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCnt() {
        return this.totalCount.get();
    }

    public double getAvg() {
        return this.totalCount.get() != 0L ? (double)this.total / (double)this.totalCount.get() : 0.0;
    }
}

