/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeMessageOrderlyByGroupService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeRequest;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.MergeThreadExecutor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.MessageQueueGroupLock;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.QueuePair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConsumeThreadExecutor {
    private static final InternalLogger LOG = ClientLogger.getLog();
    private final ThreadPoolExecutor threadPoolExecutor;
    private final MessageQueueGroupLock consumeRequestLock = new MessageQueueGroupLock();
    private final MessageQueueGroupLock shardingKeyLock = new MessageQueueGroupLock();
    private final MergeThreadExecutor mergeThreadExecutor;
    private ConsumeMessageOrderlyByGroupService cs;
    private ConcurrentHashMap<ConsumeRequest, ConsumeRequest> consumeRequestMap = new ConcurrentHashMap();

    public ConsumeThreadExecutor(ConsumeMessageOrderlyByGroupService cs, MergeThreadExecutor mergeThreadExecutor) {
        this.cs = cs;
        this.mergeThreadExecutor = mergeThreadExecutor;
        this.threadPoolExecutor = new ThreadPoolExecutor(cs.getDefaultMQPushConsumer().getConsumeThreadMin(), cs.getDefaultMQPushConsumer().getConsumeThreadMax(), 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("ConsumeMessageThread_"));
    }

    public void shutdown() {
        this.threadPoolExecutor.shutdown();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.mergeThreadExecutor.setCorePoolSize(corePoolSize / 2);
        this.threadPoolExecutor.setCorePoolSize(corePoolSize);
    }

    public int getCorePoolSize() {
        return this.threadPoolExecutor.getCorePoolSize();
    }

    public void allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.threadPoolExecutor.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    public MessageQueueGroupLock getConsumeRequestLock() {
        return this.consumeRequestLock;
    }

    public MessageQueueGroupLock getShardingKeyLock() {
        return this.shardingKeyLock;
    }

    public void remove(ConsumeRequest consumeRequest) {
        this.consumeRequestMap.remove(consumeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(ConsumeRequest consumeRequest, List<Pair<QueuePair, Integer>> queuePairList, boolean force) {
        Object objLock;
        Object object = objLock = this.consumeRequestLock.fetchLockObject(consumeRequest.getMessageQueueGroup(), consumeRequest.getShardingKeyIndex());
        synchronized (object) {
            ConsumeRequest prevRequest = this.consumeRequestMap.putIfAbsent(consumeRequest, consumeRequest);
            if (prevRequest == null || force) {
                if (prevRequest == null) {
                    consumeRequest.getQueueToConsume().addAll(queuePairList);
                }
                try {
                    this.threadPoolExecutor.submit(consumeRequest);
                }
                catch (Exception e) {
                    LOG.error("error submit consume request: {}, mq group: {}, shardingKeyIndex: {}", e.toString(), consumeRequest.getMessageQueueGroup(), consumeRequest.getShardingKeyIndex());
                }
            } else {
                this.consumeRequestMap.get(consumeRequest).getQueueToConsume().addAll(queuePairList);
            }
        }
    }

    public void submitLater(final ConsumeRequest consumeRequest, long suspendTimeMillis) {
        long timeMillis = suspendTimeMillis;
        if (timeMillis == -1L) {
            timeMillis = this.cs.getDefaultMQPushConsumer().getSuspendCurrentQueueTimeMillis();
        }
        timeMillis = Math.max(10L, timeMillis);
        timeMillis = Math.min(30000L, timeMillis);
        this.cs.getScheduledExecutorService().schedule(new Runnable(){

            @Override
            public void run() {
                ConsumeThreadExecutor.this.submit(consumeRequest, null, true);
            }
        }, timeMillis, TimeUnit.MILLISECONDS);
    }

    public void tryLockLaterAndConsumeAgain(final ConsumeRequest consumeRequest, final MessageQueue mq, long delayMills) {
        this.cs.getScheduledExecutorService().schedule(new Runnable(){

            @Override
            public void run() {
                boolean lockOK = ConsumeThreadExecutor.this.cs.lockOneMessageQueue(mq);
                if (lockOK) {
                    ConsumeThreadExecutor.this.submitLater(consumeRequest, 10L);
                } else {
                    ConsumeThreadExecutor.this.submitLater(consumeRequest, 3000L);
                }
            }
        }, delayMills, TimeUnit.MILLISECONDS);
    }
}

