// $ANTLR 3.5.2 PhoenixSQL.g 2018-10-26 13:14:53

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.filter.CompareFilter.CompareOp;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "BETWEEN", 
		"BIND_NAME", "BY", "CACHE", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_ESC", 
		"CLOSE", "COLON", "COLUMN", "COLUMNS", "COMMA", "COMMENT_AND_HINT_END", 
		"COMMENT_START", "CONCAT", "CONSTANT", "CONSTRAINT", "CREATE", "CURRENT", 
		"CURSOR", "CYCLE", "DBL_QUOTE_CHAR", "DECIMAL", "DECLARE", "DEFAULT", 
		"DEFAULTVALUE", "DELETE", "DESC", "DIGIT", "DISABLE", "DISTINCT", "DIVIDE", 
		"DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", "DROP", "DUPLICATE", "ELSE", 
		"END", "EOL", "EQ", "EXECUTE", "EXISTS", "EXPLAIN", "Exponent", "FALSE", 
		"FETCH", "FIELDCHAR", "FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GROUP", 
		"GT", "HAVING", "HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", "IN", 
		"INCLUDE", "INCREMENT", "INDEX", "INNER", "INTO", "IS", "JAR", "JARS", 
		"JOIN", "KEY", "LAST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", 
		"LOCAL", "LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "MODIFY", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NULL", 
		"NULLS", "NUMBER", "OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", 
		"OTHER", "OUTER", "OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "PRIMARY", 
		"QUESTION", "RCURLY", "REBUILD", "REPLACE", "RETURNS", "RIGHT", "ROW", 
		"ROWS", "ROW_TIMESTAMP", "RPAREN", "RSQUARE", "SAMPLING", "SCHEMA", "SELECT", 
		"SEMICOLON", "SEQUENCE", "SESSION", "SET", "SL_COMMENT", "SL_COMMENT1", 
		"SL_COMMENT2", "SOME", "SPLIT", "START", "STATISTICS", "STRING_LITERAL", 
		"TABLE", "TABLES", "TABLESAMPLE", "TEMPORARY", "THEN", "TILDE", "TRACE", 
		"TRUE", "UNION", "UNUSABLE", "UPDATE", "UPGRADE", "UPSERT", "USABLE", 
		"USE", "USING", "VALUE", "VALUES", "VIEW", "WHEN", "WHERE", "WITH", "WITHIN", 
		"WS"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int BETWEEN=16;
	public static final int BIND_NAME=17;
	public static final int BY=18;
	public static final int CACHE=19;
	public static final int CASCADE=20;
	public static final int CASE=21;
	public static final int CAST=22;
	public static final int CHAR=23;
	public static final int CHAR_ESC=24;
	public static final int CLOSE=25;
	public static final int COLON=26;
	public static final int COLUMN=27;
	public static final int COLUMNS=28;
	public static final int COMMA=29;
	public static final int COMMENT_AND_HINT_END=30;
	public static final int COMMENT_START=31;
	public static final int CONCAT=32;
	public static final int CONSTANT=33;
	public static final int CONSTRAINT=34;
	public static final int CREATE=35;
	public static final int CURRENT=36;
	public static final int CURSOR=37;
	public static final int CYCLE=38;
	public static final int DBL_QUOTE_CHAR=39;
	public static final int DECIMAL=40;
	public static final int DECLARE=41;
	public static final int DEFAULT=42;
	public static final int DEFAULTVALUE=43;
	public static final int DELETE=44;
	public static final int DESC=45;
	public static final int DIGIT=46;
	public static final int DISABLE=47;
	public static final int DISTINCT=48;
	public static final int DIVIDE=49;
	public static final int DOT=50;
	public static final int DOUBLE=51;
	public static final int DOUBLE_EQ=52;
	public static final int DOUBLE_QUOTE=53;
	public static final int DROP=54;
	public static final int DUPLICATE=55;
	public static final int ELSE=56;
	public static final int END=57;
	public static final int EOL=58;
	public static final int EQ=59;
	public static final int EXECUTE=60;
	public static final int EXISTS=61;
	public static final int EXPLAIN=62;
	public static final int Exponent=63;
	public static final int FALSE=64;
	public static final int FETCH=65;
	public static final int FIELDCHAR=66;
	public static final int FIRST=67;
	public static final int FOR=68;
	public static final int FROM=69;
	public static final int FULL=70;
	public static final int FUNCTION=71;
	public static final int GROUP=72;
	public static final int GT=73;
	public static final int HAVING=74;
	public static final int HINT_START=75;
	public static final int IF=76;
	public static final int IGNORE=77;
	public static final int ILIKE=78;
	public static final int IMMUTABLE=79;
	public static final int IN=80;
	public static final int INCLUDE=81;
	public static final int INCREMENT=82;
	public static final int INDEX=83;
	public static final int INNER=84;
	public static final int INTO=85;
	public static final int IS=86;
	public static final int JAR=87;
	public static final int JARS=88;
	public static final int JOIN=89;
	public static final int KEY=90;
	public static final int LAST=91;
	public static final int LCURLY=92;
	public static final int LEFT=93;
	public static final int LETTER=94;
	public static final int LIKE=95;
	public static final int LIMIT=96;
	public static final int LIST=97;
	public static final int LOCAL=98;
	public static final int LPAREN=99;
	public static final int LSQUARE=100;
	public static final int LT=101;
	public static final int MAXVALUE=102;
	public static final int MINUS=103;
	public static final int MINVALUE=104;
	public static final int ML_COMMENT=105;
	public static final int ML_HINT=106;
	public static final int MODIFY=107;
	public static final int NAME=108;
	public static final int NEXT=109;
	public static final int NOEQ1=110;
	public static final int NOEQ2=111;
	public static final int NOT=112;
	public static final int NULL=113;
	public static final int NULLS=114;
	public static final int NUMBER=115;
	public static final int OFF=116;
	public static final int OFFSET=117;
	public static final int ON=118;
	public static final int ONLY=119;
	public static final int OPEN=120;
	public static final int OR=121;
	public static final int ORDER=122;
	public static final int OTHER=123;
	public static final int OUTER=124;
	public static final int OUTER_JOIN=125;
	public static final int PERCENT=126;
	public static final int PLUS=127;
	public static final int POSINTEGER=128;
	public static final int PRIMARY=129;
	public static final int QUESTION=130;
	public static final int RCURLY=131;
	public static final int REBUILD=132;
	public static final int REPLACE=133;
	public static final int RETURNS=134;
	public static final int RIGHT=135;
	public static final int ROW=136;
	public static final int ROWS=137;
	public static final int ROW_TIMESTAMP=138;
	public static final int RPAREN=139;
	public static final int RSQUARE=140;
	public static final int SAMPLING=141;
	public static final int SCHEMA=142;
	public static final int SELECT=143;
	public static final int SEMICOLON=144;
	public static final int SEQUENCE=145;
	public static final int SESSION=146;
	public static final int SET=147;
	public static final int SL_COMMENT=148;
	public static final int SL_COMMENT1=149;
	public static final int SL_COMMENT2=150;
	public static final int SOME=151;
	public static final int SPLIT=152;
	public static final int START=153;
	public static final int STATISTICS=154;
	public static final int STRING_LITERAL=155;
	public static final int TABLE=156;
	public static final int TABLES=157;
	public static final int TABLESAMPLE=158;
	public static final int TEMPORARY=159;
	public static final int THEN=160;
	public static final int TILDE=161;
	public static final int TRACE=162;
	public static final int TRUE=163;
	public static final int UNION=164;
	public static final int UNUSABLE=165;
	public static final int UPDATE=166;
	public static final int UPGRADE=167;
	public static final int UPSERT=168;
	public static final int USABLE=169;
	public static final int USE=170;
	public static final int USING=171;
	public static final int VALUE=172;
	public static final int VALUES=173;
	public static final int VIEW=174;
	public static final int WHEN=175;
	public static final int WHERE=176;
	public static final int WITH=177;
	public static final int WITHIN=178;
	public static final int WS=179;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }
	    
	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:381:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:382:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==LIST||LA1_0==OPEN||LA1_0==SELECT||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:382:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1253);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1257); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:389:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1266); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:393:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:394:5: (s= oneStatement EOF )
			// PhoenixSQL.g:394:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1292);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1296); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:404:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:405:5: (s= select_node EOF )
			// PhoenixSQL.g:405:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1322);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1324); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:409:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:411:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:411:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:411:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=29;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=21;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case SEQUENCE:
					{
					alt2=23;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=17;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=8;
				}
				break;
			case CLOSE:
				{
				alt2=9;
				}
				break;
			case FETCH:
				{
				alt2=10;
				}
				break;
			case DECLARE:
				{
				alt2=11;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=13;
					}
					break;
				case FUNCTION:
					{
					alt2=18;
					}
					break;
				case SEQUENCE:
					{
					alt2=24;
					}
					break;
				case SCHEMA:
					{
					alt2=25;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=12;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case SESSION:
					{
					alt2=22;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=15;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TRACE:
				{
				alt2=16;
				}
				break;
			case ADD:
				{
				alt2=19;
				}
				break;
			case LIST:
				{
				alt2=20;
				}
				break;
			case USE:
				{
				alt2=26;
				}
				break;
			case UPDATE:
				{
				alt2=27;
				}
				break;
			case EXECUTE:
				{
				alt2=28;
				}
				break;
			case EXPLAIN:
				{
				alt2=29;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:411:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1356);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:412:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1366);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:413:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1378);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:414:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1390);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:415:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1402);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:416:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1414);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:417:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1426);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:418:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1438);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:419:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1450);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:420:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1462);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:421:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1474);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:422:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1486);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:423:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1498);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:424:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1510);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:425:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1522);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:426:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1534);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:427:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1546);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:428:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1558);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:429:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1570);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:430:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1582);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:431:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1594);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:432:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1606);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:433:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1616);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:434:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1626);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:435:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1636);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:436:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1646);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:437:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1658);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:438:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1670);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:439:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1682);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:443:1: explain_node returns [BindableStatement ret] : EXPLAIN q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement q =null;

		try {
			// PhoenixSQL.g:444:5: ( EXPLAIN q= oneStatement )
			// PhoenixSQL.g:444:9: EXPLAIN q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1715); if (state.failed) return ret;
			pushFollow(FOLLOW_oneStatement_in_explain_node1719);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =factory.explain(q);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:448:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;

		try {
			// PhoenixSQL.g:449:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? )
			// PhoenixSQL.g:449:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1745); if (state.failed) return ret;
			// PhoenixSQL.g:449:16: (im= IMMUTABLE )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==IMMUTABLE) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:449:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1750); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node1754); if (state.failed) return ret;
			// PhoenixSQL.g:449:38: ( IF NOT ex= EXISTS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==IF) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:449:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node1757); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node1759); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node1763); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node1769);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:450:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:450:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node1781); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node1785);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:450:31: (pk= pk_constraint )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==COMMA||LA5_0==CONSTRAINT) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:450:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node1790);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node1794); if (state.failed) return ret;
			}

			// PhoenixSQL.g:451:9: (p= fam_properties )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==NAME) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:451:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node1808);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:452:9: ( SPLIT ON s= value_expression_list )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==SPLIT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:452:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node1821); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node1823); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node1827);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:457:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:458:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:458:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node1866); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node1868); if (state.failed) return ret;
			// PhoenixSQL.g:458:23: ( IF NOT ex= EXISTS )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==IF) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:458:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node1871); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node1873); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node1877); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:458:43: ( DEFAULT |s= identifier )
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==DEFAULT) ) {
				alt9=1;
			}
			else if ( (LA9_0==NAME) ) {
				alt9=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}

			switch (alt9) {
				case 1 :
					// PhoenixSQL.g:458:44: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_create_schema_node1882); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:458:54: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_create_schema_node1888);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:463:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:464:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:464:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node1923); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node1925); if (state.failed) return ret;
			// PhoenixSQL.g:464:21: ( IF NOT ex= EXISTS )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==IF) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// PhoenixSQL.g:464:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node1928); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node1930); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node1934); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node1940);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:465:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==LPAREN) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:465:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node1952); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node1956);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:465:31: (pk= pk_constraint )?
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==COMMA||LA11_0==CONSTRAINT) ) {
						alt11=1;
					}
					switch (alt11) {
						case 1 :
							// PhoenixSQL.g:465:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node1961);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node1965); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:466:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==AS) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// PhoenixSQL.g:466:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node1979); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node1981); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node1983); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node1995); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node1999);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:468:11: ( WHERE w= expression )?
					int alt13=2;
					int LA13_0 = input.LA(1);
					if ( (LA13_0==WHERE) ) {
						alt13=1;
					}
					switch (alt13) {
						case 1 :
							// PhoenixSQL.g:468:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node2012); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node2016);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:469:9: (p= fam_properties )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==NAME) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// PhoenixSQL.g:469:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2034);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:474:1: create_index_node returns [CreateIndexStatement ret] : CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token l=null;
		Token ex=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:475:5: ( CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:475:9: CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2070); if (state.failed) return ret;
			// PhoenixSQL.g:475:17: (l= LOCAL )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==LOCAL) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// PhoenixSQL.g:475:17: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2074); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2077); if (state.failed) return ret;
			// PhoenixSQL.g:475:31: ( IF NOT ex= EXISTS )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==IF) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:475:32: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2080); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2082); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2086); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2092);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2094); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2098);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:476:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:476:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2109); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2113);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2115); if (state.failed) return ret;
			}

			// PhoenixSQL.g:477:9: ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==INCLUDE) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// PhoenixSQL.g:477:10: INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2127); if (state.failed) return ret;
					// PhoenixSQL.g:477:18: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:477:19: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2130); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2134);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2136); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:478:9: (async= ASYNC )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==ASYNC) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// PhoenixSQL.g:478:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2152); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:479:9: (p= fam_properties )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==NAME) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// PhoenixSQL.g:479:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2167);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:480:9: ( SPLIT ON v= value_expression_list )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==SPLIT) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// PhoenixSQL.g:480:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2180); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2182); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2186);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null, l==null ? IndexType.getDefault() : IndexType.LOCAL, async != null, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:485:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:486:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:486:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2222); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2224); if (state.failed) return ret;
			// PhoenixSQL.g:486:26: ( IF NOT ex= EXISTS )?
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==IF) ) {
				alt22=1;
			}
			switch (alt22) {
				case 1 :
					// PhoenixSQL.g:486:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node2228); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node2230); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node2234); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node2240);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:487:9: ( START ( WITH )? s= value_expression )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==START) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// PhoenixSQL.g:487:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node2251); if (state.failed) return ret;
					// PhoenixSQL.g:487:16: ( WITH )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==WITH) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// PhoenixSQL.g:487:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node2253); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2258);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:488:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==INCREMENT) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PhoenixSQL.g:488:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node2271); if (state.failed) return ret;
					// PhoenixSQL.g:488:20: ( BY )?
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==BY) ) {
						alt25=1;
					}
					switch (alt25) {
						case 1 :
							// PhoenixSQL.g:488:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node2273); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2278);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:489:9: ( MINVALUE min= value_expression )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==MINVALUE) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// PhoenixSQL.g:489:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node2291); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2295);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:490:9: ( MAXVALUE max= value_expression )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==MAXVALUE) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:490:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node2308); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2312);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:491:9: (cyc= CYCLE )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==CYCLE) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// PhoenixSQL.g:491:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node2327); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:492:9: ( CACHE c= int_literal_or_bind )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==CACHE) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:492:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node2341); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node2345);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:496:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:497:5: (n= int_or_long_literal |b= bind_expression )
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==NUMBER) ) {
				alt31=1;
			}
			else if ( (LA31_0==BIND_NAME||LA31_0==QUESTION) ) {
				alt31=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}

			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:497:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind2376);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:498:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind2388);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:502:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:503:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:503:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node2414); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node2416); if (state.failed) return ret;
			// PhoenixSQL.g:503:24: ( IF ex= EXISTS )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==IF) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:503:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node2420); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node2424); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node2430);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:507:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:508:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:508:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:508:9: ( COMMA )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==COMMA) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:508:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint2459); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint2462); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint2466);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint2468); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint2470); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint2472); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2476);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint2478); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:511:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:513:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:513:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2509);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:513:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==COMMA) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// PhoenixSQL.g:513:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2515); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2521);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop34;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:516:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:517:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:517:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2548);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:517:22: (order= ASC |order= DESC )?
			int alt35=3;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==ASC) ) {
				alt35=1;
			}
			else if ( (LA35_0==DESC) ) {
				alt35=2;
			}
			switch (alt35) {
				case 1 :
					// PhoenixSQL.g:517:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2553); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:517:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2557); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:517:46: (rr= ROW_TIMESTAMP )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==ROW_TIMESTAMP) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// PhoenixSQL.g:517:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2564); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:521:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:522:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:522:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint2599);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:525:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:527:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:527:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2626);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:527:54: ( COMMA p= expression_with_sort_order )*
			loop37:
			while (true) {
				int alt37=2;
				int LA37_0 = input.LA(1);
				if ( (LA37_0==COMMA) ) {
					alt37=1;
				}

				switch (alt37) {
				case 1 :
					// PhoenixSQL.g:527:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list2632); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2638);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop37;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:530:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:531:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:531:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:531:9: (x= expression )
			// PhoenixSQL.g:531:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order2665);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:531:24: (order= ASC |order= DESC )?
			int alt38=3;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==ASC) ) {
				alt38=1;
			}
			else if ( (LA38_0==DESC) ) {
				alt38=2;
			}
			switch (alt38) {
				case 1 :
					// PhoenixSQL.g:531:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order2671); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:531:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order2675); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:534:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:536:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:536:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties2703);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties2705); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties2709);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:536:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop39:
			while (true) {
				int alt39=2;
				int LA39_0 = input.LA(1);
				if ( (LA39_0==COMMA) ) {
					alt39=1;
				}

				switch (alt39) {
				case 1 :
					// PhoenixSQL.g:536:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties2715); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties2719);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties2721); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties2725);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop39;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:539:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:540:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==NAME) ) {
				int LA40_1 = input.LA(2);
				if ( (LA40_1==EQ) ) {
					alt40=1;
				}
				else if ( (LA40_1==DOT) ) {
					alt40=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 40, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:540:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name2755);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:541:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name2769);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name2771); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name2775);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:544:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:545:5: (v= identifier |l= literal )
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==NAME) ) {
				int LA41_1 = input.LA(2);
				if ( (LA41_1==EOF||LA41_1==COMMA||LA41_1==SEMICOLON||LA41_1==SPLIT) ) {
					alt41=1;
				}
				else if ( (LA41_1==STRING_LITERAL) ) {
					alt41=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 41, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA41_0==DECIMAL||LA41_0==DOUBLE||LA41_0==FALSE||LA41_0==NULL||LA41_0==NUMBER||LA41_0==STRING_LITERAL||LA41_0==TRUE) ) {
				alt41=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}

			switch (alt41) {
				case 1 :
					// PhoenixSQL.g:545:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value2806);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:546:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value2820);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:549:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:550:5: (field= identifier |family= identifier DOT field= identifier )
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==NAME) ) {
				int LA42_1 = input.LA(2);
				if ( (LA42_1==EOF||LA42_1==COMMA||LA42_1==EQ||LA42_1==NAME||LA42_1==RPAREN||LA42_1==SEMICOLON) ) {
					alt42=1;
				}
				else if ( (LA42_1==DOT) ) {
					alt42=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 42, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:550:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name2851);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:551:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name2865);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name2867); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name2871);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:554:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:556:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:556:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names2903);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:556:40: ( COMMA v= column_name )*
			loop43:
			while (true) {
				int alt43=2;
				int LA43_0 = input.LA(1);
				if ( (LA43_0==COMMA) ) {
					alt43=1;
				}

				switch (alt43) {
				case 1 :
					// PhoenixSQL.g:556:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names2909); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names2915);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop43;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:561:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:562:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:562:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node2942); if (state.failed) return ret;
			// PhoenixSQL.g:562:14: (v= VIEW | TABLE )
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==VIEW) ) {
				alt44=1;
			}
			else if ( (LA44_0==TABLE) ) {
				alt44=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}

			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:562:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node2947); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:562:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node2951); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:562:31: ( IF ex= EXISTS )?
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==IF) ) {
				alt45=1;
			}
			switch (alt45) {
				case 1 :
					// PhoenixSQL.g:562:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node2955); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node2959); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node2965);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:562:65: (c= CASCADE )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==CASCADE) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// PhoenixSQL.g:562:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node2970); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:566:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:567:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:567:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node3005); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node3007); if (state.failed) return ret;
			// PhoenixSQL.g:567:21: ( IF ex= EXISTS )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==IF) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// PhoenixSQL.g:567:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node3010); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node3014); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3020);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:567:50: (c= CASCADE )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==CASCADE) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:567:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3025); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:573:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:574:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:574:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3060); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3062); if (state.failed) return ret;
			// PhoenixSQL.g:574:18: ( IF ex= EXISTS )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==IF) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// PhoenixSQL.g:574:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3065); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3069); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3075);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3077); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3081);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:579:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )? ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:580:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )? )
			// PhoenixSQL.g:580:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )?
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3111); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3113); if (state.failed) return ret;
			// PhoenixSQL.g:580:19: ( IF ex= EXISTS )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==IF) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// PhoenixSQL.g:580:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3116); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3120); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3126);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3128); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3132);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			s=input.LT(1);
			if ( input.LA(1)==ACTIVE||input.LA(1)==DISABLE||input.LA(1)==REBUILD||input.LA(1)==UNUSABLE||input.LA(1)==USABLE ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			// PhoenixSQL.g:580:120: (async= ASYNC )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==ASYNC) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// PhoenixSQL.g:580:121: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node3159); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), async!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:585:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:586:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:586:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node3193); if (state.failed) return ret;
			// PhoenixSQL.g:586:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==ON) ) {
				alt53=1;
			}
			else if ( (LA53_0==OFF) ) {
				alt53=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:586:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:586:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:586:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node3201); if (state.failed) return ret;
					// PhoenixSQL.g:586:28: ( WITH SAMPLING s= sampling_rate )?
					int alt52=2;
					int LA52_0 = input.LA(1);
					if ( (LA52_0==WITH) ) {
						alt52=1;
					}
					switch (alt52) {
						case 1 :
							// PhoenixSQL.g:586:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node3206); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node3208); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node3214);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:586:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node3225); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:591:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:592:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:592:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node3259); if (state.failed) return ret;
			// PhoenixSQL.g:592:16: ( OR replace= REPLACE )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==OR) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:592:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node3262); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node3266); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:592:38: (temp= TEMPORARY )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==TEMPORARY) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// PhoenixSQL.g:592:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node3273); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node3277); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3281);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:593:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:593:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node3292); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node3296);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node3298); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node3308); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3312);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node3314); if (state.failed) return ret;
			// PhoenixSQL.g:594:32: (className= jar_path )
			// PhoenixSQL.g:594:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node3320);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:595:8: ( USING JAR (jarPath= jar_path ) )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==USING) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// PhoenixSQL.g:595:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node3331); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node3333); if (state.failed) return ret;
					// PhoenixSQL.g:595:19: (jarPath= jar_path )
					// PhoenixSQL.g:595:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node3340);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:601:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:602:5: (l= literal )
			// PhoenixSQL.g:602:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path3377);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:605:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:606:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:606:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node3400); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node3402); if (state.failed) return ret;
			// PhoenixSQL.g:606:21: ( IF ex= EXISTS )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==IF) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// PhoenixSQL.g:606:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node3405); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node3409); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node3415);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:609:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:610:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:610:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node3438); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node3440); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node3446);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:613:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:614:5: ( LIST JARS )
			// PhoenixSQL.g:614:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node3469); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node3471); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:617:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:618:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:618:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node3494); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node3496); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node3502);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:622:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:623:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:623:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node3528); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node3530); if (state.failed) return ret;
			// PhoenixSQL.g:623:23: ( SET p= properties )
			// PhoenixSQL.g:623:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node3533); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node3537);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:628:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( DROP COLUMN ( IF ex= EXISTS )? c= column_names | ( ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )? | SET p= fam_properties ) | MODIFY ( IF NOT ex= EXISTS )? cd= column_def ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> cds =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		ColumnDef cd =null;

		 PTableType tt = null;
		try {
			// PhoenixSQL.g:630:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( DROP COLUMN ( IF ex= EXISTS )? c= column_names | ( ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )? | SET p= fam_properties ) | MODIFY ( IF NOT ex= EXISTS )? cd= column_def ) )
			// PhoenixSQL.g:630:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( DROP COLUMN ( IF ex= EXISTS )? c= column_names | ( ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )? | SET p= fam_properties ) | MODIFY ( IF NOT ex= EXISTS )? cd= column_def )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node3576); if (state.failed) return ret;
			// PhoenixSQL.g:630:15: ( TABLE |v= VIEW )
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==TABLE) ) {
				alt58=1;
			}
			else if ( (LA58_0==VIEW) ) {
				alt58=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}

			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:630:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node3579); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:630:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node3585); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node3590);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW;}
			// PhoenixSQL.g:631:13: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names | ( ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )? | SET p= fam_properties ) | MODIFY ( IF NOT ex= EXISTS )? cd= column_def )
			int alt64=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt64=1;
				}
				break;
			case ADD:
			case SET:
				{
				alt64=2;
				}
				break;
			case MODIFY:
				{
				alt64=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}
			switch (alt64) {
				case 1 :
					// PhoenixSQL.g:632:17: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node3624); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node3626); if (state.failed) return ret;
					// PhoenixSQL.g:632:29: ( IF ex= EXISTS )?
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==IF) ) {
						alt59=1;
					}
					switch (alt59) {
						case 1 :
							// PhoenixSQL.g:632:30: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3629); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3633); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node3639);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.dropColumn(factory.namedTable(null, t), tt, c, ex!=null);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:634:21: ( ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )? | SET p= fam_properties )
					{
					// PhoenixSQL.g:634:21: ( ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )? | SET p= fam_properties )
					int alt62=2;
					int LA62_0 = input.LA(1);
					if ( (LA62_0==ADD) ) {
						alt62=1;
					}
					else if ( (LA62_0==SET) ) {
						alt62=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 62, 0, input);
						throw nvae;
					}

					switch (alt62) {
						case 1 :
							// PhoenixSQL.g:635:25: ADD ( IF NOT ex= EXISTS )? cds= column_defs (p= fam_properties )?
							{
							match(input,ADD,FOLLOW_ADD_in_alter_table_node3707); if (state.failed) return ret;
							// PhoenixSQL.g:635:29: ( IF NOT ex= EXISTS )?
							int alt60=2;
							int LA60_0 = input.LA(1);
							if ( (LA60_0==IF) ) {
								alt60=1;
							}
							switch (alt60) {
								case 1 :
									// PhoenixSQL.g:635:30: IF NOT ex= EXISTS
									{
									match(input,IF,FOLLOW_IF_in_alter_table_node3710); if (state.failed) return ret;
									match(input,NOT,FOLLOW_NOT_in_alter_table_node3712); if (state.failed) return ret;
									ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3716); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_column_defs_in_alter_table_node3722);
							cds=column_defs();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:635:65: (p= fam_properties )?
							int alt61=2;
							int LA61_0 = input.LA(1);
							if ( (LA61_0==NAME) ) {
								alt61=1;
							}
							switch (alt61) {
								case 1 :
									// PhoenixSQL.g:635:66: p= fam_properties
									{
									pushFollow(FOLLOW_fam_properties_in_alter_table_node3727);
									p=fam_properties();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;

							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:636:27: SET p= fam_properties
							{
							match(input,SET,FOLLOW_SET_in_alter_table_node3757); if (state.failed) return ret;
							pushFollow(FOLLOW_fam_properties_in_alter_table_node3761);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.addColumn(factory.namedTable(null, t), tt, cds, ex!=null, p);}
					}
					break;
				case 3 :
					// PhoenixSQL.g:638:19: MODIFY ( IF NOT ex= EXISTS )? cd= column_def
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_alter_table_node3806); if (state.failed) return ret;
					// PhoenixSQL.g:638:26: ( IF NOT ex= EXISTS )?
					int alt63=2;
					int LA63_0 = input.LA(1);
					if ( (LA63_0==IF) ) {
						alt63=1;
					}
					switch (alt63) {
						case 1 :
							// PhoenixSQL.g:638:27: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3809); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node3811); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3815); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_def_in_alter_table_node3821);
					cd=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.modifyColumn(factory.namedTable(null, t), tt, cd, ex!=null);}
					}
					break;

			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:642:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:643:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:643:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node3857); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node3859); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node3863);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:643:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt65=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt65=1;
					}
					break;
				case ALL:
					{
					alt65=2;
					}
					break;
				case COLUMNS:
					{
					alt65=3;
					}
					break;
			}
			switch (alt65) {
				case 1 :
					// PhoenixSQL.g:643:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node3868); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:643:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node3874); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:643:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node3880); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:643:73: ( SET (p= properties ) )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==SET) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// PhoenixSQL.g:643:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node3885); if (state.failed) return ret;
					// PhoenixSQL.g:643:78: (p= properties )
					// PhoenixSQL.g:643:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node3890);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:647:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:648:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:648:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node3914); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node3916); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:652:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:653:5: (p= identifier )
			// PhoenixSQL.g:653:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name3942);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:656:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:658:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:658:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties3976);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties3978); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties3982);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:658:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop67:
			while (true) {
				int alt67=2;
				int LA67_0 = input.LA(1);
				if ( (LA67_0==COMMA) ) {
					alt67=1;
				}

				switch (alt67) {
				case 1 :
					// PhoenixSQL.g:658:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties3988); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties3992);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties3994); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties3998);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop67;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:661:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:663:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:663:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs4033);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:663:39: ( COMMA v= column_def )*
			loop68:
			while (true) {
				int alt68=2;
				int LA68_0 = input.LA(1);
				if ( (LA68_0==COMMA) ) {
					int LA68_1 = input.LA(2);
					if ( (LA68_1==NAME) ) {
						alt68=1;
					}

				}

				switch (alt68) {
				case 1 :
					// PhoenixSQL.g:663:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs4039); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs4045);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop68;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:666:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:667:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? )
			// PhoenixSQL.g:667:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			{
			pushFollow(FOLLOW_column_name_in_column_def4071);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def4075);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:667:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==LPAREN) ) {
				alt70=1;
			}
			switch (alt70) {
				case 1 :
					// PhoenixSQL.g:667:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def4078); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4082); if (state.failed) return ret;
					// PhoenixSQL.g:667:54: ( COMMA s= NUMBER )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==COMMA) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// PhoenixSQL.g:667:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def4085); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4089); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def4093); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:667:83: (ar= ARRAY )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==ARRAY) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:667:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def4099); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:667:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==LSQUARE) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:667:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def4105); if (state.failed) return ret;
					// PhoenixSQL.g:667:104: (a= NUMBER )?
					int alt72=2;
					int LA72_0 = input.LA(1);
					if ( (LA72_0==NUMBER) ) {
						alt72=1;
					}
					switch (alt72) {
						case 1 :
							// PhoenixSQL.g:667:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4110); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def4114); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:667:126: ( (nn= NOT )? n= NULL )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( ((LA75_0 >= NOT && LA75_0 <= NULL)) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// PhoenixSQL.g:667:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:667:129: (nn= NOT )?
					int alt74=2;
					int LA74_0 = input.LA(1);
					if ( (LA74_0==NOT) ) {
						alt74=1;
					}
					switch (alt74) {
						case 1 :
							// PhoenixSQL.g:667:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def4121); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def4126); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:667:144: ( DEFAULT df= expression )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==DEFAULT) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// PhoenixSQL.g:667:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def4131); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def4135);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:667:169: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==PRIMARY) ) {
				alt79=1;
			}
			switch (alt79) {
				case 1 :
					// PhoenixSQL.g:667:170: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def4142); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def4144); if (state.failed) return ret;
					// PhoenixSQL.g:667:185: (order= ASC |order= DESC )?
					int alt77=3;
					int LA77_0 = input.LA(1);
					if ( (LA77_0==ASC) ) {
						alt77=1;
					}
					else if ( (LA77_0==DESC) ) {
						alt77=2;
					}
					switch (alt77) {
						case 1 :
							// PhoenixSQL.g:667:186: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def4149); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:667:196: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def4153); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:667:211: (rr= ROW_TIMESTAMP )?
					int alt78=2;
					int LA78_0 = input.LA(1);
					if ( (LA78_0==ROW_TIMESTAMP) ) {
						alt78=1;
					}
					switch (alt78) {
						case 1 :
							// PhoenixSQL.g:667:211: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def4159); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null, 
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:677:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:679:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:679:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4202);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:679:43: ( COMMA v= dyn_column_def )*
			loop80:
			while (true) {
				int alt80=2;
				int LA80_0 = input.LA(1);
				if ( (LA80_0==COMMA) ) {
					alt80=1;
				}

				switch (alt80) {
				case 1 :
					// PhoenixSQL.g:679:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs4208); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4214);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop80;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:682:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:683:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:683:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def4240);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def4244);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:683:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==LPAREN) ) {
				alt82=1;
			}
			switch (alt82) {
				case 1 :
					// PhoenixSQL.g:683:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def4247); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4251); if (state.failed) return ret;
					// PhoenixSQL.g:683:54: ( COMMA s= NUMBER )?
					int alt81=2;
					int LA81_0 = input.LA(1);
					if ( (LA81_0==COMMA) ) {
						alt81=1;
					}
					switch (alt81) {
						case 1 :
							// PhoenixSQL.g:683:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def4254); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4258); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def4262); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:683:83: (ar= ARRAY )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==ARRAY) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// PhoenixSQL.g:683:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def4268); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:683:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==LSQUARE) ) {
				alt85=1;
			}
			switch (alt85) {
				case 1 :
					// PhoenixSQL.g:683:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def4274); if (state.failed) return ret;
					// PhoenixSQL.g:683:104: (a= NUMBER )?
					int alt84=2;
					int LA84_0 = input.LA(1);
					if ( (LA84_0==NUMBER) ) {
						alt84=1;
					}
					switch (alt84) {
						case 1 :
							// PhoenixSQL.g:683:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4279); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def4283); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:692:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:693:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:693:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def4320);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:693:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt91=2;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==NAME) ) {
				alt91=1;
			}
			switch (alt91) {
				case 1 :
					// PhoenixSQL.g:693:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def4325);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:693:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt87=2;
					int LA87_0 = input.LA(1);
					if ( (LA87_0==LPAREN) ) {
						alt87=1;
					}
					switch (alt87) {
						case 1 :
							// PhoenixSQL.g:693:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def4328); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4332); if (state.failed) return ret;
							// PhoenixSQL.g:693:55: ( COMMA s= NUMBER )?
							int alt86=2;
							int LA86_0 = input.LA(1);
							if ( (LA86_0==COMMA) ) {
								alt86=1;
							}
							switch (alt86) {
								case 1 :
									// PhoenixSQL.g:693:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def4335); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4339); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def4343); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:693:84: (ar= ARRAY )?
					int alt88=2;
					int LA88_0 = input.LA(1);
					if ( (LA88_0==ARRAY) ) {
						alt88=1;
					}
					switch (alt88) {
						case 1 :
							// PhoenixSQL.g:693:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def4349); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:693:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt90=2;
					int LA90_0 = input.LA(1);
					if ( (LA90_0==LSQUARE) ) {
						alt90=1;
					}
					switch (alt90) {
						case 1 :
							// PhoenixSQL.g:693:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def4355); if (state.failed) return ret;
							// PhoenixSQL.g:693:105: (a= NUMBER )?
							int alt89=2;
							int LA89_0 = input.LA(1);
							if ( (LA89_0==NUMBER) ) {
								alt89=1;
							}
							switch (alt89) {
								case 1 :
									// PhoenixSQL.g:693:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4360); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def4364); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:702:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:703:5: (s= select_node )
			// PhoenixSQL.g:703:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression4404);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:706:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:708:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:708:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select4437); if (state.failed) return ret;
			// PhoenixSQL.g:708:16: (h= hintClause )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==ML_HINT) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// PhoenixSQL.g:708:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select4442);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:709:9: (d= DISTINCT | ALL )?
			int alt93=3;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==DISTINCT) ) {
				alt93=1;
			}
			else if ( (LA93_0==ALL) ) {
				alt93=2;
			}
			switch (alt93) {
				case 1 :
					// PhoenixSQL.g:709:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select4458); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:709:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select4462); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select4468);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:710:9: ( FROM from= parseFrom )?
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==FROM) ) {
				alt94=1;
			}
			switch (alt94) {
				case 1 :
					// PhoenixSQL.g:710:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select4479); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select4483);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:711:9: ( WHERE where= expression )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==WHERE) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// PhoenixSQL.g:711:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select4496); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4500);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:712:9: ( GROUP BY group= group_by )?
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==GROUP) ) {
				alt96=1;
			}
			switch (alt96) {
				case 1 :
					// PhoenixSQL.g:712:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select4513); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select4515); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select4519);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:713:9: ( HAVING having= expression )?
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==HAVING) ) {
				alt97=1;
			}
			switch (alt97) {
				case 1 :
					// PhoenixSQL.g:713:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select4532); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4536);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:718:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:720:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:720:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects4580);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:720:39: ( UNION ALL s= single_select )*
			loop98:
			while (true) {
				int alt98=2;
				int LA98_0 = input.LA(1);
				if ( (LA98_0==UNION) ) {
					alt98=1;
				}

				switch (alt98) {
				case 1 :
					// PhoenixSQL.g:720:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects4585); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects4587); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects4591);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop98;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:724:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:726:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:726:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node4629);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:727:9: ( ORDER BY order= order_by )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==ORDER) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// PhoenixSQL.g:727:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node4640); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node4642); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node4646);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:728:9: ( LIMIT l= limit )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==LIMIT) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:728:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node4659); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node4663);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:729:9: ( OFFSET o= offset ( ROW | ROWS )? )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==OFFSET) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// PhoenixSQL.g:729:10: OFFSET o= offset ( ROW | ROWS )?
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node4676); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node4680);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:729:26: ( ROW | ROWS )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( ((LA101_0 >= ROW && LA101_0 <= ROWS)) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:730:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==FETCH) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// PhoenixSQL.g:730:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node4702); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:730:31: (l= limit )?
					int alt103=2;
					int LA103_0 = input.LA(1);
					if ( (LA103_0==BIND_NAME||LA103_0==NUMBER||LA103_0==QUESTION) ) {
						alt103=1;
					}
					switch (alt103) {
						case 1 :
							// PhoenixSQL.g:730:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node4715);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node4727); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:736:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:737:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) )
			// PhoenixSQL.g:737:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node4766); if (state.failed) return ret;
			// PhoenixSQL.g:737:16: (hint= hintClause )?
			int alt105=2;
			int LA105_0 = input.LA(1);
			if ( (LA105_0==ML_HINT) ) {
				alt105=1;
			}
			switch (alt105) {
				case 1 :
					// PhoenixSQL.g:737:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node4771);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node4775); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node4779);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:738:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==LPAREN) ) {
				alt106=1;
			}
			switch (alt106) {
				case 1 :
					// PhoenixSQL.g:738:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node4790); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node4794);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node4796); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:739:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==VALUES) ) {
				alt109=1;
			}
			else if ( (LA109_0==SELECT) ) {
				alt109=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 109, 0, input);
				throw nvae;
			}

			switch (alt109) {
				case 1 :
					// PhoenixSQL.g:739:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:739:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:739:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node4810); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node4812); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node4816);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node4818); if (state.failed) return ret;
					// PhoenixSQL.g:739:58: ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					int alt108=2;
					int LA108_0 = input.LA(1);
					if ( (LA108_0==ON) ) {
						alt108=1;
					}
					switch (alt108) {
						case 1 :
							// PhoenixSQL.g:739:60: ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node4822); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node4824); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node4826); if (state.failed) return ret;
							// PhoenixSQL.g:739:77: (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							int alt107=2;
							int LA107_0 = input.LA(1);
							if ( (LA107_0==IGNORE) ) {
								alt107=1;
							}
							else if ( (LA107_0==UPDATE) ) {
								alt107=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 107, 0, input);
								throw nvae;
							}

							switch (alt107) {
								case 1 :
									// PhoenixSQL.g:739:79: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node4832); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:739:91: ( UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:739:91: ( UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:739:93: UPDATE pairs= update_column_pairs
									{
									match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node4838); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node4842);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:739:137: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node4857);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:748:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:750:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:750:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs4898);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:751:8: ( COMMA p= update_column_pair )*
			loop110:
			while (true) {
				int alt110=2;
				int LA110_0 = input.LA(1);
				if ( (LA110_0==COMMA) ) {
					alt110=1;
				}

				switch (alt110) {
				case 1 :
					// PhoenixSQL.g:751:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs4910); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs4914);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop110;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:754:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:755:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:755:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair4939);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair4941); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair4945);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:759:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:761:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:761:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4974);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:762:8: ( COMMA d= dyn_column_name_or_def )*
			loop111:
			while (true) {
				int alt111=2;
				int LA111_0 = input.LA(1);
				if ( (LA111_0==COMMA) ) {
					alt111=1;
				}

				switch (alt111) {
				case 1 :
					// PhoenixSQL.g:762:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs4987); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4991);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop111;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:767:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:768:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:768:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node5019); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node5023);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node5025); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node5027); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node5031);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:772:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:773:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:773:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node5065); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node5069);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:776:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:777:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:777:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node5096); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node5100);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:780:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:781:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:781:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node5126); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node5128); if (state.failed) return ret;
			// PhoenixSQL.g:781:21: (a= NUMBER )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==NUMBER) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// PhoenixSQL.g:781:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node5133); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:781:33: ( ROW | ROWS )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( ((LA113_0 >= ROW && LA113_0 <= ROWS)) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node5144); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node5148);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:785:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:786:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? )
			// PhoenixSQL.g:786:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node5174); if (state.failed) return ret;
			// PhoenixSQL.g:786:16: (hint= hintClause )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==ML_HINT) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// PhoenixSQL.g:786:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node5179);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node5183); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node5187);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:787:9: ( WHERE v= expression )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==WHERE) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// PhoenixSQL.g:787:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node5198); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node5202);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:788:9: ( ORDER BY order= order_by )?
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==ORDER) ) {
				alt116=1;
			}
			switch (alt116) {
				case 1 :
					// PhoenixSQL.g:788:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node5215); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node5217); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node5221);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:789:9: ( LIMIT l= limit )?
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==LIMIT) ) {
				alt117=1;
			}
			switch (alt117) {
				case 1 :
					// PhoenixSQL.g:789:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node5234); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node5238);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:793:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:794:5: (b= bind_expression |l= int_or_long_literal )
			int alt118=2;
			int LA118_0 = input.LA(1);
			if ( (LA118_0==BIND_NAME||LA118_0==QUESTION) ) {
				alt118=1;
			}
			else if ( (LA118_0==NUMBER) ) {
				alt118=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}

			switch (alt118) {
				case 1 :
					// PhoenixSQL.g:794:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit5273);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:795:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit5285);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:798:1: offset returns [OffsetNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:799:2: (b= bind_expression |l= int_or_long_literal )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==BIND_NAME||LA119_0==QUESTION) ) {
				alt119=1;
			}
			else if ( (LA119_0==NUMBER) ) {
				alt119=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// PhoenixSQL.g:799:4: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_offset5311);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.offset(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:800:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset5323);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.offset(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:803:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:804:5: (l= literal )
			// PhoenixSQL.g:804:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate5348);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "tableSampleNode"
	// PhoenixSQL.g:807:1: tableSampleNode returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode tableSampleNode() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:808:5: (l= literal )
			// PhoenixSQL.g:808:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_tableSampleNode5373);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "tableSampleNode"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:811:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:812:5: (c= ML_HINT )
			// PhoenixSQL.g:812:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause5399); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:816:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:818:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==ARRAY||LA121_0==BIND_NAME||(LA121_0 >= CASE && LA121_0 <= CAST)||LA121_0==CURRENT||LA121_0==DECIMAL||LA121_0==DOUBLE||LA121_0==EXISTS||LA121_0==FALSE||LA121_0==LPAREN||LA121_0==MINUS||(LA121_0 >= NAME && LA121_0 <= NEXT)||(LA121_0 >= NOT && LA121_0 <= NULL)||LA121_0==NUMBER||LA121_0==QUESTION||LA121_0==STRING_LITERAL||LA121_0==TRUE) ) {
				alt121=1;
			}
			else if ( (LA121_0==ASTERISK) ) {
				alt121=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}

			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:818:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list5431);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:818:36: ( COMMA n= selectable )*
					loop120:
					while (true) {
						int alt120=2;
						int LA120_0 = input.LA(1);
						if ( (LA120_0==COMMA) ) {
							alt120=1;
						}

						switch (alt120) {
						case 1 :
							// PhoenixSQL.g:818:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list5436); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list5440);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop120;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:819:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list5452); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:823:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:824:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt123=3;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==ARRAY||LA123_0==BIND_NAME||(LA123_0 >= CASE && LA123_0 <= CAST)||LA123_0==CURRENT||LA123_0==DECIMAL||LA123_0==DOUBLE||LA123_0==EXISTS||LA123_0==FALSE||LA123_0==LPAREN||LA123_0==MINUS||LA123_0==NEXT||(LA123_0 >= NOT && LA123_0 <= NULL)||LA123_0==NUMBER||LA123_0==QUESTION||LA123_0==STRING_LITERAL||LA123_0==TRUE) ) {
				alt123=1;
			}
			else if ( (LA123_0==NAME) ) {
				int LA123_2 = input.LA(2);
				if ( (LA123_2==EOF||LA123_2==AND||LA123_2==AS||LA123_2==ASTERISK||LA123_2==BETWEEN||LA123_2==COMMA||LA123_2==CONCAT||LA123_2==DIVIDE||LA123_2==EQ||LA123_2==FETCH||LA123_2==FROM||(LA123_2 >= GROUP && LA123_2 <= HAVING)||LA123_2==ILIKE||LA123_2==IN||LA123_2==IS||(LA123_2 >= LIKE && LA123_2 <= LIMIT)||(LA123_2 >= LPAREN && LA123_2 <= LT)||LA123_2==MINUS||LA123_2==NAME||(LA123_2 >= NOEQ1 && LA123_2 <= NOT)||LA123_2==OFFSET||(LA123_2 >= OR && LA123_2 <= ORDER)||(LA123_2 >= PERCENT && LA123_2 <= PLUS)||LA123_2==RPAREN||LA123_2==SEMICOLON||LA123_2==STRING_LITERAL||LA123_2==UNION||LA123_2==WHERE) ) {
					alt123=1;
				}
				else if ( (LA123_2==DOT) ) {
					int LA123_3 = input.LA(3);
					if ( (LA123_3==ASTERISK) ) {
						alt123=2;
					}
					else if ( (LA123_3==NAME) ) {
						int LA123_5 = input.LA(4);
						if ( (LA123_5==EOF||LA123_5==AND||LA123_5==AS||LA123_5==ASTERISK||LA123_5==BETWEEN||LA123_5==COMMA||LA123_5==CONCAT||LA123_5==DIVIDE||LA123_5==EQ||LA123_5==FETCH||LA123_5==FROM||(LA123_5 >= GROUP && LA123_5 <= HAVING)||LA123_5==ILIKE||LA123_5==IN||LA123_5==IS||(LA123_5 >= LIKE && LA123_5 <= LIMIT)||(LA123_5 >= LSQUARE && LA123_5 <= LT)||LA123_5==MINUS||LA123_5==NAME||(LA123_5 >= NOEQ1 && LA123_5 <= NOT)||LA123_5==OFFSET||(LA123_5 >= OR && LA123_5 <= ORDER)||(LA123_5 >= PERCENT && LA123_5 <= PLUS)||LA123_5==RPAREN||LA123_5==SEMICOLON||LA123_5==UNION||LA123_5==WHERE) ) {
							alt123=1;
						}
						else if ( (LA123_5==DOT) ) {
							int LA123_6 = input.LA(5);
							if ( (LA123_6==ASTERISK) ) {
								alt123=3;
							}
							else if ( (LA123_6==NAME) ) {
								alt123=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 123, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 123, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 123, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 123, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 123, 0, input);
				throw nvae;
			}

			switch (alt123) {
				case 1 :
					// PhoenixSQL.g:824:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable5481);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:824:26: (a= parseAlias )?
					int alt122=2;
					int LA122_0 = input.LA(1);
					if ( (LA122_0==AS||LA122_0==NAME) ) {
						alt122=1;
					}
					switch (alt122) {
						case 1 :
							// PhoenixSQL.g:824:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable5486);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:825:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5501);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5503); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5505); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:826:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5520);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5522); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable5526);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5528); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5530); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:831:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:833:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:833:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by5563);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:834:9: ( COMMA expr= expression )*
			loop124:
			while (true) {
				int alt124=2;
				int LA124_0 = input.LA(1);
				if ( (LA124_0==COMMA) ) {
					alt124=1;
				}

				switch (alt124) {
				case 1 :
					// PhoenixSQL.g:834:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by5576); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by5582);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop124;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:838:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:840:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:840:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by5616);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:841:9: ( COMMA field= parseOrderByField )*
			loop125:
			while (true) {
				int alt125=2;
				int LA125_0 = input.LA(1);
				if ( (LA125_0==COMMA) ) {
					alt125=1;
				}

				switch (alt125) {
				case 1 :
					// PhoenixSQL.g:841:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by5629); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by5635);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop125;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:845:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:847:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:847:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:847:9: (expr= expression )
			// PhoenixSQL.g:847:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField5672);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:848:9: ( ASC | DESC )?
			int alt126=3;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==ASC) ) {
				alt126=1;
			}
			else if ( (LA126_0==DESC) ) {
				alt126=2;
			}
			switch (alt126) {
				case 1 :
					// PhoenixSQL.g:848:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField5684); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:848:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField5690); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:849:9: ( NULLS ( FIRST | LAST ) )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==NULLS) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// PhoenixSQL.g:849:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField5705); if (state.failed) return ret;
					// PhoenixSQL.g:849:16: ( FIRST | LAST )
					int alt127=2;
					int LA127_0 = input.LA(1);
					if ( (LA127_0==FIRST) ) {
						alt127=1;
					}
					else if ( (LA127_0==LAST) ) {
						alt127=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 127, 0, input);
						throw nvae;
					}

					switch (alt127) {
						case 1 :
							// PhoenixSQL.g:849:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField5708); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:849:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField5714); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:853:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:854:5: (t= table_list )
			// PhoenixSQL.g:854:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom5754);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:857:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:858:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:858:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list5785);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:858:33: ( COMMA s= table_ref )*
			loop129:
			while (true) {
				int alt129=2;
				int LA129_0 = input.LA(1);
				if ( (LA129_0==COMMA) ) {
					alt129=1;
				}

				switch (alt129) {
				case 1 :
					// PhoenixSQL.g:858:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list5790); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list5794);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop129;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:861:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:862:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:862:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref5818);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:862:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop130:
			while (true) {
				int alt130=2;
				int LA130_0 = input.LA(1);
				if ( (LA130_0==FULL||LA130_0==INNER||LA130_0==JOIN||LA130_0==LEFT||LA130_0==RIGHT) ) {
					alt130=1;
				}

				switch (alt130) {
				case 1 :
					// PhoenixSQL.g:862:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref5825);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref5827); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref5831);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref5833); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref5837);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop130;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:865:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		LiteralParseNode tableSample =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:866:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt139=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA139_1 = input.LA(2);
				if ( (LA139_1==BIND_NAME||LA139_1==LPAREN||LA139_1==NAME||LA139_1==QUESTION) ) {
					alt139=1;
				}
				else if ( (LA139_1==SELECT) ) {
					alt139=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt139=2;
				}
				break;
			case NAME:
				{
				alt139=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// PhoenixSQL.g:866:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5861); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor5865);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5867); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:867:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor5881);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:867:21: ( ( AS )? alias= identifier )?
					int alt132=2;
					int LA132_0 = input.LA(1);
					if ( (LA132_0==AS||LA132_0==NAME) ) {
						alt132=1;
					}
					switch (alt132) {
						case 1 :
							// PhoenixSQL.g:867:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:867:22: ( AS )?
							int alt131=2;
							int LA131_0 = input.LA(1);
							if ( (LA131_0==AS) ) {
								alt131=1;
							}
							switch (alt131) {
								case 1 :
									// PhoenixSQL.g:867:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5885); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5891);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:868:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor5908);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:868:27: ( ( AS )? alias= identifier )?
					int alt134=2;
					int LA134_0 = input.LA(1);
					if ( (LA134_0==AS||LA134_0==NAME) ) {
						alt134=1;
					}
					switch (alt134) {
						case 1 :
							// PhoenixSQL.g:868:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:868:28: ( AS )?
							int alt133=2;
							int LA133_0 = input.LA(1);
							if ( (LA133_0==AS) ) {
								alt133=1;
							}
							switch (alt133) {
								case 1 :
									// PhoenixSQL.g:868:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5912); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5918);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:868:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt135=2;
					int LA135_0 = input.LA(1);
					if ( (LA135_0==LPAREN) ) {
						alt135=1;
					}
					switch (alt135) {
						case 1 :
							// PhoenixSQL.g:868:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5923); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor5927);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5929); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:868:92: ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					int alt136=2;
					int LA136_0 = input.LA(1);
					if ( (LA136_0==TABLESAMPLE) ) {
						alt136=1;
					}
					switch (alt136) {
						case 1 :
							// PhoenixSQL.g:868:93: TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN
							{
							match(input,TABLESAMPLE,FOLLOW_TABLESAMPLE_in_table_factor5934); if (state.failed) return ret;
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5936); if (state.failed) return ret;
							pushFollow(FOLLOW_tableSampleNode_in_table_factor5940);
							tableSample=tableSampleNode();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5942); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs, tableSample);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:869:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5956); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor5960);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5962); if (state.failed) return ret;
					// PhoenixSQL.g:869:37: ( ( AS )? alias= identifier )?
					int alt138=2;
					int LA138_0 = input.LA(1);
					if ( (LA138_0==AS||LA138_0==NAME) ) {
						alt138=1;
					}
					switch (alt138) {
						case 1 :
							// PhoenixSQL.g:869:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:869:38: ( AS )?
							int alt137=2;
							int LA137_0 = input.LA(1);
							if ( (LA137_0==AS) ) {
								alt137=1;
							}
							switch (alt137) {
								case 1 :
									// PhoenixSQL.g:869:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5966); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5972);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:872:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:873:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt144=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt144=1;
				}
				break;
			case LEFT:
				{
				alt144=2;
				}
				break;
			case RIGHT:
				{
				alt144=3;
				}
				break;
			case FULL:
				{
				alt144=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}
			switch (alt144) {
				case 1 :
					// PhoenixSQL.g:873:9: ( INNER )?
					{
					// PhoenixSQL.g:873:9: ( INNER )?
					int alt140=2;
					int LA140_0 = input.LA(1);
					if ( (LA140_0==INNER) ) {
						alt140=1;
					}
					switch (alt140) {
						case 1 :
							// PhoenixSQL.g:873:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type5999); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:874:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type6014); if (state.failed) return ret;
					// PhoenixSQL.g:874:14: ( OUTER )?
					int alt141=2;
					int LA141_0 = input.LA(1);
					if ( (LA141_0==OUTER) ) {
						alt141=1;
					}
					switch (alt141) {
						case 1 :
							// PhoenixSQL.g:874:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6016); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:875:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type6031); if (state.failed) return ret;
					// PhoenixSQL.g:875:15: ( OUTER )?
					int alt142=2;
					int LA142_0 = input.LA(1);
					if ( (LA142_0==OUTER) ) {
						alt142=1;
					}
					switch (alt142) {
						case 1 :
							// PhoenixSQL.g:875:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6033); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:876:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type6047); if (state.failed) return ret;
					// PhoenixSQL.g:876:15: ( OUTER )?
					int alt143=2;
					int LA143_0 = input.LA(1);
					if ( (LA143_0==OUTER) ) {
						alt143=1;
					}
					switch (alt143) {
						case 1 :
							// PhoenixSQL.g:876:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type6050); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:879:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:880:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:880:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:880:9: ( AS )?
			int alt145=2;
			int LA145_0 = input.LA(1);
			if ( (LA145_0==AS) ) {
				alt145=1;
			}
			switch (alt145) {
				case 1 :
					// PhoenixSQL.g:880:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias6081); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias6086);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:884:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:885:5: (e= or_expression )
			// PhoenixSQL.g:885:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression6114);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:889:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:891:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:891:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression6146);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:891:38: ( OR i= and_expression )*
			loop146:
			while (true) {
				int alt146=2;
				int LA146_0 = input.LA(1);
				if ( (LA146_0==OR) ) {
					alt146=1;
				}

				switch (alt146) {
				case 1 :
					// PhoenixSQL.g:891:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression6151); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression6155);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop146;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:895:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:897:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:897:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression6191);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:897:38: ( AND i= not_expression )*
			loop147:
			while (true) {
				int alt147=2;
				int LA147_0 = input.LA(1);
				if ( (LA147_0==AND) ) {
					alt147=1;
				}

				switch (alt147) {
				case 1 :
					// PhoenixSQL.g:897:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression6196); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression6200);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop147;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:901:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:902:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt150=2;
			int LA150_0 = input.LA(1);
			if ( (LA150_0==NOT) ) {
				int LA150_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt150=1;
				}
				else if ( (true) ) {
					alt150=2;
				}

			}
			else if ( (LA150_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==NULL) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==NAME) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==CASE) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==LPAREN) ) {
				int LA150_15 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt150=1;
				}
				else if ( (true) ) {
					alt150=2;
				}

			}
			else if ( (LA150_0==CAST) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}
			else if ( (LA150_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt150=1;
			}

			switch (alt150) {
				case 1 :
					// PhoenixSQL.g:902:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:902:40: (n= NOT )?
					int alt148=2;
					int LA148_0 = input.LA(1);
					if ( (LA148_0==NOT) ) {
						alt148=1;
					}
					switch (alt148) {
						case 1 :
							// PhoenixSQL.g:902:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6242); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression6247);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:903:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:903:10: (n= NOT )?
					int alt149=2;
					int LA149_0 = input.LA(1);
					if ( (LA149_0==NOT) ) {
						alt149=1;
					}
					switch (alt149) {
						case 1 :
							// PhoenixSQL.g:903:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6261); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression6264); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression6268);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression6270); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:906:1: comparison_op returns [CompareOp ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOp comparison_op() throws RecognitionException {
		CompareOp ret = null;


		try {
			// PhoenixSQL.g:907:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt151=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt151=1;
				}
				break;
			case LT:
				{
				int LA151_2 = input.LA(2);
				if ( (LA151_2==EQ) ) {
					alt151=4;
				}
				else if ( (LA151_2==ALL||(LA151_2 >= ANY && LA151_2 <= ARRAY)||LA151_2==BIND_NAME||(LA151_2 >= CASE && LA151_2 <= CAST)||LA151_2==CURRENT||LA151_2==DECIMAL||LA151_2==DOUBLE||LA151_2==FALSE||LA151_2==LPAREN||LA151_2==MINUS||(LA151_2 >= NAME && LA151_2 <= NEXT)||LA151_2==NULL||LA151_2==NUMBER||LA151_2==QUESTION||LA151_2==STRING_LITERAL||LA151_2==TRUE) ) {
					alt151=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 151, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA151_3 = input.LA(2);
				if ( (LA151_3==EQ) ) {
					alt151=5;
				}
				else if ( (LA151_3==ALL||(LA151_3 >= ANY && LA151_3 <= ARRAY)||LA151_3==BIND_NAME||(LA151_3 >= CASE && LA151_3 <= CAST)||LA151_3==CURRENT||LA151_3==DECIMAL||LA151_3==DOUBLE||LA151_3==FALSE||LA151_3==LPAREN||LA151_3==MINUS||(LA151_3 >= NAME && LA151_3 <= NEXT)||LA151_3==NULL||LA151_3==NUMBER||LA151_3==QUESTION||LA151_3==STRING_LITERAL||LA151_3==TRUE) ) {
					alt151=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 151, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt151=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 151, 0, input);
				throw nvae;
			}
			switch (alt151) {
				case 1 :
					// PhoenixSQL.g:907:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op6290); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:908:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6297); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:909:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6304); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:910:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6311); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6313); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:911:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6320); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6322); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:912:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOp.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:915:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOp op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:916:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt160=2;
			int LA160_0 = input.LA(1);
			if ( (LA160_0==ARRAY||LA160_0==BIND_NAME||(LA160_0 >= CASE && LA160_0 <= CAST)||LA160_0==CURRENT||LA160_0==DECIMAL||LA160_0==DOUBLE||LA160_0==FALSE||LA160_0==LPAREN||LA160_0==MINUS||(LA160_0 >= NAME && LA160_0 <= NEXT)||LA160_0==NULL||LA160_0==NUMBER||LA160_0==QUESTION||LA160_0==STRING_LITERAL||LA160_0==TRUE) ) {
				alt160=1;
			}
			else if ( (LA160_0==EXISTS) ) {
				alt160=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 160, 0, input);
				throw nvae;
			}

			switch (alt160) {
				case 1 :
					// PhoenixSQL.g:916:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression6360);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:916:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt159=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt159=1;
						}
						break;
					case IS:
						{
						alt159=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt159=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt159=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 159, 0, input);
						throw nvae;
					}
					switch (alt159) {
						case 1 :
							// PhoenixSQL.g:916:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:916:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:916:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression6366);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:916:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt154=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt154=1;
								}
								break;
							case LPAREN:
								{
								int LA154_2 = input.LA(2);
								if ( (LA154_2==ARRAY||LA154_2==BIND_NAME||(LA154_2 >= CASE && LA154_2 <= CAST)||LA154_2==CURRENT||LA154_2==DECIMAL||LA154_2==DOUBLE||LA154_2==EXISTS||LA154_2==FALSE||LA154_2==LPAREN||LA154_2==MINUS||(LA154_2 >= NAME && LA154_2 <= NEXT)||(LA154_2 >= NOT && LA154_2 <= NULL)||LA154_2==NUMBER||LA154_2==QUESTION||LA154_2==STRING_LITERAL||LA154_2==TRUE) ) {
									alt154=1;
								}
								else if ( (LA154_2==SELECT) ) {
									alt154=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 154, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA154_3 = input.LA(2);
								if ( (LA154_3==LPAREN) ) {
									int LA154_6 = input.LA(3);
									if ( (LA154_6==ARRAY||LA154_6==BIND_NAME||(LA154_6 >= CASE && LA154_6 <= CAST)||LA154_6==CURRENT||LA154_6==DECIMAL||LA154_6==DOUBLE||LA154_6==FALSE||LA154_6==LPAREN||LA154_6==MINUS||(LA154_6 >= NAME && LA154_6 <= NEXT)||LA154_6==NULL||LA154_6==NUMBER||LA154_6==QUESTION||LA154_6==STRING_LITERAL||LA154_6==TRUE) ) {
										alt154=3;
									}
									else if ( (LA154_6==SELECT) ) {
										alt154=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 154, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 154, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA154_4 = input.LA(2);
								if ( (LA154_4==LPAREN) ) {
									int LA154_6 = input.LA(3);
									if ( (LA154_6==ARRAY||LA154_6==BIND_NAME||(LA154_6 >= CASE && LA154_6 <= CAST)||LA154_6==CURRENT||LA154_6==DECIMAL||LA154_6==DOUBLE||LA154_6==FALSE||LA154_6==LPAREN||LA154_6==MINUS||(LA154_6 >= NAME && LA154_6 <= NEXT)||LA154_6==NULL||LA154_6==NUMBER||LA154_6==QUESTION||LA154_6==STRING_LITERAL||LA154_6==TRUE) ) {
										alt154=3;
									}
									else if ( (LA154_6==SELECT) ) {
										alt154=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 154, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 154, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 154, 0, input);
								throw nvae;
							}
							switch (alt154) {
								case 1 :
									// PhoenixSQL.g:916:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression6371);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:916:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:916:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:916:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6376); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6380);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6382); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:916:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:916:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:916:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:916:110: (all= ALL |any= ANY )
									int alt152=2;
									int LA152_0 = input.LA(1);
									if ( (LA152_0==ALL) ) {
										alt152=1;
									}
									else if ( (LA152_0==ANY) ) {
										alt152=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 152, 0, input);
										throw nvae;
									}

									switch (alt152) {
										case 1 :
											// PhoenixSQL.g:916:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6391); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:916:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6397); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6400); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6404);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6406); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:916:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:916:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:916:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:916:168: (all= ALL |any= ANY )
									int alt153=2;
									int LA153_0 = input.LA(1);
									if ( (LA153_0==ALL) ) {
										alt153=1;
									}
									else if ( (LA153_0==ANY) ) {
										alt153=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 153, 0, input);
										throw nvae;
									}

									switch (alt153) {
										case 1 :
											// PhoenixSQL.g:916:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6416); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:916:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6422); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6425); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6429);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6431); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:917:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:917:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:917:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression6461); if (state.failed) return ret;
							// PhoenixSQL.g:917:27: (n= NOT )?
							int alt155=2;
							int LA155_0 = input.LA(1);
							if ( (LA155_0==NOT) ) {
								alt155=1;
							}
							switch (alt155) {
								case 1 :
									// PhoenixSQL.g:917:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6465); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression6468); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:918:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:918:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:918:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:918:25: (n= NOT )?
							int alt156=2;
							int LA156_0 = input.LA(1);
							if ( (LA156_0==NOT) ) {
								alt156=1;
							}
							switch (alt156) {
								case 1 :
									// PhoenixSQL.g:918:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6499); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:918:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt158=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt158=1;
								}
								break;
							case ILIKE:
								{
								alt158=2;
								}
								break;
							case BETWEEN:
								{
								alt158=3;
								}
								break;
							case IN:
								{
								alt158=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 158, 0, input);
								throw nvae;
							}
							switch (alt158) {
								case 1 :
									// PhoenixSQL.g:918:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:918:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:918:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression6504); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6508);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:919:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:919:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:919:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression6546); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6550);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:920:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:920:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:920:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression6588); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6592);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression6594); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6598);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:921:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:921:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:921:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:921:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:921:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression6637); if (state.failed) return ret;
									// PhoenixSQL.g:921:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt157=3;
									int LA157_0 = input.LA(1);
									if ( (LA157_0==BIND_NAME||LA157_0==QUESTION) ) {
										alt157=1;
									}
									else if ( (LA157_0==LPAREN) ) {
										int LA157_2 = input.LA(2);
										if ( (LA157_2==SELECT) ) {
											alt157=2;
										}
										else if ( (LA157_2==ARRAY||LA157_2==BIND_NAME||(LA157_2 >= CASE && LA157_2 <= CAST)||LA157_2==CURRENT||LA157_2==DECIMAL||LA157_2==DOUBLE||LA157_2==EXISTS||LA157_2==FALSE||LA157_2==LPAREN||LA157_2==MINUS||(LA157_2 >= NAME && LA157_2 <= NEXT)||(LA157_2 >= NOT && LA157_2 <= NULL)||LA157_2==NUMBER||LA157_2==QUESTION||LA157_2==STRING_LITERAL||LA157_2==TRUE) ) {
											alt157=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 157, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 157, 0, input);
										throw nvae;
									}

									switch (alt157) {
										case 1 :
											// PhoenixSQL.g:921:38: (r= bind_expression )
											{
											// PhoenixSQL.g:921:38: (r= bind_expression )
											// PhoenixSQL.g:921:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression6643);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:922:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:922:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:922:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6684); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression6688);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6690); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:923:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:923:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:923:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6731); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression6735);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6737); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:926:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:927:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression6837); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6839); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression6843);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6845); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:930:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:931:5: (b= bind_name )
			// PhoenixSQL.g:931:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression6873);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:934:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:935:5: (i= add_expression )
			// PhoenixSQL.g:935:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression6904);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:938:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:940:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:940:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression6935);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:940:43: ( PLUS i= subtract_expression )*
			loop161:
			while (true) {
				int alt161=2;
				int LA161_0 = input.LA(1);
				if ( (LA161_0==PLUS) ) {
					alt161=1;
				}

				switch (alt161) {
				case 1 :
					// PhoenixSQL.g:940:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression6940); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression6944);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop161;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:943:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:945:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:945:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression6979);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:945:41: ( MINUS i= concat_expression )*
			loop162:
			while (true) {
				int alt162=2;
				int LA162_0 = input.LA(1);
				if ( (LA162_0==MINUS) ) {
					alt162=1;
				}

				switch (alt162) {
				case 1 :
					// PhoenixSQL.g:945:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression6984); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression6988);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop162;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:948:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:950:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:950:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7023);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:950:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop163:
			while (true) {
				int alt163=2;
				int LA163_0 = input.LA(1);
				if ( (LA163_0==CONCAT) ) {
					alt163=1;
				}

				switch (alt163) {
				case 1 :
					// PhoenixSQL.g:950:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression7028); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression7032);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop163;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:953:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:955:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:955:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7067);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:956:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop164:
			while (true) {
				int alt164=2;
				int LA164_0 = input.LA(1);
				if ( (LA164_0==ASTERISK||LA164_0==DIVIDE||LA164_0==PERCENT) ) {
					alt164=1;
				}

				switch (alt164) {
				case 1 :
					// PhoenixSQL.g:956:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression7097);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop164;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:967:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:968:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:968:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node7140); if (state.failed) return ret;
			// PhoenixSQL.g:968:10: ( DEFAULT |s= identifier )
			int alt165=2;
			int LA165_0 = input.LA(1);
			if ( (LA165_0==DEFAULT) ) {
				alt165=1;
			}
			else if ( (LA165_0==NAME) ) {
				alt165=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 165, 0, input);
				throw nvae;
			}

			switch (alt165) {
				case 1 :
					// PhoenixSQL.g:968:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node7143); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:968:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node7149);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:972:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:973:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:973:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:973:10: (m= MINUS )?
			int alt166=2;
			int LA166_0 = input.LA(1);
			if ( (LA166_0==MINUS) ) {
				alt166=1;
			}
			switch (alt166) {
				case 1 :
					// PhoenixSQL.g:973:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression7185); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression7190);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:977:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:978:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:978:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression7218);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:978:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt167=2;
			int LA167_0 = input.LA(1);
			if ( (LA167_0==LSQUARE) ) {
				alt167=1;
			}
			switch (alt167) {
				case 1 :
					// PhoenixSQL.g:978:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression7221); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression7225);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression7227); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:981:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:982:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt174=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt174=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt174=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case BETWEEN:
				case CACHE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt174=2;
					}
					break;
				case DOT:
					{
					alt174=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt174=6;
						}
						break;
					case DISTINCT:
						{
						alt174=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt174=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 174, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 174, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt174=3;
				}
				break;
			case CASE:
				{
				alt174=8;
				}
				break;
			case LPAREN:
				{
				alt174=9;
				}
				break;
			case CAST:
				{
				alt174=10;
				}
				break;
			case NEXT:
				{
				int LA174_7 = input.LA(2);
				if ( (LA174_7==VALUE) ) {
					alt174=11;
				}
				else if ( (LA174_7==BIND_NAME||LA174_7==DECIMAL||LA174_7==DOUBLE||LA174_7==FALSE||LA174_7==NAME||LA174_7==NULL||LA174_7==NUMBER||LA174_7==QUESTION||LA174_7==STRING_LITERAL||LA174_7==TRUE) ) {
					alt174=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 174, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt174=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 174, 0, input);
				throw nvae;
			}
			switch (alt174) {
				case 1 :
					// PhoenixSQL.g:982:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term7260);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:983:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term7274);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:984:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7288); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term7290); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7294);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term7296); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:985:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term7310);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term7312); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7316);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:986:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term7330);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7332); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7336);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7338); if (state.failed) return ret;
					// PhoenixSQL.g:986:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt169=2;
					int LA169_0 = input.LA(1);
					if ( (LA169_0==WITHIN) ) {
						alt169=1;
					}
					switch (alt169) {
						case 1 :
							// PhoenixSQL.g:986:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term7343); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term7345); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term7347); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term7349); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term7351); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term7355);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:986:127: (a= ASC | DESC )
							int alt168=2;
							int LA168_0 = input.LA(1);
							if ( (LA168_0==ASC) ) {
								alt168=1;
							}
							else if ( (LA168_0==DESC) ) {
								alt168=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 168, 0, input);
								throw nvae;
							}

							switch (alt168) {
								case 1 :
									// PhoenixSQL.g:986:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term7360); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:986:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term7364); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term7367); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:995:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7392);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7394); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term7398); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7400); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1007:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7424);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7426); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term7430); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7434);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7436); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1016:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term7459);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1017:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term7471); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7475);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7477); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1026:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term7495); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7497); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term7501);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term7503); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7507);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1026:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt171=2;
					int LA171_0 = input.LA(1);
					if ( (LA171_0==LPAREN) ) {
						alt171=1;
					}
					switch (alt171) {
						case 1 :
							// PhoenixSQL.g:1026:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term7510); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7514); if (state.failed) return ret;
							// PhoenixSQL.g:1026:73: ( COMMA scale= NUMBER )?
							int alt170=2;
							int LA170_0 = input.LA(1);
							if ( (LA170_0==COMMA) ) {
								alt170=1;
							}
							switch (alt170) {
								case 1 :
									// PhoenixSQL.g:1026:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term7517); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7521); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term7525); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1026:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt172=3;
					int LA172_0 = input.LA(1);
					if ( (LA172_0==ARRAY) ) {
						alt172=1;
					}
					else if ( (LA172_0==LSQUARE) ) {
						alt172=2;
					}
					switch (alt172) {
						case 1 :
							// PhoenixSQL.g:1026:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7532); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1026:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1026:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1026:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term7537); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term7539); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term7544); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1032:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1032:9: (n= NEXT | CURRENT )
					int alt173=2;
					int LA173_0 = input.LA(1);
					if ( (LA173_0==NEXT) ) {
						alt173=1;
					}
					else if ( (LA173_0==CURRENT) ) {
						alt173=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 173, 0, input);
						throw nvae;
					}

					switch (alt173) {
						case 1 :
							// PhoenixSQL.g:1032:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7567); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1032:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term7571); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term7574); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7576); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7580);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1035:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1035:9: (n= NEXT )
					// PhoenixSQL.g:1035:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7608); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term7613);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term7615); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7617); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7621);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1040:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1042:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1042:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions7666);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1042:39: ( COMMA e= expression )*
			loop175:
			while (true) {
				int alt175=2;
				int LA175_0 = input.LA(1);
				if ( (LA175_0==COMMA) ) {
					alt175=1;
				}

				switch (alt175) {
				case 1 :
					// PhoenixSQL.g:1042:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions7672); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions7678);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop175;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1045:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1047:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1047:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7709);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1047:49: ( COMMA jarPath= jar_path )*
			loop176:
			while (true) {
				int alt176=2;
				int LA176_0 = input.LA(1);
				if ( (LA176_0==COMMA) ) {
					alt176=1;
				}

				switch (alt176) {
				case 1 :
					// PhoenixSQL.g:1047:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths7715); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7721);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop176;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1050:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1052:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1052:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1052:8: (v= expression )?
			int alt177=2;
			int LA177_0 = input.LA(1);
			if ( (LA177_0==ARRAY||LA177_0==BIND_NAME||(LA177_0 >= CASE && LA177_0 <= CAST)||LA177_0==CURRENT||LA177_0==DECIMAL||LA177_0==DOUBLE||LA177_0==EXISTS||LA177_0==FALSE||LA177_0==LPAREN||LA177_0==MINUS||(LA177_0 >= NAME && LA177_0 <= NEXT)||(LA177_0 >= NOT && LA177_0 <= NULL)||LA177_0==NUMBER||LA177_0==QUESTION||LA177_0==STRING_LITERAL||LA177_0==TRUE) ) {
				alt177=1;
			}
			switch (alt177) {
				case 1 :
					// PhoenixSQL.g:1052:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions7754);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1052:42: ( COMMA v= expression )*
			loop178:
			while (true) {
				int alt178=2;
				int LA178_0 = input.LA(1);
				if ( (LA178_0==COMMA) ) {
					alt178=1;
				}

				switch (alt178) {
				case 1 :
					// PhoenixSQL.g:1052:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions7762); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions7768);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop178;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1055:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1057:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1057:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1057:7: (fa= function_argument )?
			int alt179=2;
			int LA179_0 = input.LA(1);
			if ( (LA179_0==NAME) ) {
				alt179=1;
			}
			switch (alt179) {
				case 1 :
					// PhoenixSQL.g:1057:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types7799);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1057:49: ( COMMA fa= function_argument )*
			loop180:
			while (true) {
				int alt180=2;
				int LA180_0 = input.LA(1);
				if ( (LA180_0==COMMA) ) {
					alt180=1;
				}

				switch (alt180) {
				case 1 :
					// PhoenixSQL.g:1057:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types7806); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types7812);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop180;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1060:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1061:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1061:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1061:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1061:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument7837);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1061:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt182=2;
			int LA182_0 = input.LA(1);
			if ( (LA182_0==LPAREN) ) {
				alt182=1;
			}
			switch (alt182) {
				case 1 :
					// PhoenixSQL.g:1061:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument7840); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7844); if (state.failed) return ret;
					// PhoenixSQL.g:1061:38: ( COMMA s= NUMBER )?
					int alt181=2;
					int LA181_0 = input.LA(1);
					if ( (LA181_0==COMMA) ) {
						alt181=1;
					}
					switch (alt181) {
						case 1 :
							// PhoenixSQL.g:1061:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument7847); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7851); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument7855); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1061:67: (ar= ARRAY )?
			int alt183=2;
			int LA183_0 = input.LA(1);
			if ( (LA183_0==ARRAY) ) {
				alt183=1;
			}
			switch (alt183) {
				case 1 :
					// PhoenixSQL.g:1061:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument7861); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1061:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==LSQUARE) ) {
				alt185=1;
			}
			switch (alt185) {
				case 1 :
					// PhoenixSQL.g:1061:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument7867); if (state.failed) return ret;
					// PhoenixSQL.g:1061:88: (a= NUMBER )?
					int alt184=2;
					int LA184_0 = input.LA(1);
					if ( (LA184_0==NUMBER) ) {
						alt184=1;
					}
					switch (alt184) {
						case 1 :
							// PhoenixSQL.g:1061:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7872); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument7876); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1061:110: (c= CONSTANT )?
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==CONSTANT) ) {
				alt186=1;
			}
			switch (alt186) {
				case 1 :
					// PhoenixSQL.g:1061:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument7885); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1061:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt187=2;
			int LA187_0 = input.LA(1);
			if ( (LA187_0==DEFAULTVALUE) ) {
				alt187=1;
			}
			switch (alt187) {
				case 1 :
					// PhoenixSQL.g:1061:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument7890); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7892); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7898);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1061:161: ( MINVALUE EQ minv= expression )?
			int alt188=2;
			int LA188_0 = input.LA(1);
			if ( (LA188_0==MINVALUE) ) {
				alt188=1;
			}
			switch (alt188) {
				case 1 :
					// PhoenixSQL.g:1061:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument7903); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7905); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7911);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1061:195: ( MAXVALUE EQ maxv= expression )?
			int alt189=2;
			int LA189_0 = input.LA(1);
			if ( (LA189_0==MAXVALUE) ) {
				alt189=1;
			}
			switch (alt189) {
				case 1 :
					// PhoenixSQL.g:1061:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument7917); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7919); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7925);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1068:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1070:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1070:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list7955); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list7961);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1070:52: ( COMMA e= value_expression )*
			loop190:
			while (true) {
				int alt190=2;
				int LA190_0 = input.LA(1);
				if ( (LA190_0==COMMA) ) {
					alt190=1;
				}

				switch (alt190) {
				case 1 :
					// PhoenixSQL.g:1070:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list7967); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list7973);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop190;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list7980); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1073:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1074:5: (name= identifier )
			// PhoenixSQL.g:1074:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name8001);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1077:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1078:5: (name= identifier )
			// PhoenixSQL.g:1078:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name8028);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1082:1: table_name returns [TableName ret] : (t= identifier |s= identifier DOT t= identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1083:5: (t= identifier |s= identifier DOT t= identifier )
			int alt191=2;
			int LA191_0 = input.LA(1);
			if ( (LA191_0==NAME) ) {
				int LA191_1 = input.LA(2);
				if ( (LA191_1==DOT) ) {
					int LA191_2 = input.LA(3);
					if ( (LA191_2==NAME) ) {
						int LA191_3 = input.LA(4);
						if ( (LA191_3==EOF||LA191_3==AND||(LA191_3 >= AS && LA191_3 <= ASTERISK)||LA191_3==BETWEEN||LA191_3==CACHE||LA191_3==COMMA||LA191_3==CONCAT||LA191_3==CONSTRAINT||LA191_3==CYCLE||LA191_3==DESC||LA191_3==DIVIDE||(LA191_3 >= ELSE && LA191_3 <= END)||LA191_3==EQ||LA191_3==FETCH||(LA191_3 >= FROM && LA191_3 <= FULL)||(LA191_3 >= GROUP && LA191_3 <= HAVING)||LA191_3==ILIKE||LA191_3==IN||LA191_3==INCREMENT||LA191_3==INNER||LA191_3==IS||LA191_3==JOIN||LA191_3==LEFT||(LA191_3 >= LIKE && LA191_3 <= LIMIT)||(LA191_3 >= LSQUARE && LA191_3 <= MINVALUE)||LA191_3==NAME||(LA191_3 >= NOEQ1 && LA191_3 <= NOT)||LA191_3==NULLS||LA191_3==OFFSET||(LA191_3 >= OR && LA191_3 <= ORDER)||(LA191_3 >= PERCENT && LA191_3 <= PLUS)||LA191_3==PRIMARY||LA191_3==RIGHT||(LA191_3 >= RPAREN && LA191_3 <= RSQUARE)||LA191_3==SEMICOLON||LA191_3==THEN||LA191_3==UNION||(LA191_3 >= WHEN && LA191_3 <= WHERE)) ) {
							alt191=1;
						}
						else if ( (LA191_3==DOT) ) {
							alt191=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 191, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 191, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 191, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 191, 0, input);
				throw nvae;
			}

			switch (alt191) {
				case 1 :
					// PhoenixSQL.g:1083:9: t= identifier
					{
					pushFollow(FOLLOW_identifier_in_table_name8056);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1084:9: s= identifier DOT t= identifier
					{
					pushFollow(FOLLOW_identifier_in_table_name8070);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name8072); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_table_name8076);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1088:1: from_table_name returns [TableName ret] : (t= identifier |s= identifier DOT t= identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1089:5: (t= identifier |s= identifier DOT t= identifier )
			int alt192=2;
			int LA192_0 = input.LA(1);
			if ( (LA192_0==NAME) ) {
				int LA192_1 = input.LA(2);
				if ( (LA192_1==EOF||(LA192_1 >= ACTIVE && LA192_1 <= ALL)||LA192_1==AND||(LA192_1 >= AS && LA192_1 <= ASTERISK)||LA192_1==BETWEEN||(LA192_1 >= CACHE && LA192_1 <= CASCADE)||(LA192_1 >= COLUMNS && LA192_1 <= COMMA)||LA192_1==CONCAT||LA192_1==CONSTRAINT||LA192_1==CYCLE||LA192_1==DESC||LA192_1==DISABLE||LA192_1==DIVIDE||LA192_1==DROP||(LA192_1 >= ELSE && LA192_1 <= END)||LA192_1==EQ||LA192_1==FETCH||(LA192_1 >= FROM && LA192_1 <= FULL)||(LA192_1 >= GROUP && LA192_1 <= HAVING)||LA192_1==ILIKE||LA192_1==IN||(LA192_1 >= INCREMENT && LA192_1 <= INNER)||LA192_1==IS||LA192_1==JOIN||LA192_1==LEFT||(LA192_1 >= LIKE && LA192_1 <= LIMIT)||(LA192_1 >= LPAREN && LA192_1 <= MINVALUE)||(LA192_1 >= MODIFY && LA192_1 <= NAME)||(LA192_1 >= NOEQ1 && LA192_1 <= NOT)||LA192_1==NULLS||(LA192_1 >= OFFSET && LA192_1 <= ON)||(LA192_1 >= OR && LA192_1 <= ORDER)||(LA192_1 >= PERCENT && LA192_1 <= PLUS)||LA192_1==PRIMARY||LA192_1==REBUILD||LA192_1==RIGHT||(LA192_1 >= RPAREN && LA192_1 <= RSQUARE)||(LA192_1 >= SELECT && LA192_1 <= SEMICOLON)||LA192_1==SET||LA192_1==START||LA192_1==TABLESAMPLE||LA192_1==THEN||(LA192_1 >= UNION && LA192_1 <= UNUSABLE)||LA192_1==USABLE||LA192_1==VALUES||(LA192_1 >= WHEN && LA192_1 <= WHERE)) ) {
					alt192=1;
				}
				else if ( (LA192_1==DOT) ) {
					alt192=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 192, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 192, 0, input);
				throw nvae;
			}

			switch (alt192) {
				case 1 :
					// PhoenixSQL.g:1089:9: t= identifier
					{
					pushFollow(FOLLOW_identifier_in_from_table_name8104);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1090:9: s= identifier DOT t= identifier
					{
					pushFollow(FOLLOW_identifier_in_from_table_name8118);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name8120); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_from_table_name8124);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1094:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1095:5: (e= literal |b= bind_name )
			int alt193=2;
			int LA193_0 = input.LA(1);
			if ( (LA193_0==DECIMAL||LA193_0==DOUBLE||LA193_0==FALSE||LA193_0==NAME||LA193_0==NULL||LA193_0==NUMBER||LA193_0==STRING_LITERAL||LA193_0==TRUE) ) {
				alt193=1;
			}
			else if ( (LA193_0==BIND_NAME||LA193_0==QUESTION) ) {
				alt193=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 193, 0, input);
				throw nvae;
			}

			switch (alt193) {
				case 1 :
					// PhoenixSQL.g:1095:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind8156);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1096:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind8170);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1100:1: literal returns [LiteralParseNode ret] : (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		String dt =null;

		try {
			// PhoenixSQL.g:1101:5: (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt194=8;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt194=1;
				}
				break;
			case NUMBER:
				{
				alt194=2;
				}
				break;
			case DECIMAL:
				{
				alt194=3;
				}
				break;
			case DOUBLE:
				{
				alt194=4;
				}
				break;
			case NULL:
				{
				alt194=5;
				}
				break;
			case TRUE:
				{
				alt194=6;
				}
				break;
			case FALSE:
				{
				alt194=7;
				}
				break;
			case NAME:
				{
				alt194=8;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 194, 0, input);
				throw nvae;
			}
			switch (alt194) {
				case 1 :
					// PhoenixSQL.g:1101:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8202); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1104:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal8216); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1107:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal8230); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1110:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal8245); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1113:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal8262); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 6 :
					// PhoenixSQL.g:1114:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal8274); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 7 :
					// PhoenixSQL.g:1115:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal8287); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1116:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal8301);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8305); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1125:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1126:5: (n= NUMBER )
			// PhoenixSQL.g:1126:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal8336); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1132:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1133:5: (n= BIND_NAME | QUESTION )
			int alt195=2;
			int LA195_0 = input.LA(1);
			if ( (LA195_0==BIND_NAME) ) {
				alt195=1;
			}
			else if ( (LA195_0==QUESTION) ) {
				alt195=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 195, 0, input);
				throw nvae;
			}

			switch (alt195) {
				case 1 :
					// PhoenixSQL.g:1133:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name8364); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1134:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name8377); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1138:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1139:5: (c= parseNoReserved )
			// PhoenixSQL.g:1139:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier8406);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1142:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1143:5: (n= NAME )
			// PhoenixSQL.g:1143:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved8433); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1146:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1148:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt200=2;
			int LA200_0 = input.LA(1);
			if ( (LA200_0==CASE) ) {
				int LA200_1 = input.LA(2);
				if ( (LA200_1==ARRAY||LA200_1==BIND_NAME||(LA200_1 >= CASE && LA200_1 <= CAST)||LA200_1==CURRENT||LA200_1==DECIMAL||LA200_1==DOUBLE||LA200_1==EXISTS||LA200_1==FALSE||LA200_1==LPAREN||LA200_1==MINUS||(LA200_1 >= NAME && LA200_1 <= NEXT)||(LA200_1 >= NOT && LA200_1 <= NULL)||LA200_1==NUMBER||LA200_1==QUESTION||LA200_1==STRING_LITERAL||LA200_1==TRUE) ) {
					alt200=1;
				}
				else if ( (LA200_1==WHEN) ) {
					alt200=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 200, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 200, 0, input);
				throw nvae;
			}

			switch (alt200) {
				case 1 :
					// PhoenixSQL.g:1148:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8460); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement8464);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1148:26: ( WHEN e2= expression THEN t= expression )+
					int cnt196=0;
					loop196:
					while (true) {
						int alt196=2;
						int LA196_0 = input.LA(1);
						if ( (LA196_0==WHEN) ) {
							alt196=1;
						}

						switch (alt196) {
						case 1 :
							// PhoenixSQL.g:1148:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8467); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8471);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8473); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8477);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt196 >= 1 ) break loop196;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(196, input);
							throw eee;
						}
						cnt196++;
					}

					// PhoenixSQL.g:1148:106: ( ELSE el= expression )?
					int alt197=2;
					int LA197_0 = input.LA(1);
					if ( (LA197_0==ELSE) ) {
						alt197=1;
					}
					switch (alt197) {
						case 1 :
							// PhoenixSQL.g:1148:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8484); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8488);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8494); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1149:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8504); if (state.failed) return ret;
					// PhoenixSQL.g:1149:12: ( WHEN c= expression THEN t= expression )+
					int cnt198=0;
					loop198:
					while (true) {
						int alt198=2;
						int LA198_0 = input.LA(1);
						if ( (LA198_0==WHEN) ) {
							alt198=1;
						}

						switch (alt198) {
						case 1 :
							// PhoenixSQL.g:1149:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8507); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8511);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8513); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8517);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt198 >= 1 ) break loop198;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(198, input);
							throw eee;
						}
						cnt198++;
					}

					// PhoenixSQL.g:1149:72: ( ELSE el= expression )?
					int alt199=2;
					int LA199_0 = input.LA(1);
					if ( (LA199_0==ELSE) ) {
						alt199=1;
					}
					switch (alt199) {
						case 1 :
							// PhoenixSQL.g:1149:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8524); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8528);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8534); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:902:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:902:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:902:10: ( NOT )?
		int alt201=2;
		int LA201_0 = input.LA(1);
		if ( (LA201_0==NOT) ) {
			alt201=1;
		}
		switch (alt201) {
			case 1 :
				// PhoenixSQL.g:902:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL6231); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6234);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1253 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1257 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1266 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1292 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1296 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1322 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1390 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1402 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1426 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1438 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1450 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1462 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1486 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1510 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1522 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1534 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1546 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1558 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1570 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1582 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1594 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1606 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1616 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1636 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1658 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1670 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1715 = new BitSet(new long[]{0x50401208020000A0L,0x0100000200000002L,0x0000054400008000L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1719 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1745 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L,0x0000000010000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1750 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node1754 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_create_table_node1757 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node1759 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node1763 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node1769 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node1781 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node1785 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node1790 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node1794 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node1808 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node1821 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_table_node1823 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node1827 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node1866 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node1868 = new BitSet(new long[]{0x0000040000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node1871 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node1873 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node1877 = new BitSet(new long[]{0x0000040000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_create_schema_node1882 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node1888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node1923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node1925 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_create_view_node1928 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node1930 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node1934 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node1940 = new BitSet(new long[]{0x0000000000000802L,0x0000100800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node1952 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node1956 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node1961 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node1965 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node1979 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node1981 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node1983 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_create_view_node1995 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node1999 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node2012 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_create_view_node2016 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2034 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2070 = new BitSet(new long[]{0x0000000000000000L,0x0000000400080000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2074 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2077 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2080 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2082 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2086 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2092 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2094 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2098 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2109 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2113 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2115 = new BitSet(new long[]{0x0000000000004002L,0x0000100000020000L,0x0000000001000000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2127 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2130 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2134 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2136 = new BitSet(new long[]{0x0000000000004002L,0x0000100000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2152 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2167 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2180 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2182 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2222 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2224 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node2228 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node2230 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node2234 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node2240 = new BitSet(new long[]{0x0000004000080002L,0x0000014000040000L,0x0000000002000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node2251 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0002000808000004L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node2253 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2258 = new BitSet(new long[]{0x0000004000080002L,0x0000014000040000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node2271 = new BitSet(new long[]{0x0008011000660400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node2273 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2278 = new BitSet(new long[]{0x0000004000080002L,0x0000014000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node2291 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2295 = new BitSet(new long[]{0x0000004000080002L,0x0000004000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node2308 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2312 = new BitSet(new long[]{0x0000004000080002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node2327 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node2341 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node2345 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind2376 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind2388 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node2414 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node2416 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node2420 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node2424 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node2430 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint2459 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint2462 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint2466 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint2468 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint2470 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint2472 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2476 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint2478 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2509 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2515 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2521 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2548 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2553 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2557 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint2599 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2626 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list2632 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2638 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order2665 = new BitSet(new long[]{0x0000200000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order2671 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order2675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties2703 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties2705 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties2709 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties2715 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties2719 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties2721 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties2725 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2769 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name2771 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2775 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value2806 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value2820 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name2851 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name2865 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name2867 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name2871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names2903 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names2909 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names2915 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node2942 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400010000000L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node2947 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node2951 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node2955 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node2959 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node2965 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node2970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node3005 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node3007 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node3010 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node3014 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3020 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3025 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3060 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3062 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3065 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3069 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3075 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3077 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3081 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3111 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3113 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3116 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3120 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3126 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3128 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3132 = new BitSet(new long[]{0x0000800000000010L,0x0000000000000000L,0x0000022000000010L});
	public static final BitSet FOLLOW_set_in_alter_index_node3136 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node3159 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node3193 = new BitSet(new long[]{0x0000000000000000L,0x0050000000000000L});
	public static final BitSet FOLLOW_ON_in_trace_node3201 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_WITH_in_trace_node3206 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node3208 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node3214 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node3225 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node3259 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000080L,0x0000000080000000L});
	public static final BitSet FOLLOW_OR_in_create_function_node3262 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node3266 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x0000000080000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node3273 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node3277 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3281 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node3292 = new BitSet(new long[]{0x0000000020000000L,0x0000100000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node3296 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node3298 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node3308 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3312 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node3314 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3320 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_USING_in_create_function_node3331 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node3333 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3340 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path3377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node3400 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node3402 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node3405 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node3409 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node3415 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node3438 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node3440 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node3446 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node3469 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node3471 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node3494 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node3496 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node3502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node3528 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node3530 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node3533 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node3537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node3576 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400010000000L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node3579 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node3585 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node3590 = new BitSet(new long[]{0x0040000000000020L,0x0000080000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node3624 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node3626 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3629 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3633 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node3639 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node3707 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3710 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node3712 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3716 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node3722 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node3727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node3757 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node3761 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MODIFY_in_alter_table_node3806 = new BitSet(new long[]{0x0000000000000000L,0x0000100000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3809 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node3811 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3815 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_def_in_alter_table_node3821 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node3857 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node3859 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node3863 = new BitSet(new long[]{0x0000000010000042L,0x0000000000080000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node3868 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node3874 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node3880 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node3885 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node3890 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node3914 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node3916 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name3942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties3976 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties3978 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_prop_value_in_properties3982 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_properties3988 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties3992 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties3994 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_prop_value_in_properties3998 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs4033 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs4039 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs4045 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_column_def4071 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def4075 = new BitSet(new long[]{0x0000040000000402L,0x0003001800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_column_def4078 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4082 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_COMMA_in_column_def4085 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4089 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_column_def4093 = new BitSet(new long[]{0x0000040000000402L,0x0003001000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_column_def4099 = new BitSet(new long[]{0x0000040000000002L,0x0003001000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def4105 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4110 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def4114 = new BitSet(new long[]{0x0000040000000002L,0x0003000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_column_def4121 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def4126 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def4131 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_column_def4135 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def4142 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_column_def4144 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_ASC_in_column_def4149 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_DESC_in_column_def4153 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def4159 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4202 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs4208 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4214 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def4240 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def4244 = new BitSet(new long[]{0x0000000000000402L,0x0000001800000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def4247 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4251 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def4254 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4258 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def4262 = new BitSet(new long[]{0x0000000000000402L,0x0000001000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def4268 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def4274 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4279 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def4283 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def4320 = new BitSet(new long[]{0x0000000000000002L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def4325 = new BitSet(new long[]{0x0000000000000402L,0x0000001800000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def4328 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4332 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def4335 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4339 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def4343 = new BitSet(new long[]{0x0000000000000402L,0x0000001000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def4349 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def4355 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4360 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def4364 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression4404 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select4437 = new BitSet(new long[]{0x2009011000622440L,0x000B348800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_hintClause_in_single_select4442 = new BitSet(new long[]{0x2009011000622440L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select4458 = new BitSet(new long[]{0x2008011000622400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_ALL_in_single_select4462 = new BitSet(new long[]{0x2008011000622400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_select_list_in_single_select4468 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000520L,0x0001000000000000L});
	public static final BitSet FOLLOW_FROM_in_single_select4479 = new BitSet(new long[]{0x0000000000020000L,0x0000100800000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_parseFrom_in_single_select4483 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000500L,0x0001000000000000L});
	public static final BitSet FOLLOW_WHERE_in_single_select4496 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_single_select4500 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000500L});
	public static final BitSet FOLLOW_GROUP_in_single_select4513 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_single_select4515 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_group_by_in_single_select4519 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000400L});
	public static final BitSet FOLLOW_HAVING_in_single_select4532 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_single_select4536 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4580 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects4585 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects4587 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4591 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node4629 = new BitSet(new long[]{0x0000000000000002L,0x0420000100000002L});
	public static final BitSet FOLLOW_ORDER_in_select_node4640 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_select_node4642 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_order_by_in_select_node4646 = new BitSet(new long[]{0x0000000000000002L,0x0020000100000002L});
	public static final BitSet FOLLOW_LIMIT_in_select_node4659 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_limit_in_select_node4663 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_select_node4676 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_offset_in_select_node4680 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L,0x0000000000000300L});
	public static final BitSet FOLLOW_FETCH_in_select_node4702 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000008L});
	public static final BitSet FOLLOW_set_in_select_node4704 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000304L});
	public static final BitSet FOLLOW_limit_in_select_node4715 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000300L});
	public static final BitSet FOLLOW_set_in_select_node4719 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_ONLY_in_select_node4727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node4766 = new BitSet(new long[]{0x0000000000000000L,0x0000040000200000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node4771 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node4775 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node4779 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L,0x0000200000008000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node4790 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node4794 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node4796 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000008000L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node4810 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node4812 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node4816 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node4818 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_upsert_node4822 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node4824 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node4826 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000004000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node4832 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node4838 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node4842 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_upsert_node4857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs4898 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs4910 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs4914 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair4939 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair4941 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_update_column_pair4945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4974 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs4987 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4991 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node5019 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node5023 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node5025 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node5027 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node5031 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node5065 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node5069 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node5096 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node5100 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node5126 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node5128 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000020L,0x0000000000000300L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node5133 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L,0x0000000000000300L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node5144 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node5148 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node5174 = new BitSet(new long[]{0x0000000000000000L,0x0000040000000020L});
	public static final BitSet FOLLOW_hintClause_in_delete_node5179 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_delete_node5183 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node5187 = new BitSet(new long[]{0x0000000000000002L,0x0400000100000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_WHERE_in_delete_node5198 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_delete_node5202 = new BitSet(new long[]{0x0000000000000002L,0x0400000100000000L});
	public static final BitSet FOLLOW_ORDER_in_delete_node5215 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_delete_node5217 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_order_by_in_delete_node5221 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node5234 = new BitSet(new long[]{0x0000000000020000L,0x0008000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_limit_in_delete_node5238 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit5273 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit5285 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset5311 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset5323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate5348 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_tableSampleNode5373 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause5399 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5431 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list5436 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_selectable_in_select_list5440 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list5452 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable5481 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable5486 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5501 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5503 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5505 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5520 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5522 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable5526 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5528 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by5563 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by5576 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_group_by5582 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5616 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by5629 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5635 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField5672 = new BitSet(new long[]{0x0000200000001002L,0x0004000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField5684 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField5690 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField5705 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000008L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField5708 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField5714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom5754 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list5785 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list5790 = new BitSet(new long[]{0x0000000000020000L,0x0000100800000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_ref_in_table_list5794 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref5818 = new BitSet(new long[]{0x0000000000000002L,0x0000000022100040L,0x0000000000000080L});
	public static final BitSet FOLLOW_join_type_in_table_ref5825 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref5827 = new BitSet(new long[]{0x0000000000020000L,0x0000100800000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_factor_in_table_ref5831 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ON_in_table_ref5833 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_table_ref5837 = new BitSet(new long[]{0x0000000000000002L,0x0000000022100040L,0x0000000000000080L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5861 = new BitSet(new long[]{0x0000000000020000L,0x0000100800000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_table_list_in_table_factor5865 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5867 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor5881 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5885 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5891 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor5908 = new BitSet(new long[]{0x0000000000000802L,0x0000100800000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5912 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5918 = new BitSet(new long[]{0x0000000000000002L,0x0000000800000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5923 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor5927 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5929 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_TABLESAMPLE_in_table_factor5934 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5936 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_tableSampleNode_in_table_factor5940 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5956 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_select_node_in_table_factor5960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5962 = new BitSet(new long[]{0x0000000000000802L,0x0000100000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5966 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5972 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type5999 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type6014 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6016 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type6031 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6033 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type6047 = new BitSet(new long[]{0x0000000000000002L,0x1000000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type6050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias6081 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias6086 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression6114 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6146 = new BitSet(new long[]{0x0000000000000002L,0x0200000000000000L});
	public static final BitSet FOLLOW_OR_in_or_expression6151 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_and_expression_in_or_expression6155 = new BitSet(new long[]{0x0000000000000002L,0x0200000000000000L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6191 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression6196 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6200 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression6242 = new BitSet(new long[]{0x2008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression6247 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression6261 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression6264 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_not_expression6268 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression6270 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6290 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6297 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6304 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6311 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6313 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6320 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6322 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op6329 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6360 = new BitSet(new long[]{0x0800000000010002L,0x0001C02080414200L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression6366 = new BitSet(new long[]{0x0008011000620640L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6371 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6376 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6382 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6391 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6397 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6400 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6404 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6416 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6422 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6425 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6429 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6431 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression6461 = new BitSet(new long[]{0x0000000000000000L,0x0003000000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6465 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression6468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6499 = new BitSet(new long[]{0x0000000000010000L,0x0000000080014000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression6504 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6508 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression6546 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression6588 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6592 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression6594 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression6637 = new BitSet(new long[]{0x0000000000020000L,0x0000000800000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression6643 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6684 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6688 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6690 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6731 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression6735 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6737 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression6837 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6839 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6843 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression6873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression6904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression6935 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_PLUS_in_add_expression6940 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression6944 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression6979 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression6984 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression6988 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7023 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression7028 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression7032 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7067 = new BitSet(new long[]{0x0002000000002002L,0x4000000000000000L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression7083 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression7097 = new BitSet(new long[]{0x0002000000002002L,0x4000000000000000L});
	public static final BitSet FOLLOW_USE_in_use_schema_node7140 = new BitSet(new long[]{0x0000040000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node7143 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node7149 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression7185 = new BitSet(new long[]{0x0008011000620400L,0x000A300800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression7190 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression7218 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression7221 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_array_expression7225 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression7227 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7260 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7274 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term7288 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7290 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7294 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7296 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term7310 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_term7312 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_term7316 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7330 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7332 = new BitSet(new long[]{0x2008011020620400L,0x000B308800000001L,0x0000000808000804L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7336 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7338 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_WITHIN_in_term7343 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_GROUP_in_term7345 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7347 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_ORDER_in_term7349 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_term7351 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7355 = new BitSet(new long[]{0x0000200000001000L});
	public static final BitSet FOLLOW_ASC_in_term7360 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_DESC_in_term7364 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7367 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7392 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7394 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term7398 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7424 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7426 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term7430 = new BitSet(new long[]{0x2008011020620400L,0x000B308800000001L,0x0000000808000804L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7434 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7436 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term7459 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term7471 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7475 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term7495 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7497 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_term7501 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term7503 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_term7507 = new BitSet(new long[]{0x0000000000000400L,0x0000001800000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_LPAREN_in_term7510 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7514 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_COMMA_in_term7517 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7521 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7525 = new BitSet(new long[]{0x0000000000000400L,0x0000001000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_ARRAY_in_term7532 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_LSQUARE_in_term7537 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_term7539 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_term7544 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7567 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_CURRENT_in_term7571 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_VALUE_in_term7574 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7576 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7608 = new BitSet(new long[]{0x0008010000020000L,0x000A100000000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7613 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_VALUES_in_term7615 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7617 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7621 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7666 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions7672 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7678 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7709 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths7715 = new BitSet(new long[]{0x0008010000000000L,0x000A100000000001L,0x0000000808000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7721 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions7754 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions7762 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions7768 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types7799 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types7806 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types7812 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument7837 = new BitSet(new long[]{0x0000080200000402L,0x0000015800000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument7840 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7844 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_COMMA_in_function_argument7847 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7851 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument7855 = new BitSet(new long[]{0x0000080200000402L,0x0000015000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument7861 = new BitSet(new long[]{0x0000080200000002L,0x0000015000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument7867 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7872 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument7876 = new BitSet(new long[]{0x0000080200000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument7885 = new BitSet(new long[]{0x0000080000000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument7890 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7892 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_function_argument7898 = new BitSet(new long[]{0x0000000000000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument7903 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7905 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_function_argument7911 = new BitSet(new long[]{0x0000000000000002L,0x0000004000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument7917 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7919 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_function_argument7925 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list7955 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list7961 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list7967 = new BitSet(new long[]{0x0008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list7973 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list7980 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name8001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name8028 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_name8056 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_name8070 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name8072 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_table_name8076 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_from_table_name8104 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_from_table_name8118 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name8120 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_identifier_in_from_table_name8124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind8156 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind8170 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8202 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal8216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal8230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal8245 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal8262 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal8274 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal8287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal8301 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8305 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal8336 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name8364 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name8377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier8406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved8433 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8460 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8464 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8467 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8471 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8473 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8477 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8484 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8488 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8494 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8504 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8507 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8511 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8513 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8517 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8524 = new BitSet(new long[]{0x2008011000620400L,0x000B308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_expression_in_case_statement8528 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8534 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL6231 = new BitSet(new long[]{0x2008011000620400L,0x000A308800000001L,0x0000000808000004L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6234 = new BitSet(new long[]{0x0000000000000002L});
}
