/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;

public class PhoenixRpcScheduler
extends RpcScheduler {
    private static final String CALL_QUEUE_HANDLER_FACTOR_CONF_KEY = "ipc.server.callqueue.handler.factor";
    private static final String CALLQUEUE_LENGTH_CONF_KEY = "ipc.server.max.callqueue.length";
    private static final int DEFAULT_MAX_CALLQUEUE_LENGTH_PER_HANDLER = 10;
    private RpcScheduler delegate;
    private int indexPriority;
    private int metadataPriority;
    private RpcExecutor indexCallExecutor;
    private RpcExecutor metadataCallExecutor;
    private int port;

    public PhoenixRpcScheduler(Configuration conf, RpcScheduler delegate, int indexPriority, int metadataPriority) {
        int indexHandlerCount = conf.getInt("phoenix.rpc.index.handler.count", 20);
        int metadataHandlerCount = conf.getInt("phoenix.rpc.metadata.handler.count", 20);
        int maxIndexQueueLength = conf.getInt(CALLQUEUE_LENGTH_CONF_KEY, indexHandlerCount * 10);
        int maxMetadataQueueLength = conf.getInt(CALLQUEUE_LENGTH_CONF_KEY, metadataHandlerCount * 10);
        float callQueuesHandlersFactor = conf.getFloat(CALL_QUEUE_HANDLER_FACTOR_CONF_KEY, 0.0f);
        int numIndexQueues = Math.max(1, Math.round((float)indexHandlerCount * callQueuesHandlersFactor));
        int numMetadataQueues = Math.max(1, Math.round((float)metadataHandlerCount * callQueuesHandlersFactor));
        this.indexPriority = indexPriority;
        this.metadataPriority = metadataPriority;
        this.delegate = delegate;
        this.indexCallExecutor = new BalancedQueueRpcExecutor("Index", indexHandlerCount, numIndexQueues, maxIndexQueueLength);
        this.metadataCallExecutor = new BalancedQueueRpcExecutor("Metadata", metadataHandlerCount, numMetadataQueues, maxMetadataQueueLength);
    }

    public void init(RpcScheduler.Context context) {
        this.delegate.init(context);
        this.port = context.getListenerAddress().getPort();
    }

    public void start() {
        this.delegate.start();
        this.indexCallExecutor.start(this.port);
        this.metadataCallExecutor.start(this.port);
    }

    public void stop() {
        this.delegate.stop();
        this.indexCallExecutor.stop();
        this.metadataCallExecutor.stop();
    }

    public void dispatch(CallRunner callTask) throws InterruptedException, IOException {
        RpcServer.Call call = callTask.getCall();
        int priority = call.header.getPriority();
        if (this.indexPriority == priority) {
            this.indexCallExecutor.dispatch(callTask);
        } else if (this.metadataPriority == priority) {
            this.metadataCallExecutor.dispatch(callTask);
        } else {
            this.delegate.dispatch(callTask);
        }
    }

    public int getGeneralQueueLength() {
        return this.delegate.getGeneralQueueLength() + this.indexCallExecutor.getQueueLength() + this.metadataCallExecutor.getQueueLength();
    }

    public int getPriorityQueueLength() {
        return this.delegate.getPriorityQueueLength();
    }

    public int getReplicationQueueLength() {
        return this.delegate.getReplicationQueueLength();
    }

    public int getActiveRpcHandlerCount() {
        return this.delegate.getActiveRpcHandlerCount() + this.indexCallExecutor.getActiveHandlerCount() + this.metadataCallExecutor.getActiveHandlerCount();
    }

    @VisibleForTesting
    public void setIndexExecutorForTesting(RpcExecutor executor) {
        this.indexCallExecutor = executor;
    }

    @VisibleForTesting
    public void setMetadataExecutorForTesting(RpcExecutor executor) {
        this.metadataCallExecutor = executor;
    }
}

