/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.phoenix.coprocessor.DelegateRegionScanner;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.util.ServerUtil;

public class DataTableLocalIndexRegionScanner
extends DelegateRegionScanner {
    MultiKeyValueTuple result = new MultiKeyValueTuple();
    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    KeyValueBuilder kvBuilder = GenericKeyValueBuilder.INSTANCE;
    private List<IndexMaintainer> indexMaintainers;
    private byte[] startKey;
    private byte[] endKey;
    private byte[] localIndexFamily;
    private Region region;
    long maxBatchSizeBytes;
    int maxBatchSize;
    private UngroupedAggregateRegionObserver.MutationList mutationList;

    public DataTableLocalIndexRegionScanner(RegionScanner scanner, Region region, List<IndexMaintainer> indexMaintainers, byte[] localIndexFamily, Configuration conf) throws IOException {
        super(scanner);
        this.indexMaintainers = indexMaintainers;
        this.startKey = region.getRegionInfo().getStartKey();
        this.endKey = region.getRegionInfo().getEndKey();
        this.localIndexFamily = localIndexFamily;
        this.region = region;
        this.maxBatchSize = conf.getInt("phoenix.mutate.batchSize", 100);
        this.maxBatchSizeBytes = conf.getLong("phoenix.mutate.batchSizeBytes", 2597152L);
        this.mutationList = new UngroupedAggregateRegionObserver.MutationList(this.maxBatchSize);
    }

    @Override
    public boolean next(List<Cell> outResult, ScannerContext scannerContext) throws IOException {
        return this.next(outResult);
    }

    @Override
    public boolean next(List<Cell> results) throws IOException {
        ArrayList<Cell> dataTableResults = new ArrayList<Cell>();
        boolean next = super.next(dataTableResults);
        this.addMutations(dataTableResults);
        if (ServerUtil.readyToCommit(this.mutationList.size(), this.mutationList.byteSize(), this.maxBatchSize, this.maxBatchSizeBytes) || !next) {
            this.region.batchMutate(this.mutationList.toArray(new Mutation[this.mutationList.size()]), 0L, 0L);
            this.mutationList.clear();
        }
        return next;
    }

    private void addMutations(List<Cell> dataTableResults) throws IOException {
        if (!dataTableResults.isEmpty()) {
            this.result.setKeyValues(dataTableResults);
            for (IndexMaintainer maintainer : this.indexMaintainers) {
                this.result.getKey(this.ptr);
                ValueGetter valueGetter = maintainer.createGetterFromKeyValues(ImmutableBytesPtr.copyBytesIfNecessary(this.ptr), dataTableResults);
                List list = (List)maintainer.buildUpdateMutation(this.kvBuilder, valueGetter, this.ptr, dataTableResults.get(0).getTimestamp(), this.startKey, this.endKey).getFamilyCellMap().get(this.localIndexFamily);
                Put put = null;
                Delete del = null;
                for (Cell cell : list) {
                    if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                        if (put == null) {
                            put = new Put(CellUtil.cloneRow((Cell)cell));
                            this.mutationList.add((Mutation)put);
                        }
                        put.add(cell);
                        continue;
                    }
                    if (del == null) {
                        del = new Delete(CellUtil.cloneRow((Cell)cell));
                        this.mutationList.add((Mutation)del);
                    }
                    del.addDeleteMarker(cell);
                }
            }
        }
    }
}

