/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.phoenix.index.IndexMaintainer;

public class IndexHalfStoreFileReader
extends StoreFile.Reader {
    private final boolean top;
    private final byte[] splitkey;
    private final byte[] splitRow;
    private final Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers;
    private final byte[][] viewConstants;
    private final int offset;
    private final HRegionInfo regionInfo;
    private final byte[] regionStartKeyInHFile;

    public IndexHalfStoreFileReader(FileSystem fs, Path p, CacheConfig cacheConf, FSDataInputStreamWrapper in, long size, Reference r, Configuration conf, Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers, byte[][] viewConstants, HRegionInfo regionInfo, byte[] regionStartKeyInHFile, byte[] splitKey) throws IOException {
        super(fs, p, in, size, cacheConf, conf);
        this.splitkey = splitKey == null ? r.getSplitKey() : splitKey;
        this.top = Reference.isTopFileRegion((Reference.Range)r.getFileRegion());
        this.splitRow = CellUtil.cloneRow((Cell)KeyValue.createKeyValueFromKey((byte[])this.splitkey));
        this.indexMaintainers = indexMaintainers;
        this.viewConstants = viewConstants;
        this.regionInfo = regionInfo;
        this.regionStartKeyInHFile = regionStartKeyInHFile;
        this.offset = regionStartKeyInHFile.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[][] getViewConstants() {
        return this.viewConstants;
    }

    public Map<ImmutableBytesWritable, IndexMaintainer> getIndexMaintainers() {
        return this.indexMaintainers;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public byte[] getRegionStartKeyInHFile() {
        return this.regionStartKeyInHFile;
    }

    public byte[] getSplitkey() {
        return this.splitkey;
    }

    public byte[] getSplitRow() {
        return this.splitRow;
    }

    public boolean isTop() {
        return this.top;
    }
}

