/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.index.IndexMaintainer;

public class LocalIndexStoreFileScanner
extends StoreFileScanner {
    private IndexHalfStoreFileReader reader = (IndexHalfStoreFileReader)super.getReader();
    private boolean changeBottomKeys = this.reader.getRegionInfo().getStartKey().length == 0 && this.reader.getSplitRow().length != this.reader.getOffset();

    public LocalIndexStoreFileScanner(StoreFile.Reader reader, HFileScanner hfs, boolean useMVCC, boolean hasMVCC, long readPt) {
        super(reader, hfs, useMVCC, hasMVCC, readPt);
    }

    public Cell next() throws IOException {
        Cell next = super.next();
        while (next != null && !this.isSatisfiedMidKeyCondition(next)) {
            next = super.next();
        }
        while (super.peek() != null && !this.isSatisfiedMidKeyCondition(super.peek())) {
            super.next();
        }
        if (next != null && (this.reader.isTop() || this.changeBottomKeys)) {
            next = this.getChangedKey(next, !this.reader.isTop() && this.changeBottomKeys);
        }
        return next;
    }

    public Cell peek() {
        Cell peek = super.peek();
        if (peek != null && (this.reader.isTop() || this.changeBottomKeys)) {
            peek = this.getChangedKey(peek, !this.reader.isTop() && this.changeBottomKeys);
        }
        return peek;
    }

    private KeyValue getChangedKey(Cell next, boolean changeBottomKeys) {
        byte[] changedKey = this.getNewRowkeyByRegionStartKeyReplacedWithSplitKey(next, changeBottomKeys);
        KeyValue changedKv = new KeyValue(changedKey, 0, changedKey.length, next.getFamilyArray(), next.getFamilyOffset(), (int)next.getFamilyLength(), next.getQualifierArray(), next.getQualifierOffset(), next.getQualifierLength(), next.getTimestamp(), KeyValue.Type.codeToType((byte)next.getTypeByte()), next.getValueArray(), next.getValueOffset(), next.getValueLength(), next.getTagsArray(), next.getTagsOffset(), next.getTagsLength());
        return changedKv;
    }

    public boolean requestSeek(Cell kv, boolean forward, boolean useBloom) throws IOException {
        boolean requestSeek = super.requestSeek(kv, forward, useBloom);
        if (requestSeek) {
            Cell peek = super.peek();
            if (Bytes.compareTo((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])peek.getRowArray(), (int)peek.getRowOffset(), (int)peek.getRowLength()) == 0) {
                return forward ? this.reseek(kv) : this.seek(kv);
            }
        }
        return requestSeek;
    }

    public boolean seek(Cell key) throws IOException {
        return this.seekOrReseek(key, true);
    }

    public boolean reseek(Cell key) throws IOException {
        return this.seekOrReseek(key, false);
    }

    public boolean seekToPreviousRow(Cell key) throws IOException {
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)key);
        if (this.reader.isTop()) {
            byte[] fk = this.reader.getFirstKey();
            if (fk == null) {
                return false;
            }
            if (this.getComparator().compare(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), fk, 0, fk.length) <= 0) {
                return super.seekToPreviousRow(key);
            }
            KeyValue replacedKey = this.getKeyPresentInHFiles(kv.getBuffer());
            boolean seekToPreviousRow = super.seekToPreviousRow((Cell)replacedKey);
            while (super.peek() != null && !this.isSatisfiedMidKeyCondition(super.peek())) {
                seekToPreviousRow = super.seekToPreviousRow(super.peek());
            }
            return seekToPreviousRow;
        }
        if (this.getComparator().compare(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), this.reader.getSplitkey(), 0, this.reader.getSplitkey().length) >= 0) {
            boolean seekToPreviousRow = super.seekToPreviousRow((Cell)kv);
            while (super.peek() != null && !this.isSatisfiedMidKeyCondition(super.peek())) {
                seekToPreviousRow = super.seekToPreviousRow(super.peek());
            }
            return seekToPreviousRow;
        }
        boolean seekToPreviousRow = super.seekToPreviousRow((Cell)kv);
        while (super.peek() != null && !this.isSatisfiedMidKeyCondition(super.peek())) {
            seekToPreviousRow = super.seekToPreviousRow(super.peek());
        }
        return seekToPreviousRow;
    }

    public boolean seekToLastRow() throws IOException {
        boolean seekToLastRow = super.seekToLastRow();
        while (super.peek() != null && !this.isSatisfiedMidKeyCondition(super.peek())) {
            seekToLastRow = super.seekToPreviousRow(super.peek());
        }
        return seekToLastRow;
    }

    private boolean isSatisfiedMidKeyCondition(Cell kv) {
        ImmutableBytesWritable rowKey = new ImmutableBytesWritable(kv.getRowArray(), kv.getRowOffset() + this.reader.getOffset(), kv.getRowLength() - this.reader.getOffset());
        Map.Entry<ImmutableBytesWritable, IndexMaintainer> entry = this.reader.getIndexMaintainers().entrySet().iterator().next();
        IndexMaintainer indexMaintainer = entry.getValue();
        byte[] viewIndexId = indexMaintainer.getViewIndexIdFromIndexRowKey(rowKey);
        IndexMaintainer actualIndexMaintainer = this.reader.getIndexMaintainers().get(new ImmutableBytesWritable(viewIndexId));
        if (actualIndexMaintainer != null) {
            byte[] dataRowKey = actualIndexMaintainer.buildDataRowKey(rowKey, this.reader.getViewConstants());
            int compareResult = Bytes.compareTo((byte[])dataRowKey, (byte[])this.reader.getSplitRow());
            if (this.reader.isTop() ? compareResult >= 0 : compareResult < 0) {
                return true;
            }
        }
        return false;
    }

    private KeyValue getKeyPresentInHFiles(byte[] key) {
        KeyValue keyValue = new KeyValue(key);
        short rowLength = keyValue.getRowLength();
        int rowOffset = keyValue.getRowOffset();
        short length = (short)(rowLength - this.reader.getSplitRow().length + this.reader.getOffset());
        byte[] replacedKey = new byte[length + key.length - (rowOffset + rowLength) + 2];
        System.arraycopy(Bytes.toBytes((short)length), 0, replacedKey, 0, 2);
        System.arraycopy(this.reader.getRegionStartKeyInHFile(), 0, replacedKey, 2, this.reader.getOffset());
        System.arraycopy(keyValue.getRowArray(), keyValue.getRowOffset() + this.reader.getSplitRow().length, replacedKey, this.reader.getOffset() + 2, rowLength - this.reader.getSplitRow().length);
        System.arraycopy(key, rowOffset + rowLength, replacedKey, this.reader.getOffset() + keyValue.getRowLength() - this.reader.getSplitRow().length + 2, key.length - (rowOffset + rowLength));
        return new KeyValue.KeyOnlyKeyValue(replacedKey);
    }

    public boolean seekOrReseek(Cell cell, boolean isSeek) throws IOException {
        KeyValue kv;
        KeyValue keyToSeek = kv = KeyValueUtil.ensureKeyValue((Cell)cell);
        if (this.reader.isTop()) {
            if (this.getComparator().compare(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), this.reader.getSplitkey(), 0, this.reader.getSplitkey().length) < 0) {
                if (!isSeek && this.realSeekDone()) {
                    return true;
                }
                return this.seekOrReseekToProperKey(isSeek, keyToSeek);
            }
            keyToSeek = this.getKeyPresentInHFiles(kv.getBuffer());
            return this.seekOrReseekToProperKey(isSeek, keyToSeek);
        }
        if (this.getComparator().compare(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), this.reader.getSplitkey(), 0, this.reader.getSplitkey().length) >= 0) {
            this.close();
            return false;
        }
        if (!isSeek && this.reader.getRegionInfo().getStartKey().length == 0 && this.reader.getSplitRow().length > this.reader.getRegionStartKeyInHFile().length) {
            keyToSeek = this.getKeyPresentInHFiles(kv.getBuffer());
        }
        return this.seekOrReseekToProperKey(isSeek, keyToSeek);
    }

    private boolean seekOrReseekToProperKey(boolean isSeek, KeyValue kv) throws IOException {
        boolean seekOrReseek;
        boolean bl = seekOrReseek = isSeek ? super.seek((Cell)kv) : super.reseek((Cell)kv);
        while (seekOrReseek && super.peek() != null && !this.isSatisfiedMidKeyCondition(super.peek())) {
            super.next();
            seekOrReseek = super.peek() != null;
        }
        return seekOrReseek;
    }

    private byte[] getNewRowkeyByRegionStartKeyReplacedWithSplitKey(Cell kv, boolean changeBottomKeys) {
        int lenOfRemainingKey = kv.getRowLength() - this.reader.getOffset();
        byte[] keyReplacedStartKey = new byte[lenOfRemainingKey + this.reader.getSplitRow().length];
        System.arraycopy(changeBottomKeys ? new byte[this.reader.getSplitRow().length] : this.reader.getSplitRow(), 0, keyReplacedStartKey, 0, this.reader.getSplitRow().length);
        System.arraycopy(kv.getRowArray(), kv.getRowOffset() + this.reader.getOffset(), keyReplacedStartKey, this.reader.getSplitRow().length, lenOfRemainingKey);
        return keyReplacedStartKey;
    }
}

