/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.codec.Codec;

public abstract class BinaryCompatibleBaseDecoder
implements Codec.Decoder {
    protected static final Log LOG = LogFactory.getLog(BinaryCompatibleBaseDecoder.class);
    protected final InputStream in;
    private Cell current = null;

    public BinaryCompatibleBaseDecoder(InputStream in) {
        this.in = new PBIS(in, 1);
    }

    public boolean advance() throws IOException {
        int firstByte = this.in.read();
        if (firstByte == -1) {
            return false;
        }
        ((PBIS)this.in).unread(firstByte);
        try {
            this.current = this.parseCell();
        }
        catch (IOException ioEx) {
            ((PBIS)this.in).resetBuf(1);
            this.rethrowEofException(ioEx);
        }
        return true;
    }

    private void rethrowEofException(IOException ioEx) throws IOException {
        boolean isEof = false;
        try {
            isEof = this.in.available() == 0;
        }
        catch (Throwable t) {
            LOG.trace((Object)"Error getting available for error message - ignoring", t);
        }
        if (!isEof) {
            throw ioEx;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Partial cell read caused by EOF", (Throwable)ioEx);
        }
        EOFException eofEx = new EOFException("Partial cell read");
        eofEx.initCause(ioEx);
        throw eofEx;
    }

    protected InputStream getInputStream() {
        return this.in;
    }

    @Nonnull
    protected abstract Cell parseCell() throws IOException;

    public Cell current() {
        return this.current;
    }

    protected static class PBIS
    extends PushbackInputStream {
        public PBIS(InputStream in, int size) {
            super(in, size);
        }

        public void resetBuf(int size) {
            this.buf = new byte[size];
            this.pos = size;
        }
    }
}

