/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.io.IOException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class ListJarsQueryPlan
implements QueryPlan {
    private PhoenixStatement stmt = null;
    private StatementContext context = null;
    private boolean first = true;
    private static final RowProjector JARS_PROJECTOR;

    public ListJarsQueryPlan(PhoenixStatement stmt) {
        this.stmt = stmt;
        this.context = new StatementContext(stmt);
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        return ExplainPlan.EMPTY_PLAN;
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan s) throws SQLException {
        return this.iterator(scanGrouper);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return new ResultIterator(){
            private RemoteIterator<LocatedFileStatus> listFiles = null;

            @Override
            public void close() throws SQLException {
            }

            @Override
            public Tuple next() throws SQLException {
                try {
                    if (ListJarsQueryPlan.this.first) {
                        String dynamicJarsDir = ListJarsQueryPlan.this.stmt.getConnection().getQueryServices().getProps().get("hbase.dynamic.jars.dir");
                        if (dynamicJarsDir == null) {
                            throw new SQLException("hbase.dynamic.jars.dir is not configured for the listing the jars.");
                        }
                        dynamicJarsDir = dynamicJarsDir.endsWith("/") ? dynamicJarsDir : dynamicJarsDir + '/';
                        Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
                        Path dynamicJarsDirPath = new Path(dynamicJarsDir);
                        FileSystem fs = dynamicJarsDirPath.getFileSystem(conf);
                        this.listFiles = fs.listFiles(dynamicJarsDirPath, true);
                        ListJarsQueryPlan.this.first = false;
                    }
                    if (this.listFiles == null || !this.listFiles.hasNext()) {
                        return null;
                    }
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    ParseNodeFactory factory = new ParseNodeFactory();
                    LiteralParseNode literal = factory.literal(((LocatedFileStatus)this.listFiles.next()).getPath().toString());
                    LiteralExpression expression = LiteralExpression.newConstant(literal.getValue(), (PDataType)PVarchar.INSTANCE, Determinism.ALWAYS);
                    expression.evaluate(null, ptr);
                    byte[] rowKey = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    Cell cell = CellUtil.createCell((byte[])rowKey, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])HConstants.EMPTY_BYTE_ARRAY, (long)EnvironmentEdgeManager.currentTimeMillis(), (byte)KeyValue.Type.Put.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
                    ArrayList<Cell> cells = new ArrayList<Cell>(1);
                    cells.add(cell);
                    return new ResultTuple(Result.create(cells));
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public void explain(List<String> planSteps) {
            }
        };
    }

    @Override
    public long getEstimatedSize() {
        return PVarchar.INSTANCE.getByteSize().intValue();
    }

    @Override
    public TableRef getTableRef() {
        return null;
    }

    @Override
    public RowProjector getProjector() {
        return JARS_PROJECTOR;
    }

    @Override
    public Integer getLimit() {
        return null;
    }

    @Override
    public Integer getOffset() {
        return null;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return GroupByCompiler.GroupBy.EMPTY_GROUP_BY;
    }

    @Override
    public List<KeyRange> getSplits() {
        return Collections.emptyList();
    }

    @Override
    public List<List<Scan>> getScans() {
        return Collections.emptyList();
    }

    @Override
    public FilterableStatement getStatement() {
        return null;
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return false;
    }

    @Override
    public boolean useRoundRobinIterator() {
        return false;
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return Collections.emptySet();
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return this.stmt.getUpdateOperation();
    }

    @Override
    public Long getEstimatedRowsToScan() {
        return 0L;
    }

    @Override
    public Long getEstimatedBytesToScan() {
        return 0L;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        return 0L;
    }

    static {
        ArrayList<ExpressionProjector> projectedColumns = new ArrayList<ExpressionProjector>();
        PName colName = PNameFactory.newName("jar_location");
        PColumnImpl column = new PColumnImpl(colName, null, PVarchar.INSTANCE, null, null, false, 0, SortOrder.getDefault(), 0, null, false, null, false, false, colName.getBytes());
        ArrayList<PColumnImpl> columns = new ArrayList<PColumnImpl>();
        columns.add(column);
        RowKeyColumnExpression expression = new RowKeyColumnExpression(column, new RowKeyValueAccessor(columns, 0));
        projectedColumns.add(new ExpressionProjector("jar_location", "", expression, true));
        int estimatedByteSize = 64;
        JARS_PROJECTOR = new RowProjector(projectedColumns, estimatedByteSize, false);
    }
}

